/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;

/**
 * The Data Provider for the title compare tables
 * 
 * @author Vijay Silva
 */
public abstract class TitleCompareDataProvider<K, R extends TitleCompareRecord<K>> implements
        DataProvider<K, R> {

	/* Properties */
	private final TitleCompareTable<K, R> table;

	/**
	 * Constructor
	 * 
	 * @param parentTable The parent table
	 */
	public TitleCompareDataProvider(TitleCompareTable<K, R> parentTable) {
		this.table = parentTable;
	}

	/**
	 * @return the table
	 */
	protected TitleCompareTable<K, R> getTable() {
		return table;
	}

	/**
	 * @return the report
	 */
	protected TitleCompareViewInput getInput() 
	{
		return table.getInput();
	}

	/**
	 * @return the sortFeature
	 */
	public abstract SortFeature<K, R> getSortFeature();

	// ========================================================================
	// ===================== DATA PROVIDER METHODS
	// ========================================================================

	/*
	 * Get the records from the cached model
	 */
	@Override
	public void getRecords(AsyncCallback<List<R>> callback) {
		/* Get the records */
		List<R> records = getRecords();

		/* Return the records to callback */
		callback.onSuccess(records);

		/* Notify listeners that the records are fetched */
		table.handleRecordsUpdated();
	}

	/*
	 * Does nothing
	 */
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	/*
	 * No check boxes for selection
	 */
	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	/*
	 * No record count to show at bottom of table
	 */
	@Override
	public boolean isRecordCountEnabled() {
		return false;
	}

	// ========================================================================
	// ===================== RECORD MANAGEMENT
	// ========================================================================

	/**
	 * Get the records to show
	 */
	protected List<R> getRecords() {
		/* Build the records */
		List<R> records = buildRecords();

		/* Sort the records */
		sortRecords(records);

		return records;
	}

	/*
	 * Get the records from the cached UI Model
	 */
	protected abstract List<R> buildRecords();

	/*
	 * Build the comparator used to sort the records
	 */
	protected abstract Comparator<R> getComparator();

	/*
	 * Sort the records using the sort feature information, or default sorting otherwise
	 */
	protected void sortRecords(List<R> records) {
		/* Sort the records */
		Collections.sort(records, getComparator());
	}

	/*
	 * Get the column used for sorting
	 */
	protected Column<?, R> getSortColumn() {
		/* Get the column from the feature */
		Column<?, R> sortColumn = getSortFeature().getSortColumn();
		if (sortColumn == null) {
			sortColumn = getSortFeature().getDefaultSortColumn();
		}

		return sortColumn;
	}

	/*
	 * Get the sort order to use
	 */
	protected SortOrder getSortOrder() {
		/* Get the sort order */
		SortOrder order = getSortFeature().getSortOrder();
		if (order == null) {
			order = getSortFeature().getDefaultSortOrder();
		}

		return order;
	}
}
