/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table;

import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * A Record for displaying any Title Comparison data.
 * 
 * @author Vijay Silva
 */
public abstract class TitleCompareRecord<T> implements Record<T> 
{
	/* The record data */
	private TitleCompareViewInput input;
	private T key;

	/**
	 * Constructor
	 * 
	 * @param input The input
	 * @param key The record key
	 */
	public TitleCompareRecord(TitleCompareViewInput input, T key) 
	{
		this.input = input;
		this.key = key;
	}

	@Override
	public T getKey() 
	{
		return this.key;
	}

	/**
	 * @return the report
	 */
	public TitleCompareViewInput getInput() 
	{
		return input;
	}
}
