/*
 * Created on Apr 26, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table;

import java.util.Comparator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

/**
 * Comparator used for sorting the table data based on the provided column and sort order
 * 
 * @author Vijay Silva
 */
public abstract class TitleCompareRecordComparator<T extends TitleCompareRecord<?>> implements
        Comparator<T> {

	/* Properties */
	private final Column<?, T> column;
	private final SortOrder sortOrder;

	/**
	 * Constructor
	 * 
	 * @param column The column
	 * @param sortOrder The sort order
	 */
	public TitleCompareRecordComparator(Column<?, T> column, SortOrder sortOrder) {
		this.column = column;
		this.sortOrder = sortOrder;
	}

	/**
	 * @return the column
	 */
	protected Column<?, T> getColumn() {
		return column;
	}

	/**
	 * @return the sortOrder
	 */
	protected SortOrder getSortOrder() {
		return sortOrder;
	}

	/**
	 * Compare two comparable values. If equal, use distinct comparison.
	 */
	protected <C extends Comparable<C>> int compareValues(C value1, C value2, T record1, T record2) {
		int compare = compareValues(value1, value2);

		/* If the values are equal, use the default compare */
		if (compare == 0) {
			compare = keyCompare(record1, record2);
		}

		return compare;
	}

	/**
	 * After comparison, the records may be equal. In order to ensure that the records do not
	 * randomly sort, this comparison should ensure that records are compared by some key.
	 * 
	 * @param record1 The first record to compare
	 * @param record2 The second record to compare
	 */
	protected abstract int keyCompare(T record1, T value2);

	/**
	 * Compare any two comparable objects, and handle null values as well. Also take care of
	 * ascending versus descending sorting.
	 * 
	 * @param value1 The first object to compare
	 * @param value2 The second object to compare
	 */
	protected <C extends Comparable<C>> int compareValues(C value1, C value2) {
		int compare = 0;

		/* If both are not null, compare with each other */
		if (value1 != null && value2 != null) {
			compare = value1.compareTo(value2);
		}
		/* Either value1 or value2 is not null */
		else if (value1 != value2) {
			compare = (value1 != null) ? 1 : -1;
		}

		/* If the sort order is descending, flip the compare value */
		if (SortOrder.DESCENDING.equals(sortOrder)) {
			compare *= -1;
		}

		return compare;
	}
}
