/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * The Table Column that is used for the title comparison tables
 * 
 * @author Vijay Silva
 */
public abstract class TitleCompareTableColumn<T extends TitleCompareRecord<?>> extends
        ColumnBase<T, T> implements Column<T, T> {

	/* The style name to use for widgets generated */
	private String styleName = null;

	/**
	 * Constructor. Do not use this constructor for metadata fields
	 * 
	 * @param name The column name
	 * @param displayName The column display name
	 */
	public TitleCompareTableColumn(String name, String displayName) {
		super(name, displayName);
	}

	/**
	 * @return the styleName
	 */
	public String getStyleName() {
		return styleName;
	}

	/**
	 * @param styleName the styleName to set
	 */
	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	/*
	 * Generate a view that contains a label
	 */
	@Override
	public View<T> getView(T record) {
		Widget widget = getWidget(record);
		String styleName = getStyleName(record);
		return new ColumnView<T>(widget, styleName, record, getName());
	}

	/**
	 * Build the widget for the record for this column
	 * 
	 * @return The widget
	 */
	protected abstract Widget getWidget(T record);

	/**
	 * Provide a overriding style name for record for this column
	 * 
	 * @return the style name to use
	 */
	protected String getStyleName(T record) {
		return this.styleName;
	}

	/*
	 * The internal view class
	 */
	private static final class ColumnView<T extends TitleCompareRecord<?>> implements View<T> {

		private Widget widget;
		private String styleName;
		private T record;
		private String columnName;

		/**
		 * Constructor
		 */
		public ColumnView(Widget widget, String styleName, T record, String columnName) {
			this.widget = widget;
			this.styleName = styleName;
			this.record = record;
			this.columnName = columnName;
		}

		@Override
		public String getStyleName() {
			return this.styleName;
		}

		@Override
		public Widget getWidget() {
			return widget;
		}

		@Override
		public void release() {
		}

		/**
		 * @return the record
		 */
		public T getRecord() {
			return record;
		}

		/**
		 * @return the columnName
		 */
		public String getColumnName() {
			return columnName;
		}
	}
}
