/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn.ASSET_TYPE_COLUMN_NAME;
import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn.DIFFERENCE_TYPE_COLUMN_NAME;
import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn.FILE1ID_COLUMN_NAME;
import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset.AssetCompareTableColumn.FILE2ID_COLUMN_NAME;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifferenceType;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareDataProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

/**
 * The Data Provider for the Asset Compare Table
 * 
 * @author Vijay Silva
 */
class AssetCompareDataProvider extends
        TitleCompareDataProvider<UIAssetDifference, AssetCompareRecord> implements
        DataProvider<UIAssetDifference, AssetCompareRecord> 
{

	/* Properties */
	private List<Column<?, AssetCompareRecord>> columns;
	private SortFeature<UIAssetDifference, AssetCompareRecord> sortFeature;
	
	/**
	 * Constructor
	 * 
	 * @param table The parent table
	 */
	public AssetCompareDataProvider(AssetCompareTable table) 
	{
		super(table);
		initialize();
	}

	/*
	 * Update the return type of the table
	 */
	@Override
	protected AssetCompareTable getTable() 
	{
		return (AssetCompareTable) super.getTable();
	}

	/**
	 * Determine if this data provider is for a table that is showing file comparision
	 * 
	 * @return true is showing file records, false otherwise
	 */
	public boolean isShowingFiles() 
	{
		return this.getTable().isShowingFiles();
	}

	/**
	 * @return the sortFeature
	 */
	@Override
	public SortFeature<UIAssetDifference, AssetCompareRecord> getSortFeature() {
		return sortFeature;
	}

	// ========================================================================
	// ===================== INITALIZATION
	// ========================================================================

	/*
	 * Build the table columns and sort feature
	 */
	private void initialize() 
	{
		UITitleCompareData compareData = getInput().compareData;
		
		this.columns = new ArrayList<Column<?, AssetCompareRecord>>();
		AssetCompareTableColumn sortColumn = null;
		SortOrder order = SortOrder.ASCENDING;

		/* Build the Asset Type Column */
		String displayName = getTable().getMessages().assetTableAssetTypeColumnName();
		sortColumn = new AssetCompareTableColumn(getTable(), ASSET_TYPE_COLUMN_NAME, displayName);
		columns.add(sortColumn);

		/* Build the Asset Metadata Columns */
		for (UiColumn column : compareData.getAssetMetadataTable().getColumns()) {
			String name = column.getName();
			displayName = column.getDisplayName();
			columns.add(new AssetCompareTableColumn(getTable(), name, displayName, false));
		}

		/* Build the File related columns */
		if (isShowingFiles()) {
			/* Show the File IDs */
			displayName = getTable().getMessages().assetTableFile1IDColumnName();
			columns.add(new AssetCompareTableColumn(getTable(), FILE1ID_COLUMN_NAME, displayName));
			displayName = getTable().getMessages().assetTableFile2IDColumnName();
			columns.add(new AssetCompareTableColumn(getTable(), FILE2ID_COLUMN_NAME, displayName));

			/* Add the File Metadata */
			for (UiColumn column : compareData.getFileMetadataTable().getColumns()) {
				String name = column.getName();
				displayName = column.getDisplayName();
				columns.add(new AssetCompareTableColumn(getTable(), name, displayName, true));
			}
		}

		/* Build the difference type column */
		displayName = getTable().getMessages().assetTableDifferenceTypeColumnName();
		AssetCompareTableColumn differenceTypeColumn = new AssetCompareTableColumn(getTable(),
		        DIFFERENCE_TYPE_COLUMN_NAME, displayName);
		differenceTypeColumn.setStyleName(TableConstants.STYLE_DATA_LINK);
		columns.add(differenceTypeColumn);

		/* Build the sort feature */
		sortFeature = new SortFeatureImpl<UIAssetDifference, AssetCompareRecord>(sortColumn, order);
		sortFeature.getSortableColumns().addAll(columns);
	}

	// ========================================================================
	// ===================== DATA PROVIDER METHODS
	// ========================================================================

	/*
	 * Return the built columns
	 */
	@Override
	public List<Column<?, AssetCompareRecord>> getColumns() {
		return this.columns;
	}

	/*
	 * Given the key, get the record. Wraps the key in a new record object
	 */
	@Override
	public void getRecord(UIAssetDifference key, AsyncCallback<AssetCompareRecord> callback) {
		callback.onSuccess(getRecord(key));
	}

	/*
	 * Adding override to allow package protected access
	 */
	@Override
	protected List<AssetCompareRecord> getRecords() {
		return super.getRecords();
	}

	/**
	 * Get a record given the key
	 * 
	 * @param key The difference
	 * @return The record
	 */
	AssetCompareRecord getRecord(UIAssetDifference key) {
		return new AssetCompareRecord(getInput(), key, getTable().getMessages());
	}

	// ========================================================================
	// ===================== RECORD MANAGEMENT
	// ========================================================================

	/*
	 * Get the records from the cached UI Model
	 */
	@Override
	protected List<AssetCompareRecord> buildRecords() 
	{
		UITitleCompareData compareData = getInput().compareData;
		
		List<AssetCompareRecord> records = new ArrayList<AssetCompareRecord>();

		/* Check if there is any difference */
		if (!compareData.getReport().isDifferent()) {
			return records;
		}

		/* Get the records */
		getRecords(compareData.getReport().getAssetDifference(), records);

		return records;
	}

	/*
	 * Get the records recursively
	 */
	private void getRecords(UIAssetDifference difference, List<AssetCompareRecord> records) {
		UIAssetDifferenceType differenceType = difference.getDifferenceType();

		/* Add this difference to the records if required */
		if ((this.isShowingFiles() == difference.isFileAsset())
		        && !UIAssetDifferenceType.NO_DIFFERENCE.equals(differenceType)) {
			records.add(getRecord(difference));
		}

		/* Recursively get the child records */
		for (UIAssetDifference childDifference : difference.getChildDifferences()) {
			getRecords(childDifference, records);
		}
	}

	@Override
	protected AssetCompareRecordComparator getComparator() {
		return new AssetCompareRecordComparator(getSortColumn(), getSortOrder());
	}

	@Override
	protected AssetCompareTableColumn getSortColumn() {
		return (AssetCompareTableColumn) super.getSortColumn();
	}
}
