/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifferenceType;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareRecord;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * A Record representing a {@link UIAssetDifference} object.
 * 
 * @author Vijay Silva
 */
public class AssetCompareRecord extends TitleCompareRecord<UIAssetDifference> implements
        Record<UIAssetDifference> {

	private final TitleCompareViewMessages messages;

	/**
	 * Constructor
	 */
	public AssetCompareRecord(TitleCompareViewInput input, UIAssetDifference difference,
	        TitleCompareViewMessages messages) {
		super(input, difference);
		this.messages = messages;
	}

	/**
	 * Get the display name for the asset type
	 * 
	 * @return The asset type display name
	 */
	public String getAssetTypeName() {
		if (getKey().isFileAsset()) {
			return getKey().getAncestorDifference().getAssetTypeDisplayName();
		}

		return getKey().getAssetTypeDisplayName();
	}

	/**
	 * Get the value of the asset metadata field
	 * 
	 * @param metadataName The metadata name
	 * @return The value
	 */
	public String getAssetMetadataValue(String metadataName) {
		if (getKey().isFileAsset()) {
			return getKey().getAncestorDifference().getMetadata().get(metadataName);
		}

		return getKey().getMetadata().get(metadataName);
	}

	/**
	 * Get the value of the asset metadata field
	 * 
	 * @param metadataName The metadata name
	 * @return The value
	 */
	public String getFileMetadataValue(String metadataName) {
		return getKey().getMetadata().get(metadataName);
	}

	/**
	 * Get the Asset1 ID as a string
	 * 
	 * @return The Asset1 ID
	 */
	public String getAsset1ID() {
		Long id = getKey().getAsset1Id();
		return (id == null) ? "" : id.toString();
	}

	/**
	 * Get the Asset2 ID as a string
	 * 
	 * @return The Asset2 ID
	 */
	public String getAsset2ID() {
		Long id = getKey().getAsset2Id();
		return (id == null) ? "" : id.toString();
	}

	/**
	 * Get the difference type
	 * 
	 * @return The difference type
	 */
	public UIAssetDifferenceType getDifferenceType() {
		return getKey().getDifferenceType();
	}

	/**
	 * Get the display name to use for the difference type
	 * 
	 * @return The display name for the difference type
	 */
	public String getDifferenceTypeName() {
		String value = "";

		UIAssetDifferenceType differenceType = getDifferenceType();
		if (differenceType != null) {
			switch (differenceType) {
				case ASSET1_NOT_DEFINED:
					String name1 = getInput().displayName1;
					value = messages.asset1NotDefinedDifferenceType(name1);
					break;
				case ASSET2_NOT_DEFINED:
					String name2 = getInput().displayName2;
					value = messages.asset2NotDefinedDifferenceType(name2);
					break;
				case METADATA_DIFFERENT:
					value = messages.metadataDifferentDifferenceType();
					break;
				default:
					value = "";
			}
		}

		return value;
	}
}
