/*
 * Created on Apr 28, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import com.google.gwt.event.shared.GwtEvent;

/**
 * @author Vijay Silva
 */
public class AssetCompareRecordClickEvent extends GwtEvent<AssetCompareRecordClickHandler> {

	/* The Handler type */
	private static Type<AssetCompareRecordClickHandler> TYPE;
	private final AssetCompareRecord record;

	/**
	 * Constructor
	 * 
	 * @param record The record
	 */
	public AssetCompareRecordClickEvent(AssetCompareRecord record) {
		this.record = record;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<AssetCompareRecordClickHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<AssetCompareRecordClickHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<AssetCompareRecordClickHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(AssetCompareRecordClickHandler handler) {
		handler.onRecordClicked(this);
	}

	/**
	 * @return the record
	 */
	public AssetCompareRecord getRecord() {
		return record;
	}
}
