/*
 * Created on Apr 26, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import java.util.Comparator;

import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareRecordComparator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

/**
 * Comparator used for sorting the asset compare records
 * 
 * @author Vijay Silva
 */
class AssetCompareRecordComparator extends TitleCompareRecordComparator<AssetCompareRecord>
        implements Comparator<AssetCompareRecord> {

	/**
	 * Constructor
	 */
	public AssetCompareRecordComparator(AssetCompareTableColumn column, SortOrder sortOrder) {
		super(column, sortOrder);
	}

	@Override
	public int compare(AssetCompareRecord o1, AssetCompareRecord o2) {
		String name = getColumn().getName();
		if (name.equals(AssetCompareTableColumn.ASSET_TYPE_COLUMN_NAME)) {
			return compareAssetType(o1, o2);
		} else if (name.equals(AssetCompareTableColumn.FILE1ID_COLUMN_NAME)) {
			return compareFile1ID(o1, o2);
		} else if (name.equals(AssetCompareTableColumn.FILE2ID_COLUMN_NAME)) {
			return compareFile2ID(o1, o2);
		} else if (name.equals(AssetCompareTableColumn.DIFFERENCE_TYPE_COLUMN_NAME)) {
			return compareDifferenceType(o1, o2);
		} else if (name.equals(AssetCompareTableColumn.METADATA_COLUMN_PREFIX)) {
			return compareAssetMetadata(o1, o2);
		} else if (name.equals(AssetCompareTableColumn.FILE_METADATA_COLUMN_PREFIX)) {
			return compareFileMetadata(o1, o2);
		}

		/* Default: the column name is undefined, compare with asset type */
		return compareAssetType(o1, o2);
	}

	@Override
	protected AssetCompareTableColumn getColumn() {
		return (AssetCompareTableColumn) super.getColumn();
	}

	/*
	 * Compare the asset types
	 */
	private int compareAssetType(AssetCompareRecord o1, AssetCompareRecord o2) {
		/* Check if both are null or both are equal */
		return compareValues(o1.getAssetTypeName(), o2.getAssetTypeName(), o1, o2);
	}

	/*
	 * Compare the File1 IDs
	 */
	private int compareFile1ID(AssetCompareRecord o1, AssetCompareRecord o2) {
		return compareValues(o1.getAsset1ID(), o2.getAsset1ID(), o1, o2);
	}

	/*
	 * Compare the File2 IDs
	 */
	private int compareFile2ID(AssetCompareRecord o1, AssetCompareRecord o2) {
		return compareValues(o1.getAsset2ID(), o2.getAsset2ID(), o1, o2);
	}

	private int compareDifferenceType(AssetCompareRecord o1, AssetCompareRecord o2) {
		return compareValues(o1.getDifferenceTypeName(), o2.getDifferenceTypeName(), o1, o2);
	}

	/*
	 * Compare the Asset Metadata
	 */
	private int compareAssetMetadata(AssetCompareRecord o1, AssetCompareRecord o2) {
		String metadataName = getColumn().getMetadataFieldName();
		String value1 = o1.getAssetMetadataValue(metadataName);
		String value2 = o2.getAssetMetadataValue(metadataName);
		return compareValues(value1, value2, o1, o2);
	}

	/*
	 * Compare the File Metadata
	 */
	private int compareFileMetadata(AssetCompareRecord o1, AssetCompareRecord o2) {
		String metadataName = getColumn().getMetadataFieldName();
		String value1 = o1.getFileMetadataValue(metadataName);
		String value2 = o2.getFileMetadataValue(metadataName);
		return compareValues(value1, value2, o1, o2);
	}

	/*
	 * Compare the asset difference by the asset IDs
	 */
	@Override
	protected int keyCompare(AssetCompareRecord o1, AssetCompareRecord o2) {
		/* Compare asset1 IDs */
		int compare = compareValues(o1.getKey().getAsset1Id(), o2.getKey().getAsset1Id());

		/* If the IDs are equal (both null), compare asset2 IDs */
		if (compare == 0) {
			compare = compareValues(o1.getKey().getAsset2Id(), o2.getKey().getAsset2Id());
		}

		return compare;
	}
}
