/*
 * Created on Apr 26, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.asset;

import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

/**
 * Table for comparison of Assets or Files
 * 
 * @author Vijay Silva
 */
public class AssetCompareTable extends TitleCompareTable<UIAssetDifference, AssetCompareRecord> 
{
	/* Properties */
	private boolean showingFiles;

	/* Style Names */
	private static final String STYLE_NAME = "assets";
	private static final String STYLE_MESSAGE_LABEL = "content-AssetCompareTable-messageLabel";

	/**
	 * Constructor
	 */
	public AssetCompareTable(TitleCompareViewMessages messages, boolean showingFiles) 
	{
		super(messages);
		this.showingFiles = showingFiles;
		addStyleDependentName(STYLE_NAME);
	}

	/**
	 * Register handler for the event
	 */
	public HandlerRegistration addRecordClickHandler(AssetCompareRecordClickHandler handler) {
		return addHandler(handler, AssetCompareRecordClickEvent.getType());
	}

	/**
	 * @return the showingFiles
	 */
	public boolean isShowingFiles() {
		return showingFiles;
	}

	/**
	 * Build a record given the key
	 */
	public AssetCompareRecord getRecord(UIAssetDifference key) {
		return getDataProvider().getRecord(key);
	}

	public List<AssetCompareRecord> getRecords() {
		return getDataProvider().getRecords();
	}

	/*
	 * Build the data provider
	 */
	@Override
	protected AssetCompareDataProvider buildDataProvider() 
	{
		return new AssetCompareDataProvider(this);
	}

	/*
	 * Just refresh the table without showing the widget
	 */
	@Override
	protected void handleTableInitializationSuccess() {
		getTable().refresh();
	}

	/*
	 * The table records are updated
	 */
	@Override
	protected void handleRecordsUpdated() {
		if (getTable().getDataRowCount() == 0) {
			LabelWidget messageLabel = new LabelWidget();
			messageLabel.addStyleName(STYLE_MESSAGE_LABEL);
			String message = (isShowingFiles()) ? getMessages().noFileDifferencesMessage()
			        : getMessages().noAssetDifferencesMessage();
			messageLabel.setText(message);
			getContainer().setWidget(messageLabel);
		} else {
			getContainer().setWidget(getTable());
		}
	}

	/*
	 * Override to update the return type
	 */
	@Override
	protected AssetCompareDataProvider getDataProvider() {
		return (AssetCompareDataProvider) super.getDataProvider();
	}

	/*
	 * Handle the click of any data cell in the table for the difference type
	 */
	protected void handleDifferenceTypeColumnClicked(AssetCompareRecord record) {
		fireEvent(new AssetCompareRecordClickEvent(record));
	}
}
