/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.field;

import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.field.FieldCompareTableColumn.FIELD1_VALUE_COLUMN_NAME;
import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.field.FieldCompareTableColumn.FIELD2_VALUE_COLUMN_NAME;
import static com.tandbergtv.cms.portal.content.client.title.view.compare.table.field.FieldCompareTableColumn.FIELD_NAME_COLUMN_NAME;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIFieldDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareDataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

/**
 * The Data Provider for the Asset Compare Table
 * 
 * @author Vijay Silva
 */
class FieldCompareDataProvider extends
        TitleCompareDataProvider<UIFieldDifference, FieldCompareRecord> implements
        DataProvider<UIFieldDifference, FieldCompareRecord> {

	/* Properties */
	private List<Column<?, FieldCompareRecord>> columns;
	private SortFeature<UIFieldDifference, FieldCompareRecord> sortFeature;

	/**
	 * Constructor
	 * 
	 * @param report The compare report
	 */
	public FieldCompareDataProvider(FieldCompareTable table) {
		super(table);
		initialize();
	}

	/**
	 * @return the sortFeature
	 */
	public SortFeature<UIFieldDifference, FieldCompareRecord> getSortFeature() {
		return sortFeature;
	}

	/*
	 * Override the return type
	 */
	@Override
	protected FieldCompareTable getTable() {
		return (FieldCompareTable) super.getTable();
	}

	// ========================================================================
	// ===================== INITALIZATION
	// ========================================================================

	/*
	 * Build the table columns and sort feature
	 */
	private void initialize() {
		this.columns = new ArrayList<Column<?, FieldCompareRecord>>();
		FieldCompareTableColumn sortColumn = null;
		SortOrder order = SortOrder.ASCENDING;

		/* Build the Asset Type Column */
		String displayName = getTable().getMessages().fieldTableFieldNameColumnName();
		sortColumn = new FieldCompareTableColumn(FIELD_NAME_COLUMN_NAME, displayName);
		this.columns.add(sortColumn);

		/* Build the field1 value column */
		String titleName = getInput().displayName1;
		displayName = getTable().getMessages().fieldTableField1ValueColumnName(titleName);
		this.columns.add(new FieldCompareTableColumn(FIELD1_VALUE_COLUMN_NAME, displayName));

		/* Build the field2 value column */
		titleName = getInput().displayName2;
		displayName = getTable().getMessages().fieldTableField2ValueColumnName(titleName);
		this.columns.add(new FieldCompareTableColumn(FIELD2_VALUE_COLUMN_NAME, displayName));

		/* Build the sort feature */
		sortFeature = new SortFeatureImpl<UIFieldDifference, FieldCompareRecord>(sortColumn, order);
		sortFeature.getSortableColumns().addAll(columns);
	}

	// ========================================================================
	// ===================== DATA PROVIDER METHODS
	// ========================================================================

	/*
	 * Return the built columns
	 */
	@Override
	public List<Column<?, FieldCompareRecord>> getColumns() {
		return this.columns;
	}

	/*
	 * Given the key, get the record. Wraps the key in a new record object
	 */
	@Override
	public void getRecord(UIFieldDifference key, AsyncCallback<FieldCompareRecord> callback) {
		callback.onSuccess(getRecord(key));
	}

	private FieldCompareRecord getRecord(UIFieldDifference key) {
		return new FieldCompareRecord(getInput(), key, getTable().getMessages());
	}

	// ========================================================================
	// ===================== RECORD MANAGEMENT
	// ========================================================================

	/*
	 * Get the records from the cached UI Model
	 */
	@Override
	protected List<FieldCompareRecord> buildRecords() {
		List<FieldCompareRecord> records = new ArrayList<FieldCompareRecord>();
		UIAssetDifference assetDifference = getTable().getAssetDifference();
		for (UIFieldDifference difference : assetDifference.getFieldDifferences()) {
			records.add(getRecord(difference));
		}

		return records;
	}

	@Override
	protected FieldCompareRecordComparator getComparator() {
		return new FieldCompareRecordComparator(getSortColumn(), getSortOrder());
	}
}
