/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.field;

import java.util.List;

import com.tandbergtv.cms.portal.content.client.title.model.compare.UIFieldDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareRecord;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * A Record representing a {@link UIFieldDifference} object.
 * 
 * @author Vijay Silva
 */
class FieldCompareRecord extends TitleCompareRecord<UIFieldDifference> implements Record<UIFieldDifference> 
{
	private final TitleCompareViewMessages messages;

	/**
	 * Constructor
	 */
	public FieldCompareRecord(TitleCompareViewInput input, UIFieldDifference difference,
	        TitleCompareViewMessages messages) {
		super(input, difference);
		this.messages = messages;
	}

	/**
	 * Get the name of the field
	 * 
	 * @return The field xpath / name
	 */
	public String getName() {
		return getKey().getName();
	}

	/**
	 * Get the display name for the field
	 * 
	 * @return The field display name
	 */
	public String getDisplayName() {
		return getKey().getDisplayName();
	}

	/**
	 * Get the fully qualified field name
	 * 
	 * @return The qualified field name
	 */
	public String getQualifiedName() {
		return getKey().getQualifiedName();
	}

	/**
	 * Get the qualified display name for the field
	 * 
	 * @return The qualified display name
	 */
	public String getQualifiedDisplayName() {
		String qualifiedDisplayName = "";
		List<String> names = getKey().getQualifiedDisplayName();
		if (names != null) {
			String separator = messages.qualifiedFieldNameSeparator();
			boolean first = true;
			for (String name : names) {
				if (!first) {
					qualifiedDisplayName += separator;
				} else {
					first = false;
				}

				qualifiedDisplayName += name;
			}
		}

		return qualifiedDisplayName;
	}

	/**
	 * Get the value of the field in asset1
	 * 
	 * @return The value
	 */
	public String getField1Value() {
		return getKey().getField1Value();
	}

	/**
	 * Get the value of the field in asset2
	 * 
	 * @return The value
	 */
	public String getField2Value() {
		return getKey().getField2Value();
	}
}
