/*
 * Created on Apr 26, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.field;

import java.util.Comparator;

import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareRecordComparator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

/**
 * Comparator used for sorting the field compare records
 * 
 * @author Vijay Silva
 */
class FieldCompareRecordComparator extends TitleCompareRecordComparator<FieldCompareRecord>
        implements Comparator<FieldCompareRecord> {

	/**
	 * Constructor
	 */
	public FieldCompareRecordComparator(Column<?, FieldCompareRecord> column, SortOrder sortOrder) {
		super(column, sortOrder);
	}

	@Override
	public int compare(FieldCompareRecord o1, FieldCompareRecord o2) {
		String name = getColumn().getName();
		if (name.equals(FieldCompareTableColumn.FIELD_NAME_COLUMN_NAME)) {
			return compareFieldName(o1, o2);
		} else if (name.equals(FieldCompareTableColumn.FIELD1_VALUE_COLUMN_NAME)) {
			return compareField1Value(o1, o2);
		} else if (name.equals(FieldCompareTableColumn.FIELD2_VALUE_COLUMN_NAME)) {
			return compareField2Value(o1, o2);
		}

		/* Default: the column name is undefined, compare with field display names */
		return compareFieldName(o1, o2);
	}

	/*
	 * Compare the Field display names
	 */
	private int compareFieldName(FieldCompareRecord o1, FieldCompareRecord o2) {
		/* Check if both are null or both are equal */
		return compareValues(o1.getDisplayName(), o2.getDisplayName(), o1, o2);
	}

	/*
	 * Compare the Field1 values
	 */
	private int compareField1Value(FieldCompareRecord o1, FieldCompareRecord o2) {
		return compareValues(o1.getField1Value(), o2.getField1Value(), o1, o2);
	}

	/*
	 * Compare the Field2 values
	 */
	private int compareField2Value(FieldCompareRecord o1, FieldCompareRecord o2) {
		return compareValues(o1.getField2Value(), o2.getField2Value(), o1, o2);
	}

	/*
	 * Compare the fully qualified names of the fields
	 */
	@Override
	protected int keyCompare(FieldCompareRecord o1, FieldCompareRecord o2) {
		/* Compare asset1 IDs */
		return compareValues(o1.getQualifiedName(), o2.getQualifiedName());
	}
}
