/*
 * Created on Apr 26, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.field;

import com.tandbergtv.cms.portal.content.client.title.model.compare.UIAssetDifference;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UIFieldDifference;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareTable;

/**
 * Table for comparison of Assets or Files
 * 
 * @author Vijay Silva
 */
public class FieldCompareTable extends TitleCompareTable<UIFieldDifference, FieldCompareRecord> {

	/* Style Names */
	private static final String STYLE_NAME = "fields";
	private final UIAssetDifference assetDifference;

	/**
	 * Constructor
	 */
	public FieldCompareTable(TitleCompareViewMessages messages, TitleCompareViewInput input,
	        UIAssetDifference difference) {
		super(messages);
		super.setInput(input);
		this.assetDifference = difference;

		addStyleDependentName(STYLE_NAME);
	}

	/**
	 * @return the assetDifference
	 */
	public UIAssetDifference getAssetDifference() {
		return assetDifference;
	}

	@Override
	public void setInput(TitleCompareViewInput input) 
	{
		throw new RuntimeException("Cannot overwrite the FieldCompareTable widget input.");
	}

	/*
	 * Build the data provider
	 */
	@Override
	protected FieldCompareDataProvider buildDataProvider() {
		return new FieldCompareDataProvider(this);
	}
}
