/*
 * Created on Apr 24, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.compare.table.field;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.compare.table.TitleCompareTableColumn;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

/**
 * The Table Column in the Field Compare Table
 * 
 * @author Vijay Silva
 */
class FieldCompareTableColumn extends TitleCompareTableColumn<FieldCompareRecord> implements
        Column<FieldCompareRecord, FieldCompareRecord> {

	/* Column Names */
	static final String FIELD_NAME_COLUMN_NAME = "FieldName";
	static final String FIELD1_VALUE_COLUMN_NAME = "Field1Value";
	static final String FIELD2_VALUE_COLUMN_NAME = "Field2Value";

	/**
	 * Constructor. Do not use this constructor for metadata fields
	 * 
	 * @param name The column name
	 * @param displayName The column display name
	 */
	public FieldCompareTableColumn(String name, String displayName) {
		super(name, displayName);
	}

	/*
	 * Generate a view that contains a label
	 */
	@Override
	protected Widget getWidget(FieldCompareRecord record) {
		LabelWidget label = new LabelWidget();

		/* The Asset Type column */
		if (this.getName().equals(FIELD_NAME_COLUMN_NAME)) {
			label.setText(record.getDisplayName());
			label.setTitle(record.getQualifiedDisplayName());
		}
		/* The File1 ID column */
		else if (this.getName().equals(FIELD1_VALUE_COLUMN_NAME)) {
			label.setText(record.getField1Value());
		}
		/* The File2 ID column */
		else if (this.getName().equals(FIELD2_VALUE_COLUMN_NAME)) {
			label.setText(record.getField2Value());
		}

		return label;
	}
}
