/*
 * Created on Apr 29, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * The title history panel which shows the table of progress items for the title
 * 
 * @author Vijay Silva
 */
abstract class HistoryPanel extends SimpleContainer {

	/* Properties */
	private TitleHistoryTab parent;

	/**
	 * The Progress Item Panel which shows the history table
	 */
	public HistoryPanel(TitleHistoryTab parent) {
		this.parent = parent;
		this.setStylePrimaryName("content-HistoryPanel");

		initialize();
	}

	/**
	 * Get the parent title history tab
	 * 
	 * @return The title history tab
	 */
	protected TitleHistoryTab getTab() {
		return parent;
	}

	/* Initialize the widgets displayed on this panel */
	protected abstract void initialize();

	/**
	 * Update the view
	 */
	public abstract void refresh();
}
