/*
 * Created on Apr 30, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.history;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelView;

/**
 * A Column that appears in the Progress Item / History Table
 * 
 * @author Vijay Silva
 */
abstract class ProgressItemColumn extends ColumnBase<String, ProgressItemRecord> {

	/* Indicates if the view needs to be a label or a hyperlink */
	private List<ProgressItemColumnEventListener> listeners = new ArrayList<ProgressItemColumnEventListener>();
	private String columnWidth;

	/**
	 * Constructor - The column uses a plain label widget for view
	 * 
	 * @param name The column name
	 * @param displayName The column display name
	 */
	public ProgressItemColumn(String name, String displayName) {
		super(name, displayName);
	}

	/**
	 * Add an event listener for the column
	 * 
	 * @param listener
	 */
	public void addEventListener(ProgressItemColumnEventListener listener) {
		if (listener != null)
			listeners.add(listener);
	}

	/**
	 * Remove an event listener for the column
	 * 
	 * @param listener
	 */
	public void removeEventListener(ProgressItemColumnEventListener listener) {
		listeners.remove(listener);
	}

	/**
	 * Get the view for this column
	 */
	public View<String> getView(ProgressItemRecord record) {
		String text = getColumnText(record);

		/* Create the view */
		LabelStringView view = new LabelStringView(text);
		LabelWidget widget = view.getWidget();
		widget.setWordWrap(true);
		widget.addClickHandler(new RecordViewClickListener(view, this, record));

		return view;
	}

	/**
	 * Get the text to display for this column when rendering the record for this column
	 * 
	 * @param record The record
	 */
	protected abstract String getColumnText(ProgressItemRecord record);

	@Override
	public String getColumnWidth() {
		return this.columnWidth;
	}

	/**
	 * Sets the column width
	 * 
	 * @param columnWidth
	 *            The width
	 */
	public void setColumnWidth(String columnWidth) {
		this.columnWidth = columnWidth;
	}

	/*
	 * The View has been clicked
	 */
	private void fireViewClicked(LabelView<?> source, ProgressItemRecord record) {
		for (ProgressItemColumnEventListener listener : listeners) {
			listener.onViewClicked(this, record);
		}
	}

	/* Class that handles clicks for the view displayed by a column for a particular record */
	private class RecordViewClickListener implements ClickHandler {

		/* Properties */
		private LabelView<?> view;
		private ProgressItemRecord record;

		/**
		 * Constructor
		 */
		public RecordViewClickListener(LabelView<?> view, ProgressItemColumn column,
		        ProgressItemRecord record) {
			this.view = view;
			this.record = record;
		}

		/**
		 * Handle the click of the view for a particular column and record
		 */
		public void onClick(ClickEvent event) {
			fireViewClicked(view, record);
		}
	}
}
