/*
 * Created on Apr 28, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.history;

import com.tandbergtv.cms.portal.content.client.title.model.history.UIProgressItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * A Table Record representing a Progress Item
 * 
 * @author Vijay Silva
 */
class ProgressItemRecord implements Record<Long> {

	private UIProgressItem progressItem;

	/**
	 * Constructor
	 */
	public ProgressItemRecord(UIProgressItem progressItem) {
		this.progressItem = progressItem;
	}

	/**
	 * Get the key for this record
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record#getKey()
	 */
	public Long getKey() {
		return (progressItem != null) ? progressItem.getId() : null;
	}

	/**
	 * Get the progress item associated with this record
	 * 
	 * @return The progress item
	 */
	public UIProgressItem getProgressItem() {
		return this.progressItem;
	}
}
