/**
 * File Name	: 	EditImageDialogBox.java
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Created Time	:	Jul 31, 2010 7:20:06 PM
 * Purpose		:	
 * 
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.imageeditor;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyService;
import com.tandbergtv.cms.portal.content.client.rpc.lookupkey.ILookupKeyServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ImageEditorService;
import com.tandbergtv.cms.portal.content.client.title.service.ImageEditorServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.SaveImageRequest;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class EditImageDialogBox extends DialogBox {

	private final ImageEditorServiceAsync imageEditorService = GWT
			.create(ImageEditorService.class);

	private TitleViewMessages messages = GWT.create(TitleViewMessages.class);
	
	private static final String DEFAULT_FILE_EXTENSION = ".jpg";
	private String sourceFileName;
	private String sourceFileExtension = DEFAULT_FILE_EXTENSION;
	private String assetType;
	private String lookupKey;
	
	private ILookupKeyServiceAsync lookupKeyService = GWT.create( ILookupKeyService.class );

	/**
	 * 
	 */
	public EditImageDialogBox() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param autoHide
	 */
	public EditImageDialogBox(boolean autoHide) {
		super(autoHide);
		// TODO Auto-generated constructor stub
	}

	/**
	 * 
	 * @param sourceFileName
	 * @param assetType
	 * @param lookupKey
	 * @param autoHide
	 * @param modal
	 */
	public EditImageDialogBox(String sourceFileName, String assetType,
			String lookupKey, boolean autoHide, boolean modal) {
		super(autoHide, modal);
		this.sourceFileName = sourceFileName;
		if (sourceFileName.lastIndexOf(".") != -1) {
			this.sourceFileExtension = sourceFileName.substring(sourceFileName
					.lastIndexOf("."));
		}
		this.assetType = assetType;
		this.lookupKey = lookupKey;
		init();
	}

	public void init() {
		// Set the dialog box's caption.
		setText(messages.editImageDialogBoxCaption());

		VerticalPanel verticalPanel = new VerticalPanel();
		
		final HTML appletHTML = new HTML();
		String strAppletHTML = getAppletCode();
		appletHTML.setHTML(strAppletHTML);
		
		verticalPanel.add(appletHTML);

		HorizontalPanel horizontalPanel = new HorizontalPanel();
		horizontalPanel.setSpacing(5);
		
		Label label = new Label(messages.saveAsImageLabel());
		horizontalPanel.add(label);
		TextArea saveImageContent = new TextArea();
		saveImageContent.setVisible(false);
		horizontalPanel.add(saveImageContent);
		final TextBox textBoxImageFileName = new TextBox();
		textBoxImageFileName.setText("custom_image1" + sourceFileExtension);
		horizontalPanel.add(textBoxImageFileName);
		Label labelLookupKey = new Label(messages.lookupKeyLabel());
		horizontalPanel.add(labelLookupKey);
		
		final ListBoxWidget<String> lookupKeyListBox = new ListBoxWidget<String>();
		horizontalPanel.add(lookupKeyListBox);
		lookupKeyListBox.addItem(null, null);
		lookupKeyService.getLookupKeysByAssetType(assetType, new NeptuneAsyncCallback<List<UiLookupKey>>(){

			@Override
			public void onNeptuneFailure(Throwable caught) {
                // nothing to be done, the listbox will be empty
			}

			@Override
			public void onNeptuneSuccess(List<UiLookupKey> result) {
				for ( UiLookupKey key : result ) {
					lookupKeyListBox.addItem(key.getName(), key.getName());
				}	
				lookupKeyListBox.setSelectedItem(lookupKey);
			}
			
		});
		
		Button ok = new Button(messages.okButtonText());
		ok.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		ok.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				final String fileName = textBoxImageFileName.getText();
				
		        if (fileName != null && !"".equals(fileName)) {
		            if (fileName.lastIndexOf(".") > -1) {
		                String inputFileExtension = fileName.substring(fileName.lastIndexOf("."));
		                String validFileExtension = getValidFileExtension();
		                if (!inputFileExtension.equals(validFileExtension)) {
		                    Window.alert("The file extension must be the same as the source file extension: " + validFileExtension);
		                    return;
		                }
		            }
		            
		        }

				
				String imageDataBase64 = getImageDataBase64(fileName);
				if (imageDataBase64 != null && !"".equals(imageDataBase64)) {
    				String lookupKey = lookupKeyListBox.getSelectedItem();
  				
    				if (saveImageRequest != null) {
    					saveImageRequest.setImageFileName(fileName);
    					saveImageRequest.setImageDataBase64(imageDataBase64);
    					saveImageRequest.setLookupKey(lookupKey);
    					
    					imageEditorService.saveImage(saveImageRequest,
    							new AsyncCallback<Void>() {
    
    								@Override
    								public void onFailure(Throwable caught) {
    									Window.alert("Failed to save image : saveImage RPC Failure : "
    													+ caught.getMessage()
    													+ "\n Please try again.");
    								}
    
    								@Override
    								public void onSuccess(Void result) {    
    									EditImageDialogBox.this.hide();
    									Window.Location.reload();
    								}
    
    							});
    				}
				}
				// End if (saveImageRequest != null) 
				
			}
		});
		horizontalPanel.add(ok);

		Button cancel = new Button(messages.cancelButtonText());
		cancel.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				EditImageDialogBox.this.hide();
			}
		});
		horizontalPanel.add(cancel);

		verticalPanel.add(horizontalPanel);

		// DialogBox is a SimplePanel, so you have to set its widget property to
		// whatever you want its contents to be.
		setWidget(verticalPanel);
		
	}
	
	private String getValidFileExtension() {
	    String fileExtension = sourceFileExtension;
        // If the user have opened an image through the imaging component 
        // the file extension may have changed. 
        String imagingComponentFileName = getImagingComponentFileName();
        if (imagingComponentFileName != null && !"".equals(imagingComponentFileName)) {
            fileExtension = imagingComponentFileName.substring(imagingComponentFileName.lastIndexOf("."));
        }
        
        return fileExtension;
	}

	public static native String getAppletCode() /*-{
		var NetImager;
		NetImager = new $wnd.netimager("NetImager");
		NetImager.width = 800;
		NetImager.height = 600;

		return NetImager.getAppletCode();
	}-*/;

	public static native String getImagingComponentFileName() /*-{
       var netImagerFileName;
       if ($doc.NetImager) {
           netImagerFileName = $doc.NetImager.getFileName();
       }
       return netImagerFileName;
   }-*/;

	public static native String getImageDataBase64(String fileName) /*-{
		var savedImageData;
		try {
    		if ($doc.NetImager) {
    			$doc.NetImager.setFileName(fileName);
    			savedImageData = $doc.NetImager.GetBase64();
    		}
    	} catch (exc) {
    	    alert('Failed to edit the image. Please make sure that you have not changed the file extension.');
    	}

		return savedImageData;
	}-*/;

	private SaveImageRequest saveImageRequest;

	
	/**
	 * @return the saveImageRequest
	 */
	public SaveImageRequest getSaveImageRequest() {
		return saveImageRequest;
	}

	/**
	 * @param saveImageRequest the saveImageRequest to set
	 */
	public void setSaveImageRequest(SaveImageRequest saveImageRequest) {
		this.saveImageRequest = saveImageRequest;
	}
	
}
