/**
 * File Name	: 	PreviewImageDialogBox.java
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Created Time	:	Jul 31, 2010 7:21:06 PM
 * Purpose		:	
 * 
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.imageeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class PreviewImageDialogBox extends DialogBox {

	private TitleViewMessages messages = GWT.create(TitleViewMessages.class);
	
	/**
	 * 
	 */
	public PreviewImageDialogBox() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param autoHide
	 */
	public PreviewImageDialogBox(boolean autoHide) {
		super(autoHide);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param autoHide
	 * @param modal
	 */
	public PreviewImageDialogBox(boolean autoHide, boolean modal) {
		super(autoHide, modal);
		init();
	}
	
	public void init() {
		// Set the dialog box's caption.
		setText(messages.previewImageDialogBoxCaption());

		VerticalPanel verticalPanel = new VerticalPanel();
		verticalPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		
		final HTML appletHTML = new HTML();
		String strAppletHTML = getAppletCode();
		appletHTML.setHTML(strAppletHTML);
		
		verticalPanel.add(appletHTML);

		Button ok = new Button(messages.okButtonText());
		ok.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		ok.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				PreviewImageDialogBox.this.hide();
			}
		});
		verticalPanel.add(ok);

		// DialogBox is a SimplePanel, so you have to set its widget property to
		// whatever you want its contents to be.
		setWidget(verticalPanel);
		
	}

	public static native String getAppletCode() /*-{
		var NetImager;
		NetImager = new $wnd.netimager("NetImager");
		NetImager.width = 800;
		NetImager.height = 600;

		return NetImager.getAppletCode();
	}-*/;

}
