/**
 * File Name	:	KeyframesLogicalClipPanel.java
 * Created		: 	Aug 16, 2010 6:55:02 PM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UITimeField;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.videoplayer.Validator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class KeyframesLogicalClipPanel extends KeyframesPanelBase {

	private LogicalClipPanel logicalClipPanel;
	private PopupPanel contextMenu;
    ErrorPanel errorMessagePanel;

	/**
	 * 
	 */
	public KeyframesLogicalClipPanel() {
		super();
	}

	public void initWidgets() 
	{
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName("KeyframesLogicalClipPanel");
		mainContainer.setSpacing(10);
				
		logicalClipPanel = new LogicalClipPanel();
		mainContainer.add(logicalClipPanel);
		
		errorMessagePanel = new ErrorPanel();
		errorMessagePanel.setVisible(false);
		mainContainer.add(errorMessagePanel);
		
		Button okButton = new Button("Done");
		okButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		
		okButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				// If Mark-In Mark-out times are selected, set logical clip metadata.
				UIAsset logicalClipUIAsset = assetInfo.getAsset();
				UIComplexField rootField = logicalClipUIAsset.getRootField();
				UIComplexField markField = (UIComplexField) rootField.getChildren().getField("Mark");
				UITimeField markInField = (UITimeField) markField.getChildren().getField("In");
				UITimeField markOutField = (UITimeField) markField.getChildren().getField("Out");
				
				String markInFrameTime = logicalClipPanel.clipStartTime.getText();
				String markOutFrameTime = logicalClipPanel.clipEndTime.getText();
				Validator util = new Validator();
				if (util.validateMarkInMarkOut(FRAME_TIME_SEC_FORMAT, markInFrameTime, markOutFrameTime) == false) {
					handleValidationError(util.getMessage());
					return;
				}
				
				markInField.setValue(markInFrameTime);
				markOutField.setValue(markOutFrameTime);
				
				KeyframesLogicalClipPanel.this.assetPanel.redraw(assetInfo);
			}
			
		});

		HorizontalPanel buttonsPanel = new HorizontalPanel();
		buttonsPanel.addStyleName("ButtonsPanel");

		buttonsPanel.add(okButton);

		Button cancelButton = new Button("Cancel");
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);		
		cancelButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				KeyframesLogicalClipPanel.this.assetPanel.redraw();
			}
		});

		buttonsPanel.add(cancelButton);
		
		mainContainer.add(buttonsPanel);
		
		imagesTable = new FlexTable();
		mainContainer.add(imagesTable);
		
		this.setWidget(mainContainer);
		
	}

	void handleValidationError(String errMsg) {
		errorMessagePanel.setWidth("99%");
		errorMessagePanel.showErrorMessage(errMsg);
		errorMessagePanel.setVisible(true);		
	}
	
	
	/**
	 * @param assetInfo the assetInfo to set
	 */
	public void setAssetInfo(AssetInfo assetInfo) {
		this.assetInfo = assetInfo;
		
		// If this logical clip already has mark-in mark-out times,
		// set the logical clip panel's fields accordingly.
		logicalClipPanel.reset();
		errorMessagePanel.setVisible(false);
		
		try
		{
			UIAsset logicalClipUIAsset = assetInfo.getAsset();
			UIComplexField rootField = logicalClipUIAsset.getRootField();
			UIComplexField markField = (UIComplexField) rootField.getChildren().getField("Mark");
			UITimeField markInField = (UITimeField) markField.getChildren().getField("In");
			UITimeField markOutField = (UITimeField) markField.getChildren().getField("Out");
			
			String markInTime = markInField.getDisplayValue();
			String markOutTime = markOutField.getDisplayValue();
			
			if ((markInTime != null) && (!markInTime.isEmpty()) && (markOutTime != null) && (!markOutTime.isEmpty())) {
				logicalClipPanel.clipStartTime.setText(markInTime);
				logicalClipPanel.clipEndTime.setText(markOutTime);
			}
			
			// This should be the movie asset.
			UIAsset uiMovieAsset = assetInfo.getAsset().getParentAsset();
			Long uiMovieAssetId = uiMovieAsset.getId();
			
			Long titleId = assetInfo.getInput().getTitleId();
			refreshImagesTable(uiMovieAssetId, titleId);
		}
		catch(Exception ex)
		{
			
		}
	}
	
	public void showContextMenu(final MouseUpEvent event, final Image image) {

		createContextMenu(image);

		NativeEvent nativeEvent = event.getNativeEvent();
		
		int x = nativeEvent.getClientX() + Window.getScrollLeft();
		int y = nativeEvent.getClientY() + Window.getScrollTop();
		
		contextMenu.setPopupPosition(x, y);
		contextMenu.show();
	}

	public void createContextMenu(final Image image) {
		final String imageUrl = image.getUrl();
		String milliSecTimeString = getFrameTimeString(imageUrl);
		int index = milliSecTimeString.lastIndexOf(".");
		String secTimeString=milliSecTimeString;
		if (index > 0)
			secTimeString = milliSecTimeString.substring(0,index);
		//final String frameTimeString = getFrameTimeString(imageUrl);
		final String frameTimeString = secTimeString;
		
		MenuBar menuBar = new MenuBar(true);
		menuBar.addStyleName("context-menu-bar");
		
		Command setMarkInFrameCommand = new Command() {
			@Override
			public void execute() {
				logicalClipPanel.clipStartTime.setText(frameTimeString);
				contextMenu.hide();
			}
		};

		Command setMarkOutFrameCommand = new Command() {
			@Override
			public void execute() {
				logicalClipPanel.clipEndTime.setText(frameTimeString);
				contextMenu.hide();
			}
		};
		
		menuBar.addItem("Set Mark-in frame", setMarkInFrameCommand);
		menuBar.addItem("Set Mark-out frame", setMarkOutFrameCommand);

		contextMenu = new PopupPanel(true);
		contextMenu.add(menuBar);
	}

	public void validateMarkInMarkOut() {
		
	}
}
