/**
 * File Name	:	KeyframesPanel.java
 * Created		: 	Aug 11, 2010 11:34:45 AM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:	
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.title.model.UIKeyFrames;
import com.tandbergtv.cms.portal.content.client.title.service.KeyframesService;
import com.tandbergtv.cms.portal.content.client.title.service.KeyframesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageResizeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.PageFeatureWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class KeyframesPanelBase extends SimpleContainer {

	protected VerticalContainer mainContainer;

	protected AssetPanel assetPanel;
	protected AssetInfo input;
	protected AssetInfo assetInfo;
	
	protected FlexTable imagesTable;
	protected PageFeature pageFeature=null;
	protected PageFeatureWidget featureWidget=null;
	
	protected List<Image> keyframeImagesList = new ArrayList<Image>();

	protected final KeyframesServiceAsync keyframesService = GWT.create(KeyframesService.class);
	
	private static final String STYLE_KEYFRAMES_TIME_LABEL = "content-keyframe-time-label";
	private static final String STYLE_KEYFRAMES_IMAGE_PANEL = "content-keyframe-image-panel";
	
	protected static final String GET_IMAGE_JSP_PATH = "/portal/cms_contentmgmt_ui/jsps/get_image.jsp?fileURI=";

	private static final int NUM_IMAGES_IN_A_ROW = 5;
	private static final int DEFAULT_SECONDS_BETWEEN_FRAMES = 5;
	public static final DateTimeFormat FRAME_TIME_SEC_FORMAT = DateTimeFormat.getFormat("HH:mm:ss");
	public static final DateTimeFormat FRAME_TIME_MILLISEC_FORMAT = DateTimeFormat.getFormat("HH:mm:ss.SSS");
	private int milliSecondsBetweenFrames = DEFAULT_SECONDS_BETWEEN_FRAMES * 1000;

	/**
	 * 
	 */
	public KeyframesPanelBase() {
		initWidgets();
	}
	
	public void initWidgets() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(10);
				
		Button okButton = new Button("Done");
		okButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() 
		{
			@Override
			public void onClick(ClickEvent event) {
				KeyframesPanelBase.this.assetPanel.redraw(assetInfo);
			}
			
		});

		mainContainer.add(okButton);
		
		imagesTable = new FlexTable();
								
		mainContainer.add(imagesTable);
		this.setWidget(mainContainer);
		
	}

	/**
	 * @return the assetPanel
	 */
	public AssetPanel getAssetPanel() {
		return assetPanel;
	}

	/**
	 * @param assetPanel the assetPanel to set
	 */
	public void setAssetPanel(AssetPanel assetPanel) {
		this.assetPanel = assetPanel;
		
		refreshImagesTable();
	}

	protected void refreshImagesTable() {

		Long assetId = null;
		Long titleId = null;

		refreshImagesTable(assetId, titleId);
	}
	
	public void refreshImagesTable(Long assetId, Long titleId) {
		if (assetId == null) {
			return;
		}
	
		//create new PageFeatureWidget
		if (featureWidget != null)
			mainContainer.remove(featureWidget);
		pageFeature = new PageFeatureImpl();
		int pageNum = 1;
		int pageSize = 10;
		pageFeature.setPageNumber(pageNum);
		pageFeature.setPageSize(pageSize);
		featureWidget = new PageFeatureWidget();
		ImageFramesPageNavigationHandler navHandler = new ImageFramesPageNavigationHandler(assetId, titleId);
		featureWidget.setInput(pageFeature);
		featureWidget.addPageNavigationHandler(navHandler);
		ImageFramesPageResizeHandler pgHandler = new ImageFramesPageResizeHandler(assetId, titleId);
		featureWidget.addPageResizeHandler(pgHandler);
		mainContainer.add(featureWidget);

		refreshImagesTableForCurrentPage(assetId, titleId, NUM_IMAGES_IN_A_ROW, pageNum, pageSize);
	}

	public void refreshImagesTableForCurrentPage(Long assetId, Long titleId, int numCols, final int pageNum, final int pageSize) {
		if (assetId == null) {
			return;
		}
	
		final BusyIndicator busyIndictor = new BusyIndicator();
		busyIndictor.center();
		keyframesService.getPagedKeyframesImageURIs(assetId, titleId, numCols, pageNum, pageSize, new AsyncCallback<UIKeyFrames>() {
			
			@Override
			public void onFailure(Throwable caught) {
				busyIndictor.hide();
				Window.alert("getKeyFramesImages RPC Failure : " + caught);
			}

			@Override
			public void onSuccess(UIKeyFrames result) {
				busyIndictor.hide();
				keyframeImagesList.clear();
				
				String frameRateStr = result.getFramesPerSecond();
				if (frameRateStr != null && !frameRateStr.isEmpty() ){
					float framesPerSecond = Float.parseFloat(frameRateStr);
					milliSecondsBetweenFrames = (int)(1000/framesPerSecond); 
				}
				List<String> keyFrameImageURIs = result.getKeyframesImageURIs();
				
				for (String imageFileUri : keyFrameImageURIs) {
					String encodedImageFileUri = URL.encodeQueryString(imageFileUri);
					final String imageUrl = Window.Location.getProtocol() + "//" + Window.Location.getHost()
							+ GET_IMAGE_JSP_PATH
							+ encodedImageFileUri;

					Image image = new Image(imageUrl);
					image.setWidth("200px");
					image.setHeight("150px");
					keyframeImagesList.add(image);
				}
				
				if (keyFrameImageURIs.size() > 0 ) {
					//refresh page feature widget
					int totalNumber = result.getTotalNumberKeyFrames();
					int recCount  = totalNumber / NUM_IMAGES_IN_A_ROW;
					int rem = totalNumber % NUM_IMAGES_IN_A_ROW;
					if (rem > 0)
						recCount  += 1;
					pageFeature.setPageNumber(pageNum);
					pageFeature.setPageSize(pageSize);
					pageFeature.setRecordCount(recCount);
					featureWidget.setVisible(true);
					featureWidget.refresh();
				}
				else
					featureWidget.setVisible(false);
				displayImages();
			}
		});
	}
	

	/**
	 * 
	 * @params
	 * @return
	 */
	public int getFrameNumber(String s) {
		String strFrameNumber = s.substring(s.lastIndexOf("-") + 1, s.lastIndexOf("."));
		int frameNumber = -1;
		
		try {
			frameNumber = Integer.parseInt(strFrameNumber);
		} catch (NumberFormatException e) {
		}

		return frameNumber;
	}
	
	public String getFrameTimeString(String imageUrl) {
		String frameTimeString = "";
		
		String strFrameNumber = imageUrl.substring(imageUrl.lastIndexOf("-") + 1, imageUrl.lastIndexOf("."));
		int frameNumber = Integer.parseInt(strFrameNumber);
		long frameTimeInMilliseconds = (frameNumber-1)* milliSecondsBetweenFrames;
				
		Date frameDate = DateTimeFormat.getFormat("HH:mm:ss").parse("00:00:00");
		frameDate.setTime(frameDate.getTime() + frameTimeInMilliseconds);
		
		//frameTimeString = FRAME_TIME_SEC_FORMAT.format(frameDate);
		frameTimeString = FRAME_TIME_MILLISEC_FORMAT.format(frameDate);
		
		return frameTimeString;
	}

	public void displayImages() {
		int row = 0;
		int column = 0;
		imagesTable.clear();
		for (final Image image : keyframeImagesList) {
			PushButton pushButton = new PushButton(image);
			final String imageUrl = image.getUrl();

			pushButton.addMouseUpHandler(new MouseUpHandler() {

				@Override
				public void onMouseUp(MouseUpEvent event) {
					showContextMenu(event, image);
				}
				
			});
			
			pushButton.addClickHandler(new ClickHandler(){

				@Override
				public void onClick(ClickEvent event) {
					onKeyframeImageClicked(event, imageUrl);
				}
				
			});

			final String frameTimeString = getFrameTimeString(imageUrl);			
			Label frameTimeLabel = new Label(frameTimeString);
			frameTimeLabel.addStyleName(STYLE_KEYFRAMES_TIME_LABEL);
			VerticalPanel keyFrameImagePanel = new VerticalPanel();
			keyFrameImagePanel.add(pushButton);
			keyFrameImagePanel.add(frameTimeLabel);
			keyFrameImagePanel.addStyleName(STYLE_KEYFRAMES_IMAGE_PANEL);
			
			imagesTable.setWidget(row, column, keyFrameImagePanel);

			column++;
			if (column >= NUM_IMAGES_IN_A_ROW) {
				column = 0;
				row++;
			}
		}
	}
	
	protected void showContextMenu(final MouseUpEvent event, final Image image) {
	}

	protected void onKeyframeImageClicked(ClickEvent event, String imageUrl) {
		
	}
	
	/**
	 * @return the input
	 */
	public AssetInfo getInput() {
		return input;
	}

	/**
	 * @param input the input to set
	 */
	public void setInput(AssetInfo input) {
		this.input = input;
	}

	/**
	 * @return the assetInfo
	 */
	public AssetInfo getAssetInfo() {
		return assetInfo;
	}

	/**
	 * @param assetInfo the assetInfo to set
	 */
	public void setAssetInfo(AssetInfo assetInfo) {
		this.assetInfo = assetInfo;
	}

	class ImageFramesPageNavigationHandler implements PageNavigationHandler {
		Long assetId; 
		Long titleId;
		ImageFramesPageNavigationHandler(Long assetId, Long titleId) {
			this.assetId=assetId; 
			this.titleId=titleId;			
		}
		
		@Override
		public void onPageNavigation(PageNavigationEvent event) {
			int pageNum = event.getNewPageNumber();
			int pageSize = event.getPageFeature().getPageSize();			
			int numCols = NUM_IMAGES_IN_A_ROW;
				
			refreshImagesTableForCurrentPage(assetId, titleId, numCols, pageNum, pageSize);
		}	
	}
	
	class ImageFramesPageResizeHandler implements PageResizeHandler {
		Long assetId; 
		Long titleId;
		ImageFramesPageResizeHandler(Long assetId, Long titleId) {
			this.assetId=assetId; 
			this.titleId=titleId;			
		}

		@Override
		public void onPageResize(PageResizeEvent event) {
			int pageNum = 1 ; // ignore event.getPageFeature().getPageNumber();
			int pageSize = event.getNewPageSize();			
			int numCols = NUM_IMAGES_IN_A_ROW;
				
			refreshImagesTableForCurrentPage(assetId, titleId, numCols, pageNum, pageSize);			
		}
	}	
}
