/**
 * File Name	:	KeyframesPanel.java
 * Created		: 	Aug 11, 2010 11:34:45 AM
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Purpose		:
 *
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.IUIAssetMap;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFile;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFileField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.service.asset.IUIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class KeyframesSetImagePanel extends KeyframesPanelBase {

	private IUIAssetFactory assetFactory = new UIAssetFactory();

	private TitleImageWidget titleImageWidget;
	private ListBox moviesDropDown;

	//private static final String GROUP_ASSET_TYPE_MOVIE = "MOVIE";

	private static final String FILE_URI_XPATH = "/Fields/Locator/Uri";
	private static final String FILE_TYPE_XPATH = "/Fields/Locator/Description/Text";
	private static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
	private static final String FILE_TYPE_ORIGINAL = "ORIGINAL";
	private static final String FILE_TYPE_HISTORICAL = "HISTORICAL";

	/**
	 *
	 */
	public KeyframesSetImagePanel() {
		initWidgets();
	}

	public void initWidgets() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(10);

		titleImageWidget = new TitleImageWidget();
		mainContainer.add(titleImageWidget);

		HorizontalPanel movieAssetSelectionPanel = new HorizontalPanel();
		movieAssetSelectionPanel.setSpacing(10);
		Label movieAssetSelectionLabel = new Label("Movie Asset Id : ");
		movieAssetSelectionPanel.add(movieAssetSelectionLabel);
		moviesDropDown = new ListBox();
		moviesDropDown.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				refreshImagesTable();
			}

		});
		movieAssetSelectionPanel.add(moviesDropDown);

		Button okButton = new Button("Done");
		okButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		okButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				String imageUrl = titleImageWidget.getImageUrl();
				// If imageUrl is other than the default no_image.jpg, update asset info
				boolean hasUserPickedNonDefaultImage = !imageUrl
						.contains(TitleImageWidget.getDefaultImageUrl());

				if (hasUserPickedNonDefaultImage) {
					updateAssetInfoImageUrl(imageUrl);
					assetPanel.redraw(assetInfo);
				} else {
					assetPanel.redraw();
				}
			}

		});
		movieAssetSelectionPanel.add(okButton);

		mainContainer.add(movieAssetSelectionPanel);

		imagesTable = new FlexTable();
		mainContainer.add(imagesTable);

		this.setWidget(mainContainer);

	}

	/**
	 * @param assetPanel the assetPanel to set
	 */
	public void setAssetPanel(AssetPanel assetPanel) {
		this.assetPanel = assetPanel;
		AssetInfo input = assetPanel.getInput();
		UIAsset rootAsset = input.getAsset();
		if (rootAsset instanceof UIGroupAsset) {
			UIGroupAsset rootGrpAsset = (UIGroupAsset) rootAsset;
			IUIAssetMap uiAssetmap = rootGrpAsset.getChildren();
			NeptuneApplication application = NeptuneApplication.getApplication();
			ContentComponent component = application.getComponent(ContentComponent.class);
			List<String> videoAssetTypes = component.getVideoAssetTypes();
			List<UIGroupAsset> allVideoAssets = new ArrayList<UIGroupAsset>();
			for (String videoAssetType: videoAssetTypes) {
				List<UIGroupAsset> videoAssets = uiAssetmap.getGroups(videoAssetType);
				if (videoAssets != null && !videoAssets.isEmpty())
					allVideoAssets.addAll(videoAssets);
			}
			//List<UIGroupAsset> movieAssets = uiAssetmap.getGroups(GROUP_ASSET_TYPE_MOVIE);
			moviesDropDown.clear();
			for (UIGroupAsset videoAsset : allVideoAssets) {
				Long videoAssetId = videoAsset.getId();

				moviesDropDown.addItem(String.valueOf(videoAssetId), String.valueOf(videoAssetId));
			}
		}

		refreshImagesTable();
	}

	public void refreshImagesTable() {

		if (moviesDropDown.getItemCount() > 0) {
			int movieSelectedIndex = moviesDropDown.getSelectedIndex();
			if (movieSelectedIndex < 0) {
				movieSelectedIndex = 0;
			}
			String strMovieId = moviesDropDown.getItemText(movieSelectedIndex);
			Long assetId = null;

			try {
				assetId = Long.valueOf(strMovieId);
			} catch (NumberFormatException e) {
			}

			Long titleId = assetInfo.getInput().getTitleId();
			refreshImagesTable(assetId, titleId);

		}

	}

	private void updateAssetInfoImageUrl(String imageUrl) {

		UIAsset asset = assetInfo.getAsset();
		List<UIAssetFile> assetFiles =  asset.getFiles();
		UIAssetFileDefinition fileDefinition = assetInfo.getDefinition().getFileDefinition();

		// Change the file type of current "Original" file to "Historical".
		// If a previous file with new file lookup key DEFAULT_LOOKUP_KEY_ORIGINAL_FILE already exists,
		//	change that file's lookup key to blank.
		String newFileLookupkey = FILE_TYPE_ORIGINAL;

		for (UIAssetFile assetFile : assetFiles) {
			UIAssetFileField fileTypeAssetFileField = assetFile.getFields().get(FILE_TYPE_XPATH);
			UIStringField stringField = (UIStringField) fileTypeAssetFileField.getField();
			String stringFieldValue = stringField.getDisplayValue();
			if (FILE_TYPE_ORIGINAL.equals(stringFieldValue)) {
				stringField.setValue(FILE_TYPE_HISTORICAL);
			}

			UIAssetFileField filelookupKeyAssetFileField = assetFile.getFields().get(FILE_LOOKUP_KEY_XPATH);
			stringField = (UIStringField) filelookupKeyAssetFileField.getField();
			stringFieldValue = stringField.getDisplayValue();
			if (newFileLookupkey.equals(stringFieldValue)) {
				stringField.setValue("");
			}
		}

		// Add new file with file type "Original", lookup key "Original",
		//	and File URI the file URI portion of "imageUrl".

		UIAssetFile newAssetFile = assetFactory.createAssetFile(fileDefinition);
		newAssetFile.setParentAsset(asset);

		/* File Metadata */
		for (UIAssetFileFieldDefinition fieldDefinition : fileDefinition.getFieldDefinitions()) {
			if (fieldDefinition.getName()
							.equals(FILE_TYPE_XPATH)) {
				UIAssetFileField value = assetFactory.createAssetFileField(fieldDefinition);
				UIStringField stringField = new UIStringField();
				stringField.setName(FILE_TYPE_XPATH);
				stringField.setValue(FILE_TYPE_ORIGINAL);
				value.setField(stringField);
				newAssetFile.addField(value);
			}
			if (fieldDefinition.getName()
							.equals(FILE_URI_XPATH)) {
				UIAssetFileField value = assetFactory.createAssetFileField(fieldDefinition);
				UIStringField stringField = new UIStringField();
				stringField.setName(FILE_URI_XPATH);
				String encodedFileURI = imageUrl.substring(imageUrl.indexOf("fileURI=") + "fileURI=".length());
				String fileURI = URL.decodeQueryString(encodedFileURI);
				stringField.setValue(fileURI);
				value.setField(stringField);
				newAssetFile.addField(value);
			}
			if (fieldDefinition.getName()
							.equals(FILE_LOOKUP_KEY_XPATH)) {
				UIAssetFileField value = assetFactory.createAssetFileField(fieldDefinition);
				UIStringField stringField = new UIStringField();
				stringField.setName(FILE_LOOKUP_KEY_XPATH);
				stringField.setValue(FILE_TYPE_ORIGINAL);
				value.setField(stringField);
				newAssetFile.addField(value);
			}
		}

		assetFiles.add(newAssetFile);

	}

	protected void onKeyframeImageClicked(ClickEvent event, String imageUrl) {
		titleImageWidget.setImageUrl(imageUrl);
	}

}
