/**
 * File Name	: 	LogicalClipPanel.java
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Created Time	:	Jul 12, 2010 6:20:35 PM
 * Purpose		:	
 * 
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;


/**
 * @author esakhat
 */
public class LogicalClipPanel extends Composite 
{
	private static final String DEAFULT_MARK_IN_TIME = "00:00:00";
	private static final String DEAFULT_MARK_OUT_TIME = "00:05:00";
	
	TextBox clipStartTime;
	TextBox clipEndTime;
	Label clipMsg;
	
	/**
	 * Constructor 
	 */
	public LogicalClipPanel() 
	{
		clipStartTime = new TextBox();
		clipEndTime = new TextBox();
		clipMsg = new Label();
		
		VerticalPanel mainPanel = new VerticalPanel();
		mainPanel.addStyleName("LogicalClipPanel");

		initWidget(mainPanel);
		
		// Hint label
		Label label = new Label("Enter Mark-in/Mark-out times below or click on key frames below to set Mark-in/Mark-out frames.");
		label.addStyleName("Header");
		mainPanel.add(label);

		// Start and end times
		HorizontalPanel hp = new HorizontalPanel();
		hp.add(new HTML("Start Time: &nbsp;"));
		hp.add(clipStartTime);
		hp.add(new HTML("&nbsp; &nbsp; &nbsp; End Time: &nbsp;"));
		hp.add(clipEndTime);
		mainPanel.add(hp);

		// Clip message
		mainPanel.add(clipMsg);
	}
	
	
	public void reset() 
	{
		clipStartTime.setText(DEAFULT_MARK_IN_TIME);
		clipEndTime.setText(DEAFULT_MARK_OUT_TIME);
		clipMsg.setText("");
	}
}
