/**
 * File Name	: 	KeyFrameImageWidget.java
 * Created By	: 	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Created Time	:	Jun 16, 2010 7:13:01 PM
 * Purpose		:	
 * 
 * (c) 2010 Ericsson Television Inc.
 */
package com.tandbergtv.cms.portal.content.client.title.view.keyframes;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat
 *
 */
public class TitleImageWidget extends Composite {
	interface MyUiBinder extends UiBinder<Widget, TitleImageWidget> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
	
	private static final String DEFAULT_IMAGE_URL = "cms_contentmgmt_ui/resources/images/thumbnail_noimage.png";
	
	@UiField Image titleImage;
	@UiField Button resetButton;
	
	public TitleImageWidget() {
		initWidget(uiBinder.createAndBindUi(this));
		titleImage.setWidth("75px");
		titleImage.setHeight("75px");
		reset();
		resetButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
	}
	
	@UiHandler("resetButton") 
	public void onClick(ClickEvent event) {
		reset();
	}
	
	public void reset() {
		setImageUrl(DEFAULT_IMAGE_URL);
//		resetButton.setVisible(false);
	}
	
	public void setImageUrl(String url) {
		titleImage.setUrl(url);
//		if (!DEFAULT_IMAGE_URL.equalsIgnoreCase(url)) {
//			resetButton.setVisible(true);
//		}
	}
	
	public String getImageUrl() {
		return titleImage.getUrl();
	}
	
	public Image getTitleImage() {
		return titleImage;
	}

	/**
	 * @return the defaultImageUrl
	 */
	public static String getDefaultImageUrl() {
		return DEFAULT_IMAGE_URL;
	}
	
}
