/*
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.ericsson.cms.me.client.Permissions;
import com.ericsson.cms.me.client.model.DeconflictMode;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictCallback;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.services.title.RunNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.content.client.title.model.UIMetadataEnhInfo;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAssetFilePath;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIComplexField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIField;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIGroupAsset;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIStringField;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.TitleSavePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.service.ICategoryTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.ICategoryTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleServiceException;
import com.tandbergtv.cms.portal.content.client.title.service.TitleValidationUIException;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessageCache;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeEvent;
import com.tandbergtv.cms.portal.content.client.title.view.ViewChangeHandler;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetPanel;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewWidget;
import com.tandbergtv.cms.portal.content.client.title.view.preview.TitlePreviewWidgetInput;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewMessages;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleListActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.GridContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


/**
 * The title metadata tab
 * 
 * @author Vijay Silva
 */
public class TitleMetadataTab extends TitleViewTab implements IView {
	private static final String TEMPLATE_CANCEL = "TemplateCancel";
	private static final String TEMPLATE_DONT_ENHANCE = "TemplateDontEnhance";
	private static final String TEMPLATE_CONFIRM = "TemplateConfirm";

	private static final String LBL_ASSOCIATE = "Associate";
	private static final String LBL_DISASSOCIATE = "Disassociate";

	private ICategoryTitleServiceAsync categoryTitleService = GWT.create(ICategoryTitleService.class);

	private boolean isLicensedForCategoryManagement = false;
	private boolean hasMetadataEnhancementPermission = false;
	private boolean isCategoryTitleAssociated = false;

	private UITitle currentTitle;

	/* Widgets Properties */
	protected VerticalContainer mainContainer;
	protected GridContainer contentPanel;
	protected AssetPanel assetPanel;
	protected VerticalContainer controlsContainer;
	protected HorizontalContainer enhMetaContainer;
	protected HorizontalContainer buttonContainer;
	protected ButtonClickListener actionButtonHandler;
	protected ButtonWidget selectButton, saveButton, saveAsDraftButton, saveAllButton,
		saveAllAsDraftButton, saveCurrentButton, previewButton, associateButton, goButton;
	protected CheckBoxWidget enhOnSaveCheck=null;
	protected LabelWidget enhOnSaveLabel=null;
	protected ListBoxWidget<String> actionsListBox, parameterListBox, multiSelectParameterListBox;

	/* Input / State */
	private AssetInfo assetInfo = null;
	private UIAssetSpecification currentSpecification = null;
	private List<UIAssetFilePath> filePaths = null;
	private HandlerRegistration windowRegistration = null;

	/** Tab Name */
	public static final String TAB_NAME = "Metadata";

	/* Styles */
	protected static final String STYLE_SCROLL_CONTAINER = "content-TitleMetadataTab-scrollContainer";
	protected static final String STYLE_SCROLL_CONTENTS = "content-TitleMetadataTab-scrollContents";
	protected static final String STYLE_BUTTON_CONTAINER = "content-TitleMetadataTab-buttonContainer";
	protected static final String STYLE_VALIDATION_CELL = "content-TitleMetadataTab-validationCell";
	protected static final String STYLE_ASSETPANEL_CELL = "content-TitleMetadataTab-assetPanelCell";
	protected static final String STYLE_ASSET_PANEL = "content-TitleMetadataTab-assetPanel";
	protected static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";

	protected static final String RULES_VIOLATION = "RULES_VIOLATION";

	// Rules preview
	private RulesPreviewMessages ruleMessages = GWT.create(RulesPreviewMessages.class);
	private IRulesPreviewServiceAsync rulesService = GWT.create(IRulesPreviewService.class);
	private TitleCompareView compareView;
	private TitleSavePreviewRequest lastRequest;
	private RulePreviewRequest lastRulePreviewRequest;
	
	// Cached widget. It is required to handle cancel clicks on preview screen.
	private MetadataDeconflictWidget deconflictWidget;

	boolean useMultiSelectParameters = false;
	
	// map for services
	ServiceMap serviceMap;
	ServiceLoader serviceLoader;

	private ContentConstants contentConstants = (ContentConstants) GWT.create(ContentConstants.class);
	
	/**
	 * @param parent The parent view
	 */
	public TitleMetadataTab(TitleView parent) {
		super(parent);
	}

	/**
	 * Initialize the widgets displayed
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#initialize()
	 */
	@Override
	protected void initialize() 
	{
		this.getContainer().addStyleDependentName("metadata");

		/* Build the 'content' section */
		contentPanel = new GridContainer(1, 1);
		contentPanel.addStyleName(STYLE_SCROLL_CONTENTS);
		contentPanel.setWidget(0, 0, new LabelWidget(""));
		contentPanel.getCellFormatter().addStyleName(0, 0, STYLE_ASSETPANEL_CELL);

		/* Add the 'content' section to a scroll-enabled container which resizes with window */

		
		hasMetadataEnhancementPermission =  ClientAuthorizationManager.isAuthorized(Permissions.ME_ENHANCE);
		NeptuneApplication application = NeptuneApplication.getApplication();
		ContentComponent component = application.getComponent(ContentComponent.class);
		isLicensedForCategoryManagement = component.isLicensedForCategoryManagement();
		
		/*check box for metadata enhancement */
		enhOnSaveCheck = new CheckBoxWidget();
		enhOnSaveCheck.addStyleName("MECheck");
		
		enhOnSaveLabel = new LabelWidget(this.getViewMessages().enhanceOnSaveCheck());
		enhOnSaveLabel.addStyleName("MELabel");
		
		enhMetaContainer = new HorizontalContainer();
		enhMetaContainer.add(enhOnSaveCheck);
		enhMetaContainer.add(enhOnSaveLabel);
		
		enhOnSaveCheck.setVisible(false);
		enhOnSaveCheck.setEnabled(false);
		enhOnSaveLabel.setVisible(false);
		
		/* The buttons: Select */
		String selectText = this.getViewMessages().selectButton();
		selectButton = new ButtonWidget(selectText);
		selectButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		selectButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				mapClickedAction();
			}
		});
		selectButton.setVisible(false);
		selectButton.setEnabled(false);

		/* The buttons: Save */
		String saveAllText = this.getViewMessages().saveAllButton();
		saveAllButton = new ButtonWidget(saveAllText);
		saveAllButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAllButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAllClickedAction();
			}
		});
		saveAllButton.setVisible(false);
		saveAllButton.setEnabled(false);

		/* The buttons: Save Current */
		String saveCurrentText = this.getViewMessages().saveAsCurrentStatusButton();
		saveCurrentButton = new ButtonWidget(saveCurrentText);
		saveCurrentButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveCurrentButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveCurrentClickedAction();
			}
		});
		saveCurrentButton.setVisible(false);
		saveCurrentButton.setEnabled(false);

		/* The buttons: Save as Draft */
		String saveAllAsDraftText = this.getViewMessages().saveAllAsDraftButton();
		saveAllAsDraftButton = new ButtonWidget(saveAllAsDraftText);
		saveAllAsDraftButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAllAsDraftButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAllAsDraftClickedAction();
			}
		});
		saveAllAsDraftButton.setVisible(false);
		saveAllAsDraftButton.setEnabled(false);

		/* The buttons: Save */
		String saveText = this.getViewMessages().saveButton();
		saveButton = new ButtonWidget(saveText);
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveClickedAction();
			}
		});
		saveButton.setVisible(false);
		saveButton.setEnabled(false);

		/* The buttons: Save as Draft */
		String saveAsDraftText = this.getViewMessages().saveAsDraftButton();
		saveAsDraftButton = new ButtonWidget(saveAsDraftText);
		saveAsDraftButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAsDraftButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAsDraftClickedAction();
			}
		});
		saveAsDraftButton.setVisible(false);
		saveAsDraftButton.setEnabled(false);

		/* The buttons: Cancel */
		String cancelText = this.getViewMessages().cancelButton();
		ButtonWidget cancelButton = new ButtonWidget(cancelText);
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				cancelClickedAction();
			}
		});

		if (isLicensedForCategoryManagement) {
			// Associate button. Is displayed for Category title only.
			associateButton = new ButtonWidget("Associate");
			associateButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
			associateButton.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					associateClickedAction();
				}
			});
		}

		/* The buttons: Preview */
		String previewText = this.getViewMessages().previewButton();
		previewButton = new ButtonWidget(previewText);
		previewButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		previewButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				previewClickedAction();
			}
		});

		// actionlist box
		actionsListBox = new ListBoxWidget<String>(false);

		// listbox for additional params used by the service
		parameterListBox = new ListBoxWidget<String>(false);
		parameterListBox.setVisible(false);
		multiSelectParameterListBox = new ListBoxWidget<String>(true);
		multiSelectParameterListBox.setVisible(false);
			
		// go button
		goButton = new ButtonWidget("Go");
		actionButtonHandler = new ButtonClickListener(actionsListBox, parameterListBox, this, getServiceMap());
		goButton.addClickHandler(actionButtonHandler);
		goButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		
		/* The Button Panel */
		controlsContainer = new VerticalContainer();
		controlsContainer.addStyleName(STYLE_BUTTON_CONTAINER);
		
		buttonContainer = new HorizontalContainer();
		buttonContainer.add(selectButton);
		buttonContainer.add(saveAllButton);
		buttonContainer.add(saveAllAsDraftButton);
		buttonContainer.add(saveCurrentButton);
		buttonContainer.add(saveButton);
		buttonContainer.add(saveAsDraftButton);

		if (isLicensedForCategoryManagement) {
			buttonContainer.add(associateButton);
		}

		buttonContainer.add(previewButton);
		
		if(hasMetadataEnhancementPermission) 
		{ 
			controlsContainer.add(enhMetaContainer);
		}
		
		buttonContainer.add(actionsListBox);
		buttonContainer.add(parameterListBox);
		buttonContainer.add(multiSelectParameterListBox);
		buttonContainer.add(goButton);

		buttonContainer.add(cancelButton);

		controlsContainer.add(buttonContainer);

		/* Build the main container */
		mainContainer = new VerticalContainer();
		mainContainer.add(contentPanel);
		mainContainer.add(controlsContainer);
		mainContainer.setCellHorizontalAlignment(controlsContainer, VerticalPanel.ALIGN_LEFT);
		mainContainer.setCellVerticalAlignment(controlsContainer, VerticalPanel.ALIGN_BOTTOM);


		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget();
		this.getContainer().setWidget(blankLabel);
	}
	
	
	public void buildActionsListWidgets(boolean isSiteTitle, boolean isSeriesTitle) {
		//add action items to actions listbox
		ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(
			ITitleService.class, getServiceLoader(), isSeriesTitle, false, isSiteTitle);

		for (UiServiceItem item : listItemProvider.getItems(getServiceMap())) {
			actionsListBox.addItem(item.getName(), item.getClassName());
		}

		actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(getServiceMap(), new ViewInput()));

		String displayName = actionsListBox.getItemText(actionsListBox.getSelectedIndex());
		if(displayName.trim().isEmpty()) {
			setWidgetsForNoAction();
		}

		// show parameter list corresponding to the selected service
		actionsListBox.addChangeHandler(new ActionChangeHandler(actionButtonHandler) {
			public void onChange(ChangeEvent event) {
				// Don't show the parameter list box and go button until the
				// parameters have
				// been retrieved.
				parameterListBox.setVisible(false);
				multiSelectParameterListBox.setVisible(false);
				goButton.setEnabled(false);

				int selectedIndex = actionsListBox.getSelectedIndex();
				String displayName = actionsListBox.getItemText(selectedIndex);
				// if no action is selected, clear out the state
				if (displayName.trim().isEmpty()) {
					setWidgetsForNoAction();

					return;
				}

				ITitleActionService selectedAction = getServiceMap().getService(displayName);

				if (selectedAction.getName().equals(contentConstants.runTargetSitesServiceName()) == true) {
					useMultiSelectParameters = true;
					actionButtonHandler.setParameterList(multiSelectParameterListBox);
				} else {
					useMultiSelectParameters = false;
					actionButtonHandler.setParameterList(parameterListBox);
				}

				selectedAction.getServiceParameters(new NeptuneAsyncCallback<List<String>>() {
					public void onNeptuneFailure(Throwable caught) {
						// In case of an exception at the very least
						// show the Go button for any
						// other operation.
						parameterListBox.setVisible(false);
						multiSelectParameterListBox.setVisible(false);
						String error = caught.getLocalizedMessage();
						String message = getViewMessages().activityFetchFailure(error);

						/* Show the error panel */
						showErrorPanel(message);
					}

					public void onNeptuneSuccess(List<String> result) {
						// Only if there are any parameters for this
						// service, show them and
						// also enable the GO button
						if (result != null) {
							if (useMultiSelectParameters == false) {
								setParameterList(parameterListBox, result);
								parameterListBox.setVisible(true);
								multiSelectParameterListBox.setVisible(false);
							} else {
								setParameterList(multiSelectParameterListBox, result);
								parameterListBox.setVisible(false);
								multiSelectParameterListBox.setVisible(true);
							}
						}
						goButton.setEnabled(true);

					}
				});
			}

			// TODO List<String> parameters can be changed to List<Object>
			// parameters
			private void setParameterList(ListBoxWidget<String> listBox,
					List<String> parameters) {
				listBox.clear();
				for (String p : parameters) {
					String name = p;
					String value = p;
					if ((p != null)
							&& (p.contains(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR))) {
						String[] pArray = p
								.split(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR);
						if (pArray.length > 0) {
							name = pArray[0];
						}
						if (pArray.length > 1) {
							value = pArray[1];
						}
					}
					listBox.addItem(name, value);
					
				}
			}
		});

	}
	
	public void setWidgetsVisibility(boolean visible) {
		actionsListBox.setVisible(visible);
		goButton.setVisible(visible);
		multiSelectParameterListBox.setVisible(false);
		parameterListBox.clear();
		parameterListBox.setVisible(false);
	}

	private void setWidgetsForNoAction() {
		actionsListBox.setSelectedItem("");
		parameterListBox.clear();
		parameterListBox.setVisible(false);
		goButton.setEnabled(false);
	}

	/*
	 * Update the size of the asset container widget
	 */
	private void updateScrollContainerSize() 
	{
		updateAssetPanelHeight();
	}


	/*
	 * Show the loading message
	 */
	private void showLoadingMessage() {
		/* Show a loading message as the main widget */
		String message = this.getViewMessages().metadataLoading();
		LabelWidget label = new LabelWidget(message);
		label.addStyleName(STYLE_LOADING_LABEL);
		getContainer().setWidget(label);
	}

	/**
	 * Refresh the state of this tab
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#refresh()
	 */
	
	public void refreshTab() {
		/* Show the busy indicator */
		showBusyIndicator();

		/* Show the loading message */
		this.showLoadingMessage();

		/* Get the metadata from the input */
		refreshTitleMetadata();
	}

	/*
	 * Update the scroll container size on tab selection
	 */
	@Override
	protected void onTabSelected() 
	{
		super.onTabSelected();
		
		titleView.showMessage(null);
		
		/* Ensure that the metadata tab is shown if not stale */
		if(!this.isStale()) 
		{
			this.getContainer().setWidget(mainContainer);
		}

		/* Update the scroll container size */
		updateScrollContainerSize();
	}

	// ==============================================================
	// ===================== WIDGET OVERRIDES
	// ==============================================================

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateScrollContainerSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		super.onUnload();
	}

	// ==============================================================
	// ===================== BUTTON ACTIONS
	// ==============================================================

	/*
	 * The save button is clicked, save the title metadata
	 */
	protected void saveAllClickedAction() {
		performSaveAction(false, false);
	}

	/*
	 * The save button is clicked, save the title metadata
	 */
	protected void saveAllAsDraftClickedAction() {
		performSaveAction(true, false);
	}

	/*
	 * The save button is clicked, save the title metadata
	 */
	protected void saveCurrentClickedAction() {
		performSaveAction(false, true);
	}

	/*
	 * The save button is clicked, save the title metadata
	 */
	protected void saveClickedAction() {
		performSaveAction(false, false);
	}

	/*
	 * The save button is clicked, save the title metadata
	 */
	protected void saveAsDraftClickedAction() {
		performSaveAction(true, false);
	}

	private void performSaveAction(final boolean draft, final boolean currentState) {
		/* Show busy indicator right away */
		showBusyIndicator();
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {
			@Override
			public void execute() {
				performSaveActionInternally(draft, currentState);
			}
		});
	}

	private void performSaveActionInternally(boolean draft, boolean currentState) 
	{
		TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
		validationViewInput.setMetadataTab(this);
		
		/* Always clear the existing messages on save */
		titleView.showMessage(null);
		updateAssetPanelHeight();
		
		if (assetInfo == null || assetInfo.getAsset() == null) 
		{
			hideBusyIndicator();
			return;
		}

		/* check if the metadata is valid */
		List<AssetValidationMessage> messages = validationViewInput.getAssetValidationMessages();
		if (assetPanel != null)
			messages.addAll(assetPanel.validate(draft));

		if (messages.size() > 0) {
			boolean isBulkEdit = getViewInput().isBulkEdit();
			String feedbackMessage = (isBulkEdit) ? getViewMessages().titleBulkEditFailureMessage()
					: getViewMessages().titleSaveValidationFailureMessage();
			
			validationViewInput.setErrorHeader(feedbackMessage);

			String errorMessage = (!isBulkEdit) ? getViewMessages().titleValidationFailureHeading()
					: getViewMessages().titleValidationBulkFailureHeading();
			validationViewInput.setErrorHeader(errorMessage);
			titleView.showMessage(validationViewInput);
			updateAssetPanelHeight();
			
			/* Set view to top of page */
			hideBusyIndicator();
			return;
		}

		/* Save the title */
		UITitle title = new UITitle();
		title.setContentClassId(currentTitle.getContentClassId());
		title.setPartnerId(currentTitle.getPartnerId());
		title.setOverview(currentTitle.getOverview());
		title.setMetadata(new UITitleMetadata());
		title.setId(this.getViewInput().getTitleId());
		title.getMetadata().setRootAsset(assetInfo.getAsset());
		
		boolean enhMetadata = false;
		if (enhOnSaveCheck != null)		
			enhMetadata = enhOnSaveCheck.getValue();
		
		
		if (title.getId() == null) {
			if (titleView.getInput().isBulkEdit()) {
				List<Long> titleIds = titleView.getInput().getOrderedBulkEditTitleIds();
				batchUpdateTitleMetadata(title, titleIds, draft, currentState);
			} else {
				if (draft)
					createTitleAsDraft(title);
				else {
					if (enhMetadata)
						searchForMetadataEnhancement(title, true, null, null,null);
					else	
						createTitle(title, null);
				}
			}
		} else {
			if (draft)
				updateTitleMetadataAsDraft(title);
			else {
				if (enhMetadata)
					searchForMetadataEnhancement(title, false, this.getTitleView().getInput().getRequestKey(), this
							.getTitleView().getInput().getAction(), this.getTitleView().getInput()
							.getListOfAssetIds());
				else
					updateTitleMetadata(title, this.getTitleView().getInput().getRequestKey(), this
						.getTitleView().getInput().getAction(), this.getTitleView().getInput()
						.getListOfAssetIds(), null);
			}
		}
	}

	/*
	 * Fire the cancel action on the title view
	 */
	protected void cancelClickedAction() {
		this.onCancelled();
	}

	/*
	 * Handle the preview action
	 */
	protected void previewClickedAction() {
		/* No asset ready for preview */
		if (assetInfo == null || assetInfo.getAsset() == null)
			return;

		/* Build the input */
		UIActionTitle title = new UIActionTitle();
		title.setMetadata(new UITitleMetadata());
		title.setTitleId(this.getViewInput().getTitleId());
		title.getMetadata().setRootAsset(assetInfo.getAsset());
		TitlePreviewWidgetInput input = new TitlePreviewWidgetInput(title);
		input.setSelectedSpecification(getViewInput().getSpecificationName());
		input.setRestrictedHeight(getUsedHeight());
		input.setRestrictedWidth(getUsedWidth());

		/* Build view and show */
		TitlePreviewWidget previewWidget = new TitlePreviewWidget(getViewMessages());
		previewWidget.addViewCancelHandler(new ViewCancelHandler() {
			@Override
			public void onCancel(ViewCancelEvent event) {
				handleViewCancelled();
			}
		});
		previewWidget.setInput(input);
		previewWidget.refresh();
		getContainer().setWidget(previewWidget);
	}

	private String getCategory(UIAsset titleAsset) {
		if (titleAsset == null)
			return null;
		UIComplexField fields = titleAsset.getRootField();
		if (fields == null)
			return null;

		UIField categories = fields.getChildren().getField("Categories");
		if (categories == null || !(categories instanceof UIComplexField))
			return null;

		UIField category = ((UIComplexField) categories).getChildren().getField("Category");
		if (category == null || !(category instanceof UIComplexField))
			return null;

		UIField text = ((UIComplexField) category).getChildren().getField("Text");
		if (text == null || !(text instanceof UIStringField))
			return null;

		return ((UIStringField) text).getValue();
	}

	private UIAsset getTitleAsset() {
		if (currentTitle == null)
			return null;
		if (currentTitle.getMetadata() == null)
			return null;
		UIAsset root = currentTitle.getMetadata().getRootAsset();
		if (root == null || !(root instanceof UIGroupAsset))
			return null;

		List<UIAsset> assets = ((UIGroupAsset) root).getChildren().getAll();
		if (assets == null || assets.isEmpty())
			return null;

		for (UIAsset asset : assets) {
			if ("TITLE".equalsIgnoreCase(asset.getAssetType()))
				return asset;
		}

		return null;
	}

	private void associateClickedAction() {
		if (isCategoryTitleAssociated) {
			doDisassociate();
		} else {
			doAssociate();
		}
	}

	// Handle associate action
	private void doAssociate() 
	{
		// Clear feedback and error messages
		titleView.showMessage(null);
		updateAssetPanelHeight();
		
		if (currentTitle == null)
			return;

		if (currentTitle.getId() == null) 
		{
			TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
			validationViewInput.setErrorHeader("Failed to associate title with category. You have to save title first.");
			titleView.showMessage(validationViewInput);
			updateAssetPanelHeight();
			return;
		}

		// Get title id
		long titleId = currentTitle.getId();

		// Get category path
		UIAsset titleAsset = getTitleAsset();
		final String category = getCategory(titleAsset);

		if (category == null || category.trim().length() < 1) 
		{
			TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
			validationViewInput.setErrorHeader("Failed to associate title with category " 
					+ category + ". Category name could not be blank");
			titleView.showMessage(validationViewInput);
			updateAssetPanelHeight();
			
			return;
		}

		NeptuneAsyncCallback<Void> callback = new NeptuneAsyncCallback<Void>() 
		{
			public void onNeptuneSuccess(Void result) {
				associateButton.setText(LBL_DISASSOCIATE);
				isCategoryTitleAssociated = true;

				TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
				validationViewInput.setInfoHeader("Title has been associated with category " + category);
				titleView.showMessage(validationViewInput);
				updateAssetPanelHeight();
				
				hideBusyIndicator();
			}

			public void onNeptuneFailure(Throwable caught) 
			{
				TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
				validationViewInput.setErrorHeader("Failed to associate title with category " 
						+ category + ". " + caught.getLocalizedMessage());
				titleView.showMessage(validationViewInput);
				updateAssetPanelHeight();
				
				hideBusyIndicator();
			}
		};

		showBusyIndicator();
		categoryTitleService.associateTitleAndCategory(titleId, category, callback);
	}

	// Handle associate action
	private void doDisassociate() 
	{
		// Clear feedback and error messages
		titleView.showMessage(null);
		updateAssetPanelHeight();
		
		if(currentTitle == null)
		{
			return;
		}

		if(currentTitle.getId() == null) 
		{
			TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
			validationViewInput.setErrorHeader("Failed to disassociate title. You have to save title first.");
			titleView.showMessage(validationViewInput);
			updateAssetPanelHeight();
		}

		// Get title id
		long titleId = currentTitle.getId();

		NeptuneAsyncCallback<Void> callback = new NeptuneAsyncCallback<Void>() 
		{
			public void onNeptuneSuccess(Void result) 
			{
				associateButton.setText(LBL_ASSOCIATE);
				isCategoryTitleAssociated = false;

				TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
				validationViewInput.setInfoHeader("Title has been disassociated");
				titleView.showMessage(validationViewInput);
				updateAssetPanelHeight();
				
				hideBusyIndicator();
			}

			public void onNeptuneFailure(Throwable caught) 
			{
				TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
				validationViewInput.setErrorHeader("Failed to disassociate title." + caught.getLocalizedMessage());
				titleView.showMessage(validationViewInput);
				updateAssetPanelHeight();
				hideBusyIndicator();
			}
		};

		showBusyIndicator();
		categoryTitleService.disassociateTitle(titleId, callback);
	}

	/*
	 * Show the main container
	 */
	private void handleViewCancelled() {
		getContainer().setWidget(mainContainer);
		updateScrollContainerSize();
	}

	private void notifyWorkflowIfNecessary() {
		Long requestKey = this.getTitleView().getInput().getRequestKey();
		if (requestKey != null) {
			String action = this.getTitleView().getInput().getAction();
			if (TitleViewInput.ACTION_CORRECT.equals(action))
				sendValidationSuccessConfirmationToWorkflow(requestKey);
		}
	}

	private void sendValidationSuccessConfirmationToWorkflow(long requestKey) {
		this.getViewService().sendValidationSuccessConfirmation(requestKey,
				new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneSuccess(Void result) {
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						Window.alert(caught.getLocalizedMessage());
					}
				});
	}

	private void resolveConflictFromWorkflowIfNecessary() {
		Long requestKey = this.getTitleView().getInput().getRequestKey();
		if (requestKey != null) {
			String action = this.getTitleView().getInput().getAction();
			if (TitleViewInput.ACTION_DECONFLICT.equals(action)) {
				if (!hasMetadataEnhancementPermission) {
					showErrorPanel(this.getViewMessages().enhanceNotAuthorized());					
					return;
				}
				resolveConflictForTemplate(requestKey);
			}
		}
	}
	
	private void sendMEDeconflictSuccessConfirmationToWorkflow(long requestKey) {
  	  	showBusyIndicator();
		this.getViewService().sendMEDeconflictSuccessConfirmation(requestKey,
				new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneSuccess(Void result) {
				  	  	hideBusyIndicator();
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
				  	  	hideBusyIndicator();
						Window.alert(caught.getLocalizedMessage());
					}
				});
	}
	
	protected void mapClickedAction() {
		long titleId = this.getTitleView().getInput().getTitleId();
		long assetId = assetPanel.getSelectedAssetInfo().getAsset().getId();
		long requestKey = this.getViewInput().getRequestKey();
		sendSelectAssetNotificationToWorkflow(titleId, assetId, requestKey);
	}

	private void sendSelectAssetNotificationToWorkflow(long titleId, long assetId, long requestKey) {
		this.getViewService().sendSelectAssetNotification(titleId, assetId, requestKey,
				new NeptuneAsyncCallback<Void>() {

					@Override
					public void onNeptuneSuccess(Void result) {
						Window.alert("Title successfully selected.");
						// TODO it's not really onCancel action but behaves similarly
						onCancelled();
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						Window.alert(caught.getLocalizedMessage());
					}
				});

	}

	/*
	 * Search for metadata enhancement from 3rd party data sources  
	 */
 	private void searchForMetadataEnhancement(final UITitle title, final boolean isNewTitle, final Long woRequestKey, final String action
			                 ,final String listOfAssetIds) {
		this.getViewService().searchMetadataEnhancement(title, new NeptuneAsyncCallback<UIMetadataEnhInfo>() {
			public void onNeptuneSuccess(UIMetadataEnhInfo result) {
				String meRequestKey = result.getRequestKey();
				Collection<Long> profileIds = result.getSubProfileIds();
				if (profileIds==null || profileIds.isEmpty()) {
					//proceed to save without enhancement
					if (isNewTitle)
						createTitle(title,null);
					else
			        	updateTitleMetadata(title, woRequestKey, action, listOfAssetIds,null);
					return;
				}
				else if (result.getIsMultipleMatches() == false) {
					if (isNewTitle)
						createTitle(title,meRequestKey);
					else
			        	updateTitleMetadata(title, woRequestKey, action, listOfAssetIds,meRequestKey);
					return;
				}
				resolveConflictBeforeSave(result, title, isNewTitle,  woRequestKey, action,listOfAssetIds);
			}

			public void onNeptuneFailure(Throwable caught) {
				handleSaveTitleFailure(caught, false, true);
			}
		});
	}	
	
	private void resolveConflictBeforeSave(final UIMetadataEnhInfo result, final UITitle title, final boolean isNewTitle, final Long requestKey,
			final String action, final String listOfAssetIds) {
		
		hideBusyIndicator();
		final String meRequestKey = result.getRequestKey();

		final NeptuneAsyncCallback<Void> cancelCallback = new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneSuccess(Void result) {
				 hideBusyIndicator();
			}

			@Override
			public void onNeptuneFailure(Throwable caught) {
			 	hideBusyIndicator();
				Window.alert(caught.getLocalizedMessage());
			}
		};
		
		final NeptuneAsyncCallback<Void> saveWithNoEnhancmentCallback = new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneSuccess(Void result) {
				  //proceed with save without enhancement
	        	  if (isNewTitle)
					  createTitle(title, null);
	        	  else
	        		  updateTitleMetadata(title, requestKey, action, listOfAssetIds, null);
			}

			@Override
			public void onNeptuneFailure(Throwable caught) {
			 	hideBusyIndicator();
				Window.alert(caught.getLocalizedMessage());
			}
		};
		
		MetadataDeconflictCallback meCallback = new MetadataDeconflictCallback() {  
	          @Override    
	          public void saveWithEnhancement() {
				  handleViewCancelled();
	        	  showBusyIndicator();
	        	  if (isNewTitle)
					  createTitle(title, meRequestKey);
	        	  else
	        		  updateTitleMetadata(title, requestKey, action, listOfAssetIds, meRequestKey);
	          }

	          @Override    
	          public void saveWithoutEnhancement() {     
				  handleViewCancelled();
	        	  showBusyIndicator();
				  getViewService().cleanUpMetadataEnhancementRequest(meRequestKey,saveWithNoEnhancmentCallback);
	          }
	          
	          @Override                                        
	          public void normalizeAndPreviewTitle() 
	          {
	        	  previewAllActiveRules(title, meRequestKey);
	          }
	          
	          @Override    
	          public void cancelSave() {     
					handleViewCancelled();
			  	  	showBusyIndicator();
					getViewService().cleanUpMetadataEnhancementRequest(meRequestKey,cancelCallback);
	          }

	          @Override    
	          public int getFrameRestrictedWidth() {  
	        	    return (getUsedWidth());
	          }
	          
	          @Override    
	          public int getFrameRestrictedHeight() {  
	        	    return (getUsedHeight());
	          }

	          @Override
	          public void showMessage(String msg, boolean isError) {
	  				TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
	  				if (isError)
	  					validationViewInput.setErrorHeader(msg);
	  				else
	  					validationViewInput.setInfoHeader(msg);
	  				titleView.showMessage(validationViewInput);
	  				updateAssetPanelHeight();	        	  
	          }
	          
	          @Override
	          public void clearMessage() {
	        	  	getTitleView().showMessage(null);
	        	  	updateAssetPanelHeight();
	          }
	          
		};		

		deconflictWidget = new MetadataDeconflictWidget(meRequestKey, meCallback, DeconflictMode.SAVE); 	
		getContainer().setWidget(deconflictWidget);
	}
	
	
	private void goToMetadataTabFromTemplate(String cmd)
	{
		History.newItem("Content.Search.Id=" + getViewInput().getTitleId() + "&Tab=Metadata&From=" + cmd);		
	}
	
	private void resolveConflictForTemplate(final Long requestKey) 
	{
		final String meRequestKey = requestKey.toString();

		MetadataDeconflictCallback meCallback = new MetadataDeconflictCallback() 
		{
			@Override
			public void saveWithEnhancement() 
			{
				sendMEDeconflictSuccessConfirmationToWorkflow(requestKey);
				goToMetadataTabFromTemplate(TEMPLATE_CONFIRM);
			}

			@Override    
			public void saveWithoutEnhancement() 
			{
				sendMEDeconflictSuccessConfirmationToWorkflow(requestKey);
				goToMetadataTabFromTemplate(TEMPLATE_DONT_ENHANCE);
			}
  
			@Override                                        
			public void normalizeAndPreviewTitle() 
			{
				previewAllActiveRules(getViewInput().getTitleId(), meRequestKey);
			}
  
			@Override    
			public void cancelSave() 
			{
				goToMetadataTabFromTemplate(TEMPLATE_CANCEL);
			}

			@Override    
			public int getFrameRestrictedWidth() {  
				return (getUsedWidth());
			}
  
			@Override    
			public int getFrameRestrictedHeight() {  
				return (getUsedHeight());
			}
			
	        @Override
	        public void showMessage(String msg, boolean isError) {
	  			TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
				if (isError)
					validationViewInput.setErrorHeader(msg);
  				else
  					validationViewInput.setInfoHeader(msg);
				titleView.showMessage(validationViewInput);
				updateAssetPanelHeight();	        	  
	        }
			
	        @Override
	        public void clearMessage() {
	        	getTitleView().showMessage(null);
	        	updateAssetPanelHeight();
	        }
		};		

		deconflictWidget = new MetadataDeconflictWidget(meRequestKey, meCallback, DeconflictMode.TEMPLATE);
		getContainer().setWidget(deconflictWidget);
	}
	
	// ==============================================================
	// ===================== TITLE CREATE
	// ==============================================================

	/*
	 * Create a new title
	 */
	private void createTitle(UITitle title, String meRequestKey) {
		this.getViewService().createTitle(title, meRequestKey, new NeptuneAsyncCallback<UITitle>() {
			public void onNeptuneSuccess(UITitle result) {
				handleSaveTitleSuccess(result, false, true);
				if (enhOnSaveCheck != null)
					enhOnSaveCheck.setValue(false);
			}

			public void onNeptuneFailure(Throwable caught) {
				handleSaveTitleFailure(caught, false, true);
			}
		});
	}

	/*
	 * Create a new title in draft status
	 */
	private void createTitleAsDraft(UITitle title) {
		this.getViewService().createTitleAsDraft(title, new NeptuneAsyncCallback<UITitle>() {
			public void onNeptuneSuccess(UITitle result) {
				handleSaveTitleSuccess(result, true, true);
			}

			public void onNeptuneFailure(Throwable caught) {
				handleSaveTitleFailure(caught, true, true);
			}
		});
	}

	// ==============================================================
	// ===================== TITLE UPDATE
	// ==============================================================

	/*
	 * Update the metadata for an existing title
	 */
	private void updateTitleMetadata(UITitle title, Long requestKey, String action,
			String listOfAssetIds, String meRequestKey) {
		this.getViewService().updateTitleMetadata(title, requestKey, action, listOfAssetIds, meRequestKey,
				new NeptuneAsyncCallback<UITitle>() {
					@Override
					public void onNeptuneSuccess(UITitle result) {
						handleSaveTitleSuccess(result, false, false);
						if (enhOnSaveCheck != null)
							enhOnSaveCheck.setValue(false);
						notifyWorkflowIfNecessary();
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						handleSaveTitleFailure(caught, false, false);
					}
				});
	}

	/*
	 * Update the metadata for an existing title as draft
	 */
	private void updateTitleMetadataAsDraft(UITitle title) {
		this.getViewService().updateTitleMetadataAsDraft(title, 
				new NeptuneAsyncCallback<UITitle>() {
					@Override
					public void onNeptuneSuccess(UITitle result) {
						handleSaveTitleSuccess(result, true, false);
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						handleSaveTitleFailure(caught, true, false);
					}
				});
	}

	// ==============================================================
	// ===================== TITLE SAVE
	// ==============================================================

	/*
	 * The title was saved successfully
	 */
	private void handleSaveTitleSuccess(UITitle result, boolean draft, boolean create) 
	{
		this.clearDirty();

		// Copy content class metadata from current title
		// result.setContentClassMetadata(currentTitle.getContentClassMetadata());
		/* Notify all tabs that the title state has changed */
		if(create) 
		{
			this.onTitleCreated(result);
		} 
		else 
		{
			this.onTitleUpdated(result);
		}

		// Update the asset content view
		// TODO: Refactor
		UITitleInfo info = new UITitleInfo();
		info.setTitle(result);
		info.setSpecification(currentSpecification);
		info.setFilePaths(filePaths);
		handleGetTitleMetadataSuccess(info);

		// Update the validation messages
		String feedbackMessage = getViewMessages().titleSaveSuccessMessage();
		TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
		
		List<UITitleValidationMessage> messages = result.getMetadata().getValidationMessages();
		validationViewInput.setInfoHeader(feedbackMessage);
		if(!messages.isEmpty())
		{
			validationViewInput.getTitleValidationMessages().addAll(messages);
		}

		titleView.showMessage(validationViewInput);
		updateAssetPanelHeight();
		
		// Build and Show ActionsListWidgets after create
		if (create) {
			buildActionsListWidgets(result.getOverview().isSiteTitle(), titleView.getInput().isSeriesTitle());
			setWidgetsVisibility(true);
		}
	}

	/*
	 * Handle failure when saving the title(s)
	 */
	private void handleSaveTitleFailure(Throwable caught, boolean draft, boolean create) 
	{
		TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
		validationViewInput.setMetadataTab(this);
		
		boolean isSevere = false;
		String feedbackMessage = getViewMessages().titleSaveFailureMessage();
		String errorMessage = null;

		/* Handle the read deleted title error */
		if (caught instanceof ReadDeletedTitleException) 
		{
			isSevere = true;
			feedbackMessage = caught.getLocalizedMessage();
			errorMessage = "";
		}
		/* Handle validation error */
		else if (caught instanceof TitleValidationUIException) 
		{
			TitleValidationUIException validationError = (TitleValidationUIException) caught;
			addValidationMessages(validationError, validationViewInput);

			if (validationError.isFatal()) 
			{
				errorMessage = validationError.getLocalizedMessage();
			} 
			else if (draft || !canSaveAsDraft(validationError)) 
			{
				errorMessage = getViewMessages().titleValidationFailureHeading();
			} 
			else 
			{
				feedbackMessage = getViewMessages().titleSaveValidationFailureMessage();
				errorMessage = getViewMessages().titleValidationFailureHeadingWithRecovery();
			}
		}
		/* Handle any other type of error */
		else 
		{
			errorMessage = caught.getLocalizedMessage();
		}

		validationViewInput.setErrorHeader(errorMessage);
		titleView.showMessage(validationViewInput);
		updateAssetPanelHeight();

		/* Hide the busy indicator */
		hideBusyIndicator();
	}

	/*
	 * Show the validation messages
	 */
	private void addValidationMessages(TitleValidationUIException error, TitleValidationViewInput validationViewInput)
	{
		List<UITitleValidationMessage> messages = error.getValidationMessages();
		if (messages == null)
			return;

		/* In the case of bulk edit, only show the error messages */
		boolean isBulkEdit = getViewInput().isBulkEdit();
		for (UITitleValidationMessage message : messages) 
		{
			if (!isBulkEdit || message.getMessageType().equals(UITitleValidationMessageType.Error)) 
			{
				validationViewInput.getTitleValidationMessages().add(message);
			}
		}
	}

	/*
	 * If there are any non-rules engine validation errors, the title cannot be saved as draft.
	 */
	private boolean canSaveAsDraft(TitleValidationUIException error) 
	{
		for (UITitleValidationMessage message : error.getValidationMessages()) 
		{
			if (!RULES_VIOLATION.equals(message.getErrorCode())) {
				return false;
			}
		}

		return true;
	}

	/*
	 * Determine if the localized message in the throwable can be used as part of the view feedback
	 * message to indicate failure.
	 */
	private boolean canShowErrorMessage(Throwable error) {
		boolean localized = false;
		if (error instanceof TitleServiceException) {
			TitleServiceException exception = (TitleServiceException) error;
			localized = exception.isLocalizedMessage();
		}
		return localized;
	}

	// ==============================================================
	// ===================== BATCH UPDATE
	// ==============================================================

	/*
	 * Batch update the metadata for an existing title
	 */
	private void batchUpdateTitleMetadata(UITitle updates, List<Long> titleIds,
			final boolean draft, final boolean currentState) {
		this.getViewService().batchUpdateTitleMetadata(updates, titleIds, draft, currentState,
				new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneSuccess(Void result) {
						handleBatchUpdateTitleMetadataSuccess();
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						handleBatchUpdateTitleMetadataFailure(caught, draft, currentState);
					}
				});
	}

	/*
	 * The titles were batch updated successfully
	 */
	private void handleBatchUpdateTitleMetadataSuccess() 
	{
		hideBusyIndicator();

		/* Notify all tabs that the title state has changed */
		this.onBatchTitleUpdated();

		/* Update the validation messages */
		titleView.showMessage(null);
		updateAssetPanelHeight();
	}

	/*
	 * The titles failed to batch update
	 */
	private void handleBatchUpdateTitleMetadataFailure(Throwable caught, boolean draft, boolean currentState) 
	{
		TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
		validationViewInput.setMetadataTab(this);
		
		boolean isSevere = false;
		String feedbackMessage = getViewMessages().titleBulkEditFailureMessage();
		String errorMessage = null;

		/* Handle the read deleted title error */
		if (caught instanceof ReadDeletedTitleException) 
		{
			isSevere = true;
			feedbackMessage = getViewMessages().bulkEditDeletedTitleFailureMessage();
			errorMessage = "";
		}
		/* Handle validation error */
		else if (caught instanceof TitleValidationUIException) 
		{
			TitleValidationUIException validationError = (TitleValidationUIException) caught;
			addValidationMessages(validationError, validationViewInput);

			if (validationError.isFatal()) 
			{
				errorMessage = validationError.getLocalizedMessage();
			} 
			else if (draft || !canSaveAsDraft(validationError)) 
			{
				errorMessage = getViewMessages().titleValidationBulkFailureHeading();
			} 
			else 
			{
				errorMessage = (currentState) ? getViewMessages()
						.titleValidationBulkFailureHeadingWithDraftStatus() : getViewMessages()
						.titleValidationBulkFailureHeadingWithCurrentStatus();
			}
		}
		/* Handle any other type of error */
		else 
		{
			errorMessage = caught.getLocalizedMessage();
		}
		
		validationViewInput.setErrorHeader(errorMessage);
		titleView.showMessage(validationViewInput);
		updateAssetPanelHeight();

		/* Hide the busy indicator */
		hideBusyIndicator();
	}

	// ==============================================================
	// ===================== REFRESH
	// ==============================================================

	public void updateAssetPanelHeight()
	{
		if(assetPanel != null)
		{
			assetPanel.updateSize();
		}
	}
	
	/* Fetch the specification and title metadata from the input and render the title */
	private void refreshTitleMetadata() {
		/* Clear the specification and file paths used to render view, and get from input */
		this.currentSpecification = null;
		this.filePaths = null;

		/* Hide all the buttons */
		this.disableTabButtons();

		/* Clear the validation messages and update the buttons */
		if(TEMPLATE_CANCEL.equalsIgnoreCase(titleView.getInput().getFrom()))
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setInfoHeader(TitleViewMessageCache.getMessages().meTemplateCancel());
			getTitleView().showMessage(input);
		}
		else if(TEMPLATE_DONT_ENHANCE.equalsIgnoreCase(titleView.getInput().getFrom()))
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setInfoHeader(TitleViewMessageCache.getMessages().meTemplateDontEnhance());
			getTitleView().showMessage(input);
		}
		else if(TEMPLATE_CONFIRM.equalsIgnoreCase(titleView.getInput().getFrom()))
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setInfoHeader(TitleViewMessageCache.getMessages().meTemplateConfirm());
			getTitleView().showMessage(input);
		}
		else
		{
			getTitleView().showMessage(null);
		}
		
		updateAssetPanelHeight();

		// Get the data
		this.getViewInput().getMetadata(new NeptuneAsyncCallback<UITitleInfo>() {
			@Override
			public void onNeptuneSuccess(UITitleInfo result) {
				handleGetTitleMetadataSuccess(result);
			}

			@Override
			public void onNeptuneFailure(Throwable caught) {
				handleGetTitleMetadataFailure(caught);
			}
		});

	}

	/*
	 * Disable / hide all the buttons for the tab
	 */
	protected void disableTabButtons() {
		/* Try and display select button */
		selectButton.setVisible(false);
		selectButton.setEnabled(false);

		/* Try and display save button */
		saveButton.setVisible(false);
		saveButton.setEnabled(false);

		/* Try and display save as draft button */
		saveAsDraftButton.setVisible(false);
		saveAsDraftButton.setEnabled(false);

		/* Try and display save button */
		saveAllButton.setVisible(false);
		saveAllButton.setEnabled(false);

		/* Try and display save as draft button */
		saveAllAsDraftButton.setVisible(false);
		saveAllAsDraftButton.setEnabled(false);

		/* Try and display save as draft button */
		saveCurrentButton.setVisible(false);
		saveCurrentButton.setEnabled(false);

		/* Try and display save button */
		previewButton.setVisible(false);
		previewButton.setEnabled(false);

		if (isLicensedForCategoryManagement) {
			// Associate button
			associateButton.setVisible(false);
			associateButton.setEnabled(false);
		}
	}

	/*
	 * Update the visibility of the buttons based on permissions and functionality
	 */
	protected void updateTabButtons(UITitleMetadata metadata) {
		boolean readOnly = isReadOnly(metadata);
		boolean selectMode = this.getViewInput().isSelectButtonVisible();

		/* Try and display select button */
		selectButton.setVisible(selectMode && !readOnly);
		selectButton.setEnabled(selectMode && !readOnly);

		if (titleView.getInput().isBulkEdit()) {

			/* Try and display save button */
			saveAllButton.setVisible(!selectMode && !readOnly);
			saveAllButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveAllAsDraftButton.setVisible(!selectMode && !readOnly);
			saveAllAsDraftButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveCurrentButton.setVisible(!selectMode && !readOnly);
			saveCurrentButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save button */
			previewButton.setVisible(false);
			previewButton.setEnabled(false);
			
			/*Disable widgets for metadata enhancement*/
			enhOnSaveCheck.setVisible(false);
			enhOnSaveCheck.setEnabled(false);
			enhOnSaveLabel.setVisible(false);
		} 
		else 
		{
			/* Try and display save button */
			saveButton.setVisible(!selectMode && !readOnly);
			saveButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveAsDraftButton.setVisible(!selectMode && !readOnly);
			saveAsDraftButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save button */
			previewButton.setVisible(true);
			previewButton.setEnabled(true);

			if(titleView.getInput().isCategoryTitle() && isLicensedForCategoryManagement)
			{
				if(currentTitle.getOverview() != null && currentTitle.getOverview().isSiteTitle())
				{
					associateButton.setVisible(false);
					associateButton.setEnabled(false);
				}
				else
				{
					associateButton.setVisible(true);
					associateButton.setEnabled(currentTitle.getId() != null && currentTitle.getId() > 0);
				}
			}
		
			boolean deConflictFromWF = false;
			Long requestKey = this.getTitleView().getInput().getRequestKey();
			if (requestKey != null) {
				String action = this.getTitleView().getInput().getAction();
				if (TitleViewInput.ACTION_DECONFLICT.equals(action))
					deConflictFromWF = true;
			}
			
			
			if(!titleView.getInput().isSeriesTitle() && hasMetadataEnhancementPermission)
			{
				enhOnSaveCheck.setVisible(!selectMode && !readOnly && !deConflictFromWF);
				enhOnSaveCheck.setEnabled(!selectMode && !readOnly && !deConflictFromWF);
				enhOnSaveLabel.setVisible(!selectMode && !readOnly && !deConflictFromWF);
				
			}
		}
	}

	/*
	 * Determine if the title metadata is read-only
	 */
	protected boolean isReadOnly(UITitleMetadata metadata) {
		boolean editable = metadata.isActive();
		if (getViewInput().isExistingTitle()) {
			editable &= getViewInput().hasTitleModifyPermission();
		} 
		else if(!titleView.getInput().isBulkEdit())
			editable &= getViewInput().hasTitleCreatePermission();
		else
			editable &= getViewInput().hasTitleModifyPermission();

		return !editable;
	}

	/* Update the input asset and update the view */
	private void handleGetTitleMetadataSuccess(UITitleInfo info) {
		this.filePaths = info.getFilePaths();
		this.currentSpecification = info.getSpecification();
		UITitleMetadata metadata = info.getTitle().getMetadata();
		String assetType = metadata.getRootAsset().getAssetType();
		UIAssetDefinition definition = currentSpecification.getAssetDefinition(assetType);

		boolean isBulkEdit = titleView.getInput().isBulkEdit();

		if (isBulkEdit) {
			this.currentTitle = new UITitle();
			UIAsset asset = (new UIAssetFactory()).createAsset(info.getSpecification(), true);
			this.assetInfo = new AssetInfo(titleView.getInput(), asset, definition, isBulkEdit);
		} else {
			this.currentTitle = info.getTitle();

			UIAsset asset = metadata.getRootAsset();
			this.assetInfo = new AssetInfo(titleView.getInput(), asset, definition, isBulkEdit);
		}

		/* Build the asset panel */
		boolean readOnly = isReadOnly(metadata) || getViewInput().isSelectButtonVisible();
		this.assetPanel = new AssetPanel(titleView, assetInfo, filePaths, readOnly);
		this.assetPanel.addViewChangeHandler(new ViewChangeHandler() {
			@Override
			public void onViewChange(ViewChangeEvent event) {
				markDirty();
			}
		});
		assetPanel.addOffsettingWidget(titleView.getMessageViewWidget());
		assetPanel.addOffsettingWidget(controlsContainer);
		
		this.assetPanel.addStyleName(STYLE_ASSET_PANEL);
		this.contentPanel.setWidget(0, 0, assetPanel);

		/* Show the main container if not already visible */
		if (getContainer().getWidget() != mainContainer)
			getContainer().setWidget(mainContainer);

		/* Update the size of the scroll container */
		updateScrollContainerSize();

		/* Update the title heading */
		updateTitleHeader(currentTitle.getOverview());

		// Category title
		if (isLicensedForCategoryManagement && info.getSpecification().getContentClassTypeId() == 2) 
		{
			this.isCategoryTitleAssociated = info.isCategoryTitleAssociated();

			// Set label on toggle button
			if (info.isCategoryTitleAssociated()) 
			{
				associateButton.setText(LBL_DISASSOCIATE);
			} 
			else 
			{
				associateButton.setText(LBL_ASSOCIATE);
			}
		}

		updateTabButtons(metadata);
		this.markUpdated();

		/* Hide the busy indicator */
		hideBusyIndicator();
		resolveConflictFromWorkflowIfNecessary();
	}

	/* Failure getting the title metadata from the server */
	private void handleGetTitleMetadataFailure(Throwable caught) 
	{
		if (caught instanceof ReadDeletedTitleException) 
		{
			showSevereError(caught.getMessage());
			/* Hide the busy indicator */
			hideBusyIndicator();
		} 
		else 
		{
			String error = caught.getLocalizedMessage();
			String message = this.getViewMessages().metadataFetchError(error);

			/* Show the error panel and hide busy indicator */
			showErrorPanel(message);
			hideBusyIndicator();
		}
	}

	// ==============================================================
	// ===================== VALIDATION
	// ==============================================================

	/*
	 * Focus on the widget with the validation message
	 */
	void showWidget(AssetValidationMessage message) {
		if (assetPanel != null) {
			assetPanel.setFocus(message);
		}
	}

	// ==============================================================
	// ===================== ANCHOR MANAGEMENT
	// ==============================================================

	@Override
	protected String getTabName() {
		return TAB_NAME;
	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().metadataTabName();
	}

	public AssetInfo getAssetInfo() {
		return assetInfo;
	}

	public AssetInfo getSelectedAssetInfo() {
		return assetPanel.getSelectedAssetInfo();
	}


	/////////////////////////////////////////////////////////////////////////
	// Preview
	////////////////////////////////////////////////////////////////////////
	
	public void previewAllActiveRules(UITitle title, String requestKey)
	{
		ITitleCompareViewController tcController = new ITitleCompareViewController()
		{
			@Override
			public void onCancel() 
			{
				getContainer().setWidget(deconflictWidget);
			}

			@Override
			public void onShowDifferences() 
			{
				compareDiff();
			}

			@Override
			public void onShowXml() 
			{
				compareXml();
			}

			@Override
			public void onSpecChanged(String newSpec) 
			{
				lastRequest.specName = newSpec;
				compareView.getInput().specName = newSpec;
				compareXml();
			}
		};

		compareView = new TitleCompareView(tcController);
		
		// Set view input parameters
		TitleCompareViewInput input = new TitleCompareViewInput();
		input.restrictedHeight = getUsedHeight();
		input.restrictedWidth = getUsedWidth();
		input.header = ruleMessages.allActiveRulesPreviewHeaderMessage();
		input.displayName1 = ruleMessages.rulePreviewBeforeNormalization();
		input.displayName2 = ruleMessages.rulePreviewAfterNormalization();
		compareView.setInput(input);

		// Create request
		lastRequest = new TitleSavePreviewRequest();
		lastRequest.specName = getViewInput().getSpecificationName();
		lastRequest.title = title;
		lastRequest.meRequestKey = requestKey;

		// Call RPC and update UI
		compareDiff();
		
		getContainer().setWidget(compareView);
	}
	
	
	public void compareXml()
	{
		compareView.showBusyIndicator();
		
		rulesService.previewRuleSpec(lastRequest, HtmlorXmlDisplayHelper.useHtml(), new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				compareView.showErrorView(caught);
				compareView.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp)
			{
				compareView.showXmlView(resp.xmlData);
				compareView.hideBusyIndicator();
			}
		}
		);
	}

	
	public void compareXmlTemplate()
	{
		compareView.showBusyIndicator();
		
		rulesService.previewRuleSpec(lastRulePreviewRequest, HtmlorXmlDisplayHelper.useHtml(), new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				compareView.showErrorView(caught);
				compareView.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp)
			{
				compareView.showXmlView(resp.xmlData);
				compareView.hideBusyIndicator();
			}
		}
		);
	}
	

	public void compareDiff()
	{
		showBusyIndicator();
		
        rulesService.previewRule(lastRequest, new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				getContainer().setWidget(compareView);
				compareView.showErrorView(caught);
				hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp) 
			{
				getContainer().setWidget(compareView);
				setSpecName(resp.diffData);
				compareView.getInput().compareData = resp.diffData;
				compareView.showDiffView();
				hideBusyIndicator();
			}
		}
        );
	}

	
	public void compareDiffTemplate()
	{
		showBusyIndicator();
		
        rulesService.previewRule(lastRulePreviewRequest, new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				getContainer().setWidget(compareView);
				compareView.showErrorView(caught);
				hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp) 
			{
				getContainer().setWidget(compareView);
				setSpecName(resp.diffData);
				compareView.getInput().compareData = resp.diffData;
				compareView.showDiffView();
				hideBusyIndicator();
			}
		}
        );
	}
	
	
	private void setSpecName(UITitleCompareData data)
	{
		// Set default spec name if it is null
		if(lastRequest != null && data != null)
		{
			if(lastRequest.specName == null)
			{
				List<UIAssetSpecificationListItem> specs = data.getSpecifications(); 
				if(specs != null && specs.size() > 0) lastRequest.specName = specs.get(0).getName();
			}
		}
		
		// Set default spec name if it is null
		if(lastRulePreviewRequest != null && data != null)
		{
			if(lastRulePreviewRequest.specName == null)
			{
				List<UIAssetSpecificationListItem> specs = data.getSpecifications(); 
				if(specs != null && specs.size() > 0) lastRulePreviewRequest.specName = specs.get(0).getName();
			}
		}
	}
	

	public void previewAllActiveRules(Long titleId, String requestKey)
	{
		ITitleCompareViewController tcController = new ITitleCompareViewController()
		{
			@Override
			public void onCancel() 
			{
				getContainer().setWidget(deconflictWidget);
			}

			@Override
			public void onShowDifferences() 
			{
				compareDiffTemplate();
			}

			@Override
			public void onShowXml() 
			{
				compareXmlTemplate();
			}

			@Override
			public void onSpecChanged(String newSpec) 
			{
				lastRulePreviewRequest.specName = newSpec;
				compareView.getInput().specName = newSpec;
				compareXmlTemplate();
			}
		};

		compareView = new TitleCompareView(tcController);
		
		// Set view input parameters
		TitleCompareViewInput input = new TitleCompareViewInput();
		input.restrictedHeight = getUsedHeight();
		input.restrictedWidth = getUsedWidth();
		input.header = ruleMessages.allActiveRulesPreviewHeaderMessage();
		input.displayName1 = ruleMessages.rulePreviewBeforeNormalization();
		input.displayName2 = ruleMessages.rulePreviewAfterNormalization();
		compareView.setInput(input);

		// Create request
		lastRulePreviewRequest = new RulePreviewRequest();
		lastRulePreviewRequest.specName = getViewInput().getSpecificationName();
		lastRulePreviewRequest.titleId = titleId;
		lastRulePreviewRequest.meRequestKey = requestKey;
		lastRulePreviewRequest.ruleSetId = -1;	// All rules
		lastRulePreviewRequest.enhance = true;
		
		// Call RPC and update UI
		compareDiffTemplate();
		
		getContainer().setWidget(compareView);
	}

	@Override
	public void reportFailure(Throwable caught) {
		TitleValidationViewInput input = new TitleValidationViewInput();
		input.setMetadataTab(this);
		input.setErrorHeader(caught.getLocalizedMessage());
		getTitleView().showMessage(input);
    	updateAssetPanelHeight();
	}

	@Override
	public Widget getParentContainer() {
		return mainContainer;
	}

	@Override
	public void cleanup() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void refresh(String infoMessage) {
		refreshTab();
		show(infoMessage);
	}

	@Override
	public void show(String infoMessage) {
		if(infoMessage != null && !infoMessage.isEmpty()) {
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setMetadataTab(this);
			input.setInfoHeader(infoMessage);
			getTitleView().showMessage(input);
	    	updateAssetPanelHeight();
		}
	}

	@Override
	public List<Long> getSeletedRecordIds() {
		List<Long> ids = new ArrayList<Long>();
		ids.add(currentTitle.getId());
		
		return ids;
	}

	@Override
	public IActionInput getInputToExecution() {
		return new TitleListActionInput(getViewInput().getSpecificationName());
	}

	@Override
	public void show(boolean readOnly) {
		this.goButton.setEnabled(readOnly);
		this.actionsListBox.setEnabled(readOnly);
		this.parameterListBox.setEnabled(readOnly);
	}
	
	public ServiceMap getServiceMap() {
		if (serviceMap == null) {
			serviceMap = new ServiceMap();
		}

		return serviceMap;
	}

	public ServiceLoader getServiceLoader() {
		if (serviceLoader == null) {
			serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
		}

		return serviceLoader;
	}

	//A Workaround. ButtonClickListener is null onChange Event without this.
	private class ActionChangeHandler implements ChangeHandler {

		ButtonClickListener buttonClickListener = null;

		public ActionChangeHandler(ButtonClickListener buttonClickListener) {
			this.buttonClickListener = buttonClickListener;
		}

		@Override
		public void onChange(ChangeEvent event) {
		}
		
	}
}