/*
 * Created on Jul 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.title.view.metadata;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessage;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleValidationMessageType;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetValidationMessage;

/**
 * @author Vijay Silva
 */
public class TitleValidationViewInput 
{
	private enum ViewType { INFO, ERROR };
	private ViewType type = ViewType.ERROR;
	
	private String headingMessage;
	private List<UITitleValidationMessage> titleValidationMessages;
	private List<AssetValidationMessage> assetValidationMessages;

	private TitleMetadataTab metadataTab;

	
	/**
	 * The view input for the title validation view
	 */
	public TitleValidationViewInput() 
	{
		this.titleValidationMessages = new ArrayList<UITitleValidationMessage>();
		this.assetValidationMessages = new ArrayList<AssetValidationMessage>();
	}

	public boolean isInfoType()
	{
		return type == ViewType.INFO;
	}

	public boolean isErrorType()
	{
		return type == ViewType.ERROR;
	}


	public void setMetadataTab(TitleMetadataTab tab)
	{
		metadataTab = tab;
	}

	public TitleMetadataTab getMetadataTab()
	{
		return metadataTab;
	}


	/**
	 * @return the headingMessage
	 */
	public String getMessageHeader() 
	{
		return headingMessage;
	}

	/**
	 * @param headingMessage the headingMessage to set
	 */
	public void setErrorHeader(String headingMessage) 
	{
		this.type = ViewType.ERROR;
		this.headingMessage = headingMessage;
	}

	public void setInfoHeader(String headingMessage) 
	{
		this.type = ViewType.INFO;
		this.headingMessage = headingMessage;
		this.titleValidationMessages.clear();
		this.assetValidationMessages.clear();		
	}
	
	/**
	 * @return the titleValidationMessages
	 */
	public List<UITitleValidationMessage> getTitleValidationMessages() 
	{
		return titleValidationMessages;
	}

	/**
	 * @return the assetValidationMessages
	 */
	public List<AssetValidationMessage> getAssetValidationMessages() 
	{
		return assetValidationMessages;
	}

	public void clear() 
	{
		this.titleValidationMessages.clear();
		this.assetValidationMessages.clear();
		this.headingMessage = null;
	}

	/**
	 * Determine if any validation messages are present
	 * 
	 * @return true if validation messages are present, false otherwise
	 */
	public boolean hasValidationMessages() 
	{
		return (titleValidationMessages.size() > 0 || assetValidationMessages.size() > 0);
	}

	/**
	 * Get the total count of validation messages
	 * 
	 * @return true if validation messages are present, false otherwise
	 */
	public int getMessageCount() 
	{
		return (titleValidationMessages.size() + assetValidationMessages.size());
	}

	/**
	 * Get the number of error messages
	 * 
	 * @return The number of error messages
	 */
	public int getErrorMessageCount() 
	{
		int count = getMessageCount(UITitleValidationMessageType.Error);
		count += assetValidationMessages.size();
		return count;
	}

	/**
	 * Get the number of warning messages
	 * 
	 * @return The number of warning messages
	 */
	public int getWarningMessageCount() 
	{
		return getMessageCount(UITitleValidationMessageType.Warning);
	}

	/**
	 * Get the number of information messages
	 * 
	 * @return The number of information messages
	 */
	public int getInformationMessageCount() 
	{
		return getMessageCount(UITitleValidationMessageType.Information);
	}

	/*
	 * Get the count of title validation messages by message type
	 */
	private int getMessageCount(UITitleValidationMessageType messageType) 
	{
		int count = 0;
		for (UITitleValidationMessage message : titleValidationMessages) 
		{
			if (messageType.equals(message.getMessageType()))
				count++;
		}
		return count;
	}
}
