package com.tandbergtv.cms.portal.content.client.title.view.mso;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy.KeyboardSelectionPolicy;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIRuleActionChange;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewTab;
import com.tandbergtv.cms.portal.ui.title.client.NormalizationActionConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;


public class MSORulesPreviewView extends Composite {

	private FlexTable ruleTable;
	private String headerStyle = "mso-t-header";
	private HorizontalPanel contentPanel;
	
	private SimplePanel mainPanel;
	private ScrollPanel msoScroll;
	private ScrollPanel ruleScroll;
	private CellList<String> cellList;
	private IRulesPreviewServiceAsync rulesService = GWT.create(IRulesPreviewService.class);
	private NormalizationActionConstants actionConstants = (NormalizationActionConstants) GWT.create(NormalizationActionConstants.class);

	private List<UiMso> msoList = new ArrayList<UiMso>();
	private RulesPreviewTab rulesPreviewTab = null;
	private Long currentSiteTitleId;
	private Integer currentRuleSetId;
	public MSORulesPreviewView(RulesPreviewTab rulesPreviewTab) {
		this.rulesPreviewTab = rulesPreviewTab;
		mainPanel = new SimplePanel();
		contentPanel = new HorizontalPanel();
		msoScroll = new ScrollPanel();
		ruleScroll = new ScrollPanel();
		ruleTable = new FlexTable();
		TextCell textCell = new TextCell();
		 cellList = new CellList<String>(textCell);
		 this.initWidget(mainPanel);
		buildTableHeader(ruleTable);
		this.addStyleName("ContentClassEditView");
		msoScroll.addStyleName("msoRulesleftScrollContainer");
		ruleScroll.addStyleName("MetadataTabContainer");

//		msoScroll.setHeight(SCROLL_HIGHT + "px");
//		ruleScroll.setHeight(SCROLL_HIGHT + "px");
		msoScroll.add(cellList);
		msoScroll.setWidth("250px");
		ruleScroll.add(ruleTable);
		contentPanel.add(msoScroll );
		contentPanel.add(ruleScroll);
		contentPanel.setCellWidth(msoScroll, "250px");
		mainPanel.add(contentPanel);
	
		contentPanel.setCellHorizontalAlignment(msoScroll, HorizontalPanel.ALIGN_LEFT);
		contentPanel.setCellHorizontalAlignment(ruleScroll, HorizontalPanel.ALIGN_LEFT);
		
		
		 
		
	}


	public void buildUI(List<UiMso> result) {
		//mso cells
		
		msoList = result;
		if(msoList != null && !msoList.isEmpty()) {
			String defMso = msoList.get(0).getMsoName();
			updateRuleChangesPanel(defMso, msoList); //set default data for first mso in the list
		
		    cellList.setKeyboardSelectionPolicy(KeyboardSelectionPolicy.ENABLED);
		    final SingleSelectionModel<String> selectionModel = new SingleSelectionModel<String>();
		    cellList.setSelectionModel(selectionModel);
		    selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler() {
		      public void onSelectionChange(SelectionChangeEvent event) {
		        String selectedMso = selectionModel.getSelectedObject();
		        if (selectedMso != null) {
		        	updateRuleChangesPanel(selectedMso, msoList);
		        }
		      }

			
		    });
		   
		    cellList.setRowCount(msoList.size());
		    cellList.setRowData(0, getMsoList(result));
		    selectionModel.setSelected(msoList.get(0).getMsoName(), true);
		    
		}
		
				   
	}
	private void updateRuleChangesPanel(String selectedMso, List<UiMso> msoList) {
		final Integer msoId = getMsoId(selectedMso, msoList);
		rulesPreviewTab.getTitleView().showMessage(null);
		if(this.currentRuleSetId != null) {
			rulesService.getMsoRuleSet(this.currentSiteTitleId, this.currentRuleSetId, msoId, new AsyncCallback<List<UIRuleActionChange>>() {
	
				@Override
				public void onFailure(Throwable caught) {
					
					showError(caught.getMessage());
					
				}
	
				@Override
				public void onSuccess(List<UIRuleActionChange> result) {
					
					if(result != null && !result.isEmpty()) {
						buildTable(result);
						
					}
					else {
						showInfo("No overrides was found.");
					}
					
				}

				
	
				
			});
		}
		else {
			rulesService.getAllMSORuleSets(this.currentSiteTitleId, msoId, new AsyncCallback<List<UIRuleActionChange>>() {
				
				@Override
				public void onFailure(Throwable caught) {
					showError(caught.getMessage());
					
				}
	
				@Override
				public void onSuccess(List<UIRuleActionChange> result) {
					if(result != null && !result.isEmpty()) {
						buildTable(result);
						
					}
					else {
						
						ruleTable.removeAllRows();
						buildTableHeader(ruleTable);
						showInfo("No overrides was found.");
					}
				}
	
				
			});
		}
		
		
	}
	
	private void buildTable(List<UIRuleActionChange> changeList) {
		refresh();
		int row = 1;
		this.ruleTable.removeAllRows();
		buildTableHeader(ruleTable);
		for(UIRuleActionChange change: changeList) {
			setTableRow(this.ruleTable, row, change);
			row++;
		}
		
	}
	
	private void refresh() {

		
	}
	private void setTableRow(FlexTable ruleTable, final int row, final UIRuleActionChange change) {
		
		ruleTable.setWidget(row, 0, new Hyperlink(change.getRuleSetName(), "Rules.MsoOverride?id="+change.getRuleSetId()));
		ruleTable.setWidget(row, 1, new Label(change.getFieldName()));
		ruleTable.setWidget(row, 2, new Label(actionConstants.getString(change.getActionDisplayNameKey())));
		ruleTable.setWidget(row, 3, new Label(change.getFrom()));
		ruleTable.setWidget(row, 4, new Label(change.getTo()));
		
		ruleTable.getRowFormatter().setStyleName(row, "mso-t-body");
		for(int i = 0; i <=4; i++) {
			ruleTable.getCellFormatter().setHorizontalAlignment(row, i, HasAlignment.ALIGN_CENTER);
		}
	}
	private Integer getMsoId(String selectedMso, List<UiMso> msoList) {
		if(msoList != null) {
			for(UiMso mso: msoList) {
				if(mso.getMsoName().equalsIgnoreCase(selectedMso)) {
					return mso.getMsoId();
				}
			}
		}
		return null;
	}

	private List<String> getMsoList(List<UiMso> result) {
		List<String> msos = new ArrayList<String>();
		if(result != null) {
			for(UiMso mso: result) {
				msos.add(mso.getMsoName());
			}
		}
		return msos;
	}

	private void buildTableHeader(FlexTable ruleTable) {
		ruleTable.setWidth("100%");
		ruleTable.setWidget(0, 0, new LabelWidget("Rule Set Name"));
		ruleTable.setWidget(0, 1, new LabelWidget("Field Name"));
		ruleTable.setWidget(0, 2, new LabelWidget("Action"));
		ruleTable.setWidget(0, 3, new LabelWidget("Original Value"));
		ruleTable.setWidget(0, 4, new LabelWidget("Override Value"));

		ruleTable.getRowFormatter().addStyleName(0, headerStyle);

		for (int i = 0; i <= 4; i++) {

			ruleTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell");
			ruleTable.getCellFormatter().addStyleName(0, i, "content-AssetContentTable-cell-header");
			Widget widget = ruleTable.getWidget(0, i);
			if (widget instanceof LabelWidget) {
				widget.addStyleName("content-AssetContentTable-header-text");

			}
		}
		ruleTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row");
		ruleTable.getRowFormatter().addStyleName(0, "content-AssetContentTable-row-header");
		
	}

	public void setCurrentSiteTitleId(Long siteTitleId) {
		this.currentSiteTitleId = siteTitleId;
		
	}

	public void setCurrentRuleSetId(Integer ruleSetId) {
		this.currentRuleSetId = ruleSetId;
		
	}
	public void showError(String message) {
		TitleValidationViewInput input = new TitleValidationViewInput();
		input.setErrorHeader(message);
		
		rulesPreviewTab.getTitleView().showMessage(input);
	}
	public void showInfo(String message) {
		TitleValidationViewInput input = new TitleValidationViewInput();
		input.setInfoHeader(message);
		
		rulesPreviewTab.getTitleView().showMessage(input);
	}
}
