/**
 * File Name	:	MSOOverridesHistoryPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 18, 2012 11:12:00 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.MSOsPanel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEventHandler;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOOverridesHistoryPanel extends Composite implements MSOSelectedEventHandler {

	interface MyUiBinder extends UiBinder<Widget, MSOOverridesHistoryPanel> {}
	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
	
	@UiField
	Label errorLabel;
	
	@UiField
	MSOsPanel msosPanel;
	
	@UiField
	OverridesHistoryListPanel overridesHistoryListPanel;
	
	private BusyIndicator busyIndicator;

	private ITitleMSOOverridesHistoryServiceAsync titleMSOOverridesHistoryService = GWT.create(ITitleMSOOverridesHistoryService.class);
	
	private Long siteTitleId;
	
	/**
	 * 
	 */
	public MSOOverridesHistoryPanel() {
		initWidget(uiBinder.createAndBindUi(this));
		
		msosPanel.setEventBus(MSOOverridesHistoryTab.getEventBus());
		
		MSOOverridesHistoryTab.getEventBus().addHandler(MSOSelectedEvent.TYPE, this);
		
		/* Build the busy indicator */
		this.busyIndicator = new BusyIndicator();
	}

	public MSOOverridesHistoryPanel(Map<String, String> info) {
		this();
	}
	
	public void refresh(final Long siteTitleId) {
		clearErrorMessage();
		showBusyIndicator();
		this.siteTitleId = siteTitleId;
		
		titleMSOOverridesHistoryService.getMSOs(siteTitleId, 
				new NeptuneAsyncCallback<List<UIMSO>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
				String errMsg = "Exception occurred while getting MSOs for siteTitleId : "
						+ siteTitleId
						+ " : "
						+ caught.getLocalizedMessage();
				showErrorMessage(errMsg);
			}

			@Override
			public void onNeptuneSuccess(List<UIMSO> result) {
				setMSOs(result);
				hideBusyIndicator();
			}

		});
	}
	
	@Override
	public void msoSelected(MSOSelectedEvent event) {
		overridesHistoryListPanel.setUiMSO(event.getUiMSO());
		overridesHistoryListPanel.setSiteTitleId(siteTitleId);
		overridesHistoryListPanel.refresh(null);
	}

	public void setMSOs(List<UIMSO> uiMSOs) {
		msosPanel.setMSOs(uiMSOs);
	}
	
    void clearErrorMessage() {
		errorLabel.setText("");    	
    }

    void showErrorMessage(String errMsg) {
		errorLabel.setText(errMsg);    	
    }

	/**
	 * Show the busy indicator in the center of the browser
	 */
	private void showBusyIndicator() {
		busyIndicator.center();
	}

	/**
	 * Hide the busy indicator, if showing
	 */
	private void hideBusyIndicator() {
		busyIndicator.hide();
	}


}
