/**
 * File Name	:	MSOOverrideHistoryTab.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 18, 2012 10:46:15 AM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import com.google.gwt.event.shared.HandlerManager;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class MSOOverridesHistoryTab extends TitleViewTab {

	/** Tab Name */ 
	public static final String TAB_NAME = "MSOOverridesHistory";

	private static HandlerManager eventBus;

	private MSOOverridesHistoryPanel msoOverridesHistoryPanel;
	
	/**
	 * @param parent
	 */
	public MSOOverridesHistoryTab(TitleView parent) {
		super(parent);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#initialize()
	 */
	@Override
	protected void initialize() {
		eventBus = new HandlerManager(this);
		msoOverridesHistoryPanel = new MSOOverridesHistoryPanel();
		this.getContainer().setWidget(msoOverridesHistoryPanel);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#refresh()
	 */
	@Override
	public void refreshTab() {
		// Get title id
		Long titleId = getViewInput().getTitleId();
		msoOverridesHistoryPanel.refresh(titleId);
		
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#getTabName()
	 */
	@Override
	protected String getTabName() {
		return TAB_NAME;
	}

	public static HandlerManager getEventBus() {
		return eventBus;
	}

	public static void setEventBus(HandlerManager eventBus) {
		MSOOverridesHistoryTab.eventBus = eventBus;
	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().msoOverridesHistoryTabName();
	}
}
