/**
 * File Name	:	PaginatedOverridesListDataProvider.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 5, 2012 6:35:46 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleMSOOverridesHistoryServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.NormalizationActionConstants;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OverridesHistoryListDataProvider implements
		DataProvider<Long, UIMSOOverrideHistoryRecord> {

    // column names
    private static final String FIELD_COLUMN = "fieldXPath";
    private static final String ACTION_COLUMN = "actionName";
    private static final String SEARCH_VALUE_COLUMN = "searchValue";
    private static final String REPLACEMENT_VALUE_COLUMN = "replacementValue";
    private static final String TIME_APPLIED_COLUMN = "timeApplied";
    private static final String DISTRIBUTED_VERSION_COLUMN = "distributedVersion";

    private OverridesHistoryListPanel view;

	private ITitleMSOOverridesHistoryServiceAsync titleMSOOverridesHistoryService = GWT
			.create(ITitleMSOOverridesHistoryService.class);

	private TitleViewMessages messages = GWT.create(TitleViewMessages.class);

	private List<Column<?, UIMSOOverrideHistoryRecord>> columns;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> fieldColumn;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> actionColumn;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> searchValueColumn;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> replacementValueColumn;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> timeAppliedColumn;
	private ColumnBase<String, UIMSOOverrideHistoryRecord> distributedVersionColumn;
	
	private PageFeatureImpl pageFeature;
	private SortFeatureImpl<Long, UIMSOOverrideHistoryRecord> sortFeature;
	private NormalizationActionConstants actionConstants = (NormalizationActionConstants) GWT.create(NormalizationActionConstants.class);
					
	/**
	 * 
	 */
	public OverridesHistoryListDataProvider(final OverridesHistoryListPanel view) {
		this.view = view;
		
		columns = new ArrayList<Column<?, UIMSOOverrideHistoryRecord>>();
		
		fieldColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(FIELD_COLUMN, messages.fieldNameColumn()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(record.getUiMSOOverrideHistory().getFieldDisplayName());
			}
		};
		fieldColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(fieldColumn);
		
		actionColumn  = new ColumnBase<String, UIMSOOverrideHistoryRecord>(ACTION_COLUMN, messages.action()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(actionConstants.getString(record.getUiMSOOverrideHistory().getActionName()));
			}
		};
		actionColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(actionColumn);
		
		searchValueColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(SEARCH_VALUE_COLUMN, messages.originalValueColumn()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(record.getUiMSOOverrideHistory().getSearchValue());
			}
		};
		searchValueColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(searchValueColumn);

		replacementValueColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(REPLACEMENT_VALUE_COLUMN, messages.overrideValueColumn()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(record.getUiMSOOverrideHistory().getReplacementValue());
			}
		};
		replacementValueColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		columns.add(replacementValueColumn);

		timeAppliedColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(TIME_APPLIED_COLUMN, messages.timeAppliedColumn()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(record.getUiMSOOverrideHistory().getTimeApplied());
			}
		};
		timeAppliedColumn.setCellStyle(TableConstants.STYLE_DATACELL_DATE);
		columns.add(timeAppliedColumn);

		distributedVersionColumn = new ColumnBase<String, UIMSOOverrideHistoryRecord>(DISTRIBUTED_VERSION_COLUMN, messages.distributedVersionColumn()) {
			public View<String> getView(UIMSOOverrideHistoryRecord record) {
				return new LabelStringView(record.getUiMSOOverrideHistory().getDistributedVersion());
			}
		};
		distributedVersionColumn.setCellStyle(TableConstants.STYLE_DATACELL_NUMERIC);
		columns.add(distributedVersionColumn);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#initialize(com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getColumns()
	 */
	@Override
	public List<Column<?, UIMSOOverrideHistoryRecord>> getColumns() {
		return columns;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecords(com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecords(final AsyncCallback<List<UIMSOOverrideHistoryRecord>> callback) {
		Long siteTitleId = view.getSiteTitleId();
		UIMSO uiMSO = view.getUiMSO();
		if ((siteTitleId != null) && (uiMSO != null)) {
			view.handleGetRecordsRequest();
			
			UIMSOOverridesHistoryRequest uiMSOOverridesHistoryRequest = new UIMSOOverridesHistoryRequest();
			uiMSOOverridesHistoryRequest.setMsoId(uiMSO.getMsoId());
			uiMSOOverridesHistoryRequest.setSiteTitleId(siteTitleId);
			uiMSOOverridesHistoryRequest.setStartIndex((pageFeature.getPageNumber() - 1)*(pageFeature.getPageSize()));
			uiMSOOverridesHistoryRequest.setNumRecords(pageFeature.getPageSize());
			uiMSOOverridesHistoryRequest.setSortColumnName(sortFeature.getSortColumnName());
			uiMSOOverridesHistoryRequest.setAscending(sortFeature.isAscending());
			
			titleMSOOverridesHistoryService.getMSOOverridesHistory(uiMSOOverridesHistoryRequest, new NeptuneAsyncCallback<UIMSOOverridesHistoryResponse>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					pageFeature.setRecordCount(-1);
	                callback.onFailure(caught);
	                view.handleGetRecordsFailureResponse(caught);
				}

				@Override
				public void onNeptuneSuccess(UIMSOOverridesHistoryResponse result) {
					List<UIMSOOverrideHistoryRecord> records = null;
					if (result != null) {
						records = new ArrayList<UIMSOOverrideHistoryRecord>();
						for (UIMSOOverrideHistory uiMSOOverrideHistory : result.getUiMSOOverrideHistories()) {
							UIMSOOverrideHistoryRecord record = new UIMSOOverrideHistoryRecord(
									uiMSOOverrideHistory);
							records.add(record);
						}
						pageFeature.setRecordCount(result.getCount());
					}
					callback.onSuccess(records);
					view.handleGetRecordsSuccessResponse(records);
				}
				
			});
			
		}
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecord(java.lang.Object, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecord(Long key, AsyncCallback<UIMSOOverrideHistoryRecord> callback) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isRecordCountEnabled()
	 */
	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isCheckboxEnabled()
	 */
	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}
		
	public void setPageFeature(PageFeatureImpl pageFeature) {
		this.pageFeature = pageFeature;
	}
	
	public ColumnBase<String, UIMSOOverrideHistoryRecord> getDefaultSortColumn() {
        return searchValueColumn;
    }

	public SortOrder getDefaultSortOrder() {
		return SortOrder.ASCENDING;
	}
	
	public List<Column<?, UIMSOOverrideHistoryRecord>> getSortableColumns() {
		List<Column<?, UIMSOOverrideHistoryRecord>> sortableColumns = new ArrayList<Column<?, UIMSOOverrideHistoryRecord>>();
		
		sortableColumns.add(searchValueColumn);
		sortableColumns.add(replacementValueColumn);
		sortableColumns.add(timeAppliedColumn);
		sortableColumns.add(distributedVersionColumn);
		
		return sortableColumns;
	}
	
	public void setSortFeature(SortFeatureImpl<Long, UIMSOOverrideHistoryRecord> sortFeature) {
		this.sortFeature = sortFeature;
	}
}
