/**
 * File Name	:	PaginatedOverridesListPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 5, 2012 6:23:33 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.tandbergtv.cms.portal.content.client.title.view.msooverrideshistory;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class OverridesHistoryListPanel extends Composite implements IView {

	private final BusyIndicator busyIndicator = new BusyIndicator();

	private OverridesHistoryListDataProvider dataProvider;
	
	private Long siteTitleId;
	
	private UIMSO uiMSO;
		
    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UIMSOOverrideHistoryRecord> table;
    
    // spacing between the table and message panel
    private static final int SPACING = 2;

	public OverridesHistoryListPanel() {
		this.dataProvider = new OverridesHistoryListDataProvider(this);
		init();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#reportFailure(java.lang.Throwable)
	 */
	@Override
	public void reportFailure(Throwable caught) {
		Window.alert(caught.getLocalizedMessage());
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getParentContainer()
	 */
	@Override
	public Widget getParentContainer() {
		return mainContainer;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#cleanup()
	 */
	@Override
	public void cleanup() {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#refresh(java.lang.String)
	 */
	@Override
	public void refresh(String infoMessage) {
		mainContainer.clear();
		setContainers();
        this.table.getPageFeature().setPageNumber(1);
		this.table.showListView();
        this.table.refresh();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#show(java.lang.String)
	 */
	@Override
	public void show(String infoMessage) {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getSeletedRecordIds()
	 */
	@Override
	public List<Long> getSeletedRecordIds() {
        List<Long> selectedRecordIds = new ArrayList<Long>();
		List<UIMSOOverrideHistoryRecord> selectedRecords = table.getSelectedRecords();
		for (UIMSOOverrideHistoryRecord uiMSOOverrideRecord : selectedRecords) {
			selectedRecordIds.add(uiMSOOverrideRecord.getKey());
		}
		return selectedRecordIds;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getInputToExecution()
	 */
	@Override
	public IActionInput getInputToExecution() {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#show(boolean)
	 */
	@Override
	public void show(boolean readOnly) {
	}

	/*
	 * Ideally, use an event from data provider to notify view or use package protected code.
	 */
    public void handleGetRecordsRequest() {
    	showBusyIndicator();
    }
    
    /*
	 * Ideally, use an event from data provider to notify view. This is a 'shortcut'
	 */
    public void handleGetRecordsSuccessResponse(List<UIMSOOverrideHistoryRecord> records) {
		hideBusyIndicator();
	}

    /*
     * Ideally, use an event from data provider to notify view. This is a 'shortcut' 
     */
	public void handleGetRecordsFailureResponse(Throwable caught) {
		hideBusyIndicator();
	}

	public Long getSiteTitleId() {
		return siteTitleId;
	}

	public void setSiteTitleId(Long siteTitleId) {
		this.siteTitleId = siteTitleId;
	}

	public UIMSO getUiMSO() {
		return uiMSO;
	}

	public void setUiMSO(UIMSO uiMSO) {
		this.uiMSO = uiMSO;
	}
	
	private void init() {
    	initWidgets();
    	setContainers();
    }
    
    private void setContainers() {
    	mainContainer.add(table);
    }
    
    private void initWidgets() {
    	mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setWidth("100%");
        initWidget(mainContainer);
        
        table = new Table<Long, UIMSOOverrideHistoryRecord>(dataProvider);
        
		CookieStoreBasedPageFeatureImpl pageFeature = new CookieStoreBasedPageFeatureImpl("msoOverridesList");
		dataProvider.setPageFeature(pageFeature);
		table.addPageFeature(pageFeature);
		
		SortFeatureImpl<Long, UIMSOOverrideHistoryRecord> sortFeature = new SortFeatureImpl<Long, UIMSOOverrideHistoryRecord>(
				dataProvider.getDefaultSortColumn(), dataProvider.getDefaultSortOrder());
		for (Column<?, UIMSOOverrideHistoryRecord> sortableColumn : dataProvider.getSortableColumns()) {
			sortFeature.addSortableColumn(sortableColumn);
		}
		dataProvider.setSortFeature(sortFeature);
		// Not adding sorting in Overrides History Page
//		table.addSortFeature(sortFeature);
		
        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
            }

            @Override
            public void onNeptuneSuccess(Void result) {
            }
        } );
                
    }
    
		
    private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }

}
