/*
 * Created on Apr 30, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.title.view.preview;

import java.util.List;

import com.tandbergtv.cms.portal.content.client.title.model.UIActionTitle;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;

/**
 * Input for Title Preview Widget
 * 
 * @author Vijay Silva
 */
public class TitlePreviewWidgetInput {

	/* Properties */
	private List<UIAssetSpecificationListItem> specifications;
	private String selectedSpecification;
	private final UIActionTitle title;
	private int restrictedHeight;
	private int restrictedWidth;

	/**
	 * Constructor
	 */
	public TitlePreviewWidgetInput(UIActionTitle title) {
		this.title = title;
	}

	/**
	 * @return the specifications
	 */
	public List<UIAssetSpecificationListItem> getSpecifications() {
		return specifications;
	}

	/**
	 * @param specifications the specifications to set
	 */
	public void setSpecifications(List<UIAssetSpecificationListItem> specifications) {
		this.specifications = specifications;
	}

	/**
	 * @return the selectedSpecification
	 */
	public String getSelectedSpecification() {
		return selectedSpecification;
	}

	/**
	 * @param selectedSpecification the selectedSpecification to set
	 */
	public void setSelectedSpecification(String selectedSpecification) {
		this.selectedSpecification = selectedSpecification;
	}

	/**
	 * @return the restrictedHeight
	 */
	public int getRestrictedHeight() {
		return restrictedHeight;
	}

	/**
	 * @param restrictedHeight the restrictedHeight to set
	 */
	public void setRestrictedHeight(int restrictedHeight) {
		this.restrictedHeight = restrictedHeight;
	}

	/**
	 * @return the restrictedWidth
	 */
	public int getRestrictedWidth() {
		return restrictedWidth;
	}

	/**
	 * @param restrictedWidth the restrictedWidth to set
	 */
	public void setRestrictedWidth(int restrictedWidth) {
		this.restrictedWidth = restrictedWidth;
	}

	/**
	 * @return the title
	 */
	public UIActionTitle getTitle() {
		return title;
	}
}
