package com.tandbergtv.cms.portal.content.client.title.view.props;

import java.util.List;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;

/**
 * Main panel to display a list of title properties.
 * @author eyevkar
 */
public class TitlePropertiesPanel extends SimplePanel {
	private FlexTable table;
	
	/**
	 * Constructor
	 */
	public TitlePropertiesPanel() {
		table = new FlexTable();
		table.addStyleName("portletTable");
		this.add(table);
	}
	
	/**
	 * Refreshes the view with the data from the list.
	 * @param list
	 */
	public void refresh(List<KeyValuePair> list) {
		table.removeAllRows();
		createTableHeader();
		
		if(list != null) {
			for(int i = 0; i < list.size(); i++) {
				KeyValuePair kvp = list.get(i);
				createTableDataRow(i+1, kvp);
			}
		}
	}

	private void createTableHeader() {
		table.setWidget(0, 0, new Label("Name"));
		table.setWidget(0, 1, new Label("Value"));
		// Styles
		table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
		table.getCellFormatter().setStyleName(0, 1, "portlet-tableHeader");
	}

	private void createTableDataRow(int row, final KeyValuePair data) {
		table.setWidget(row, 0, new Label(data.getKey()));
		table.setWidget(row, 1, new Label(data.getValue()));
		
		table.getCellFormatter().setStyleName(row, 0, "portlet-table-text");
		table.getCellFormatter().setStyleName(row, 1, "portlet-table-text");
	}
}
