package com.tandbergtv.cms.portal.content.client.title.view.props;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.contentclass.model.KeyValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.service.ITitlePropertyViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitlePropertyViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * A tab on Title screen to display a list of title properties
 * @author eyevkar
 */
public class TitlePropertiesTab extends TitleViewTab {
	public static final String TAB_NAME = "Properties";

	private ITitlePropertyViewServiceAsync service = GWT.create(ITitlePropertyViewService.class);
	private ITitleViewServiceAsync viewService = GWT.create(ITitleViewService.class);
	
	private TitlePropertiesPanel mainPanel;
	
	/**
	 * Constructor
	 * @param parent
	 */
	public TitlePropertiesTab(TitleView parent) {
		super(parent);
	}

	@Override
	protected String getTabName() {
		return TAB_NAME;
	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().propertiesTabName();
	}

	@Override
	protected void initialize() {
		mainPanel = new TitlePropertiesPanel();
		this.getContainer().setWidget(mainPanel);
	}

	@Override
	public void refreshTab() 
	{
		showBusyIndicator();
		
		// Get title id
		Long titleId = getViewInput().getTitleId();
	
		if(getViewInput().getTitle().getOverview() == null)
		{
			viewService.getTitle(titleId, new NeptuneAsyncCallback<UITitle>()
			{
				@Override
				public void onNeptuneFailure(Throwable caught) {
					// TODO Auto-generated method stub
				}

				@Override
				public void onNeptuneSuccess(UITitle result) 
				{
					getViewInput().getTitle().setOverview(result.getOverview());
					updateTitleHeader(result.getOverview());
				}
			}
			);
		}
		
		
		// Call RPC service to get data
		service.getTitlePropertiesByTitleId(titleId, new NeptuneAsyncCallback<List<KeyValuePair>>() 
		{
			public void onNeptuneSuccess(List<KeyValuePair> result) {
				mainPanel.refresh(result);
				getContainer().setWidget(mainPanel);
				hideBusyIndicator();
			};

			public void onNeptuneFailure(Throwable caught) {
				if (caught instanceof ReadDeletedTitleException) {
					showSevereError(caught.getMessage());
				} else {
					String error = caught.getLocalizedMessage();
					String message = getViewMessages().propertiesFetchError(error);

					/* Show the error panel */
					showErrorPanel(message);
				}

				/* hide busy indicator */
				hideBusyIndicator();		
			};
		});
	}
}
