package com.tandbergtv.cms.portal.content.client.title.view.rules;

import com.ericsson.cms.me.client.Permissions;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public class MasterTitleFormPanel extends SimplePanel
{
	IRulesPreviewController controller = null;
	
	private ListBox lbSites;
	private ListBox lbRules;
	private CheckBox cbEnhance=null;
	
	public MasterTitleFormPanel()
	{
		// Content Provider and Content Class dropdowns
		FlexTable table = new FlexTable();
		//table.setCellPadding(10);
		table.setCellSpacing(10);
		
		// Row 1: Rules
		lbRules = new ListBox();
		table.setWidget(0, 0, new Label("Global Normalization Rules:"));
		table.setWidget(0, 1, lbRules);

		Button btnRulePreview = new Button("Preview", new ClickHandler() 
		{
		    public void onClick(ClickEvent event) 
		    {
		    	if(controller == null) return;
		    	
		    	String displayName = lbRules.getItemText(lbRules.getSelectedIndex());
		    	String strRuleId = lbRules.getValue(lbRules.getSelectedIndex());
		    	Integer ruleSetId = Integer.valueOf(strRuleId);
		    	
		    	boolean enhance = (cbEnhance == null) ? false : cbEnhance.getValue();
		    	controller.previewGlobalRule(ruleSetId, displayName, enhance);
		    }
		});
		btnRulePreview.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		
		table.setWidget(0, 2, btnRulePreview);
		
		// Row 2: Sites
		lbSites = new ListBox();
		table.setWidget(1, 0, new Label("Distribution Sites:"));
		table.setWidget(1, 1, lbSites);
		
		Button btnSitePreview = new Button("Preview", new ClickHandler() 
		{
		    public void onClick(ClickEvent event) 
		    {
		    	if(controller == null) return;

		    	String displayName = lbSites.getItemText(lbSites.getSelectedIndex());
		    	String strSiteId = lbSites.getValue(lbSites.getSelectedIndex());
    			Integer siteId = Integer.valueOf(strSiteId);

    			boolean enhance = (cbEnhance == null) ? false : cbEnhance.getValue();
    			controller.previewSiteRules(siteId, displayName, enhance);
		    }
		});
		btnSitePreview.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		
		table.setWidget(1, 2, btnSitePreview);
		
		
		NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
		boolean hasMetadataEnhancementPermission =  security.isUserInRole(Permissions.ME_ENHANCE);
		
		
		if (hasMetadataEnhancementPermission) {
			// Enhance checkbox
			cbEnhance = new CheckBox();
			cbEnhance.setValue(false);
		
			table.setWidget(2, 0, new Label("Enhance on Preview:"));
			table.setWidget(2, 1, cbEnhance);
		}
		
		this.add(table);
	}
	
	public void setController(IRulesPreviewController controller)
	{
		this.controller = controller;
	}
	
	public void refresh(RulePreviewInitData data)
	{
		// Sites dropdown
		lbSites.clear();
		for(NameValuePair nvp: data.sites)
		{
			lbSites.addItem(nvp.getName(), nvp.getValue());
		}
		
		// Rules dropdown
		lbRules.clear();
		lbRules.addItem("*** All Active Rules ***", "-1");
		
		for(NameValuePair nvp: data.rules)
		{
			lbRules.addItem(nvp.getName(), nvp.getValue());
		}
	}
	
}
