package com.tandbergtv.cms.portal.content.client.title.view.rules;

import java.util.List;

import com.ericsson.cms.me.client.model.DeconflictMode;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictCallback;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.UITitle;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UiMso;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewService;
import com.tandbergtv.cms.portal.content.client.title.service.IRulesPreviewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleViewServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.mso.MSORulesPreviewView;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;


public class RulesPreviewTab extends TitleViewTab implements IRulesPreviewController, ITitleCompareViewController
{
	public static final String TAB_NAME = "RulesPreview";
	
	private RulesPreviewMessages messages = GWT.create(RulesPreviewMessages.class);
	private IRulesPreviewServiceAsync rulesService = GWT.create(IRulesPreviewService.class);
	private ITitleViewServiceAsync viewService = GWT.create(ITitleViewService.class);
	
	private MasterTitleFormPanel masterTitleFormPanel;
	private SiteTitleFormPanel siteTitleFormPanel;
    private MSORulesPreviewView msoRulesPreviewView;
	private TitleCompareView compareView;
	private RulePreviewRequest lastRequest;
	
	private Widget goBackWidget = null;
	
	/**
	 * Constructor
	 * @param parent
	 */
	public RulesPreviewTab(TitleView parent) 
	{
		super(parent);
	}

	
	private void setSpecName(UITitleCompareData data)
	{
		// Set default spec name if it is null
		if(lastRequest != null && data != null)
		{
			if(lastRequest.specName == null)
			{
				List<UIAssetSpecificationListItem> specs = data.getSpecifications(); 
				if(specs != null && specs.size() > 0) lastRequest.specName = specs.get(0).getName();
			}
		}
	}
	
	@Override
	protected String getTabName() 
	{
		return TAB_NAME;
	}

	@Override
	protected void initialize() 
	{
		masterTitleFormPanel = new MasterTitleFormPanel();
		masterTitleFormPanel.setController(this);
		
		siteTitleFormPanel = new SiteTitleFormPanel();
		siteTitleFormPanel.setController(this);
	}

	
	private void setGoBackWidget(Widget w)
	{
		this.goBackWidget = w;
	}
	
	
	@Override
	public void refreshTab() 
	{
		showBusyIndicator();
		
		Long titleId = getViewInput().getTitleId();
		
		if(getViewInput().getTitle().getOverview() == null)
		{
			viewService.getTitle(titleId, new NeptuneAsyncCallback<UITitle>()
			{
				@Override
				public void onNeptuneFailure(Throwable caught) {
					// TODO Auto-generated method stub
				}

				@Override
				public void onNeptuneSuccess(UITitle result) 
				{
					getViewInput().getTitle().setOverview(result.getOverview());
					updateTitleHeader(result.getOverview());
				}
			}
			);
		}
		
		
		// Call RPC service to get data
		rulesService.getInitData(getViewInput().getTitleId(), new NeptuneAsyncCallback<RulePreviewInitData>() 
		{
			public void onNeptuneSuccess(RulePreviewInitData result)
			{
				// Site title
				if(result.isSiteTitle)
				{
					getContainer().setWidget(siteTitleFormPanel);
					setGoBackWidget(siteTitleFormPanel);
					siteTitleFormPanel.refresh(result);
					
					setMsoRulesData(result.siteId);
				}
				else
				{
					getContainer().setWidget(masterTitleFormPanel);
					setGoBackWidget(masterTitleFormPanel);
					masterTitleFormPanel.refresh(result);
				}
				
				hideBusyIndicator();				
			};

			

			public void onNeptuneFailure(Throwable caught) 
			{
				showSevereError(caught.getMessage());
				hideBusyIndicator();		
			};
		});
		//get mso rules
		
		
	}
	
	private void setMsoRulesData(final int siteId) {
		rulesService.getAllShallowMsoRuleSets(new NeptuneAsyncCallback<List<UIMsoRuleSet>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				showSevereError(caught.getMessage());
				
			}

			@Override
			public void onNeptuneSuccess(List<UIMsoRuleSet> result) {
				try {
					checkMPDistributionType(siteId, result);
				} catch (NeptuneException e) {
					// TODO Auto-generated catch block
					showSevereError(e.getMessage());
				}
				
				
			}

			
			
			
		});
		
	}
	private void checkMPDistributionType(int siteId, final List<UIMsoRuleSet> result) throws NeptuneException {
		rulesService.isMediaPathSiteTitle(siteId, new NeptuneAsyncCallback<Boolean>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				showSevereError(caught.getMessage());
				
			}

			@Override
			public void onNeptuneSuccess(Boolean check) {
				siteTitleFormPanel.setMsoRulesData(result, check);
				
			}

			

			
			
			
		});
		
	}

	@Override
	public void previewGlobalRule(Integer ruleSetId, String ruleDisplayName, boolean enhance)
	{
		compareView = new TitleCompareView(this);
		
		// Set view input parameters
		TitleCompareViewInput input = new TitleCompareViewInput();
		input.restrictedHeight = getUsedHeight();
		input.restrictedWidth = getUsedWidth();
		input.header = messages.globalRulePreviewHeaderMessage(ruleDisplayName);
		input.displayName1 = messages.rulePreviewBeforeNormalization();
		input.displayName2 = messages.rulePreviewAfterNormalization();
		compareView.setInput(input);

		// Create request
		lastRequest = new RulePreviewRequest();
		lastRequest.ruleSetId = ruleSetId;
		lastRequest.titleId = getViewInput().getTitleId();
		lastRequest.specName = getViewInput().getSpecificationName();
		lastRequest.enhance = enhance;

		// Call RPC and update UI
		compareDiff();
		
		getContainer().setWidget(compareView);
	}

	
	@Override
	public void previewSiteRules(Integer siteId, String siteDisplayName, boolean enhance)
	{
		compareView = new TitleCompareView(this);
		
		// Set view input parameters
		TitleCompareViewInput input = new TitleCompareViewInput();
		input.restrictedHeight = getUsedHeight();
		input.restrictedWidth = getUsedWidth();
		input.header = messages.allSiteRulesPreviewHeaderMessage(siteDisplayName);
		input.displayName1 = messages.rulePreviewBeforeNormalization();
		input.displayName2 = messages.rulePreviewAfterNormalization();
		compareView.setInput(input);

		lastRequest = new RulePreviewRequest();
		lastRequest.siteId = siteId;
		lastRequest.titleId = getViewInput().getTitleId();
		lastRequest.specName = getViewInput().getSpecificationName();
		lastRequest.enhance = enhance;

		compareDiff();
		
		getContainer().setWidget(compareView);
	}
	
	
	@Override
	public void previewSiteRule(Integer siteId, Integer ruleId, String siteDisplayName, boolean enhance) 
	{
		compareView = new TitleCompareView(this);
		
		// Set view input parameters
		lastRequest = new RulePreviewRequest();
		lastRequest.siteId = siteId;
		lastRequest.ruleSetId = ruleId;
		lastRequest.titleId = getViewInput().getTitleId();
		lastRequest.specName = getViewInput().getSpecificationName();
		lastRequest.enhance = enhance;
		
		TitleCompareViewInput input = new TitleCompareViewInput();
		input.restrictedHeight = getUsedHeight();
		input.restrictedWidth = getUsedWidth();
		input.header = messages.siteRulePreviewHeaderMessage(siteDisplayName);
		input.displayName1 = messages.rulePreviewBeforeNormalization();
		input.displayName2 = messages.rulePreviewAfterNormalization();
		
		compareView.setInput(input);
		compareDiff();
	}

	@Override
	public void previewMsoRules(Integer ruleSetId) {
		
		final Long siteTitleId = this.titleView.getInput().getTitleId();
		if(ruleSetId.intValue() == -1) {
			ruleSetId = null;
		}
		msoRulesPreviewView = new MSORulesPreviewView(this);
		msoRulesPreviewView.setCurrentSiteTitleId(siteTitleId);
		msoRulesPreviewView.setCurrentRuleSetId(ruleSetId);
		rulesService.getMsos(siteTitleId, ruleSetId, new NeptuneAsyncCallback<List<UiMso>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void onNeptuneSuccess(List<UiMso> result) {
				
				msoRulesPreviewView.buildUI(result);
				
				getContainer().setWidget(msoRulesPreviewView);
			}

			
			
		});

		
		
	}
	@Override
	public String getTabDisplayName() 
	{
		return getViewMessages().rulesPreviewTabName();
	}
	
	
	public void compareXml()
	{
		compareView.showBusyIndicator();
		
		rulesService.previewRuleSpec(lastRequest, HtmlorXmlDisplayHelper.useHtml(), new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				compareView.showErrorView(caught);
				compareView.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp)
			{
				compareView.showXmlView(resp.xmlData);
				compareView.hideBusyIndicator();
			}
		}
		);
	}


	public void compareDiff()
	{
		showBusyIndicator();
		
        rulesService.previewRule(lastRequest, new NeptuneAsyncCallback<RulePreviewResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) 
			{
				getContainer().setWidget(compareView);
				compareView.showErrorView(caught);
				hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(RulePreviewResponse resp) 
			{
				lastRequest.meRequestKey = resp.meRequestKey;
				
				// Show conflict resolution UI
				if(resp.meMultipleMatches)
				{
					hideBusyIndicator();
					showDeconflictPanel(resp.meRequestKey);
				}
				else
				{
					getContainer().setWidget(compareView);
					setSpecName(resp.diffData);
					compareView.getInput().compareData = resp.diffData;
					compareView.showDiffView();
					hideBusyIndicator();
				}
			}
		}
        );
	}

	
	private void showDeconflictPanel(final String meRequestKey)
	{
		MetadataDeconflictCallback meCallback = new MetadataDeconflictCallback() 
		{  
	          @Override    
	          public void saveWithEnhancement() 
	          {
	        	  lastRequest.meRequestKey = meRequestKey;
	        	  compareDiff();
	          }

	          @Override    
	          public void saveWithoutEnhancement() 
	          {
	          }
	          
	          @Override                                        
	          public void normalizeAndPreviewTitle() 
	          {
	          }
	          
	          @Override    
	          public void cancelSave() 
	          {
	        	  getContainer().setWidget(goBackWidget);
	          }

	          @Override    
	          public int getFrameRestrictedWidth() 
	          {  
	        	    return (getUsedWidth());
	          }
	          
	          @Override    
	          public int getFrameRestrictedHeight() 
	          {  
	        	    return (getUsedHeight());
	          }
	          
		      @Override
		      public void showMessage(String msg, boolean isError) {
		  			TitleValidationViewInput validationViewInput = new TitleValidationViewInput();
					if (isError)
						validationViewInput.setErrorHeader(msg);
	  				else
	  					validationViewInput.setInfoHeader(msg);
					titleView.showMessage(validationViewInput);
		      }
	      
		      @Override
		      public void clearMessage() {
		        	getTitleView().showMessage(null);
		      }		
		};

		MetadataDeconflictWidget meWidget = new MetadataDeconflictWidget(meRequestKey, meCallback, DeconflictMode.RULES_PREVIEW);
		getContainer().setWidget(meWidget);		
	}


	@Override
	public void onCancel() 
	{
		getContainer().setWidget(goBackWidget);
	}

	
	@Override
	public void onShowDifferences() 
	{
		compareDiff();
	}

	
	@Override
	public void onShowXml() 
	{
		compareXml();
	}

	
	@Override
	public void onSpecChanged(String newSpec) 
	{
		lastRequest.specName = newSpec;
		compareView.getInput().specName = newSpec;
		compareXml();
	}


	
	
}
