package com.tandbergtv.cms.portal.content.client.title.view.rules;

import java.util.List;

import com.ericsson.cms.me.client.Permissions;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.NameValuePair;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewInitData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.UIMsoRuleSet;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public class SiteTitleFormPanel extends SimplePanel
{
	private static final String CRITERIA_PANEL_CONTAINER_STYLE = "criteria-panel-container";
	private static final String CRITERIA_PANEL_STYLE = "criteria-panel";
	private IRulesPreviewController controller = null;
	private int siteId;
	
	private ListBox lbRules;
	private ListBox msoRules;
	private CheckBox cbEnhance=null;
	private VerticalPanel rulesPanel;
	private	VerticalPanel  normalizationPanel; 
	private	VerticalPanel  msoPanel;
	
	
	public SiteTitleFormPanel()	{  
		rulesPanel = new VerticalPanel();
		normalizationPanel = new VerticalPanel();
		msoPanel = new VerticalPanel();
		TextBoxWidget normalizationRulesHeader = new TextBoxWidget("Site Rules");
		TextBoxWidget msoRulesHeader = new TextBoxWidget("MSO Override");
		SimpleContainer normalizationRulesHeaderContainer = new SimpleContainer();
		SimpleContainer msoRulesHeaderContainer = new SimpleContainer();
		normalizationRulesHeaderContainer.setStyleName("rule-order-pos");
		msoRulesHeaderContainer.setStyleName("rule-order-pos");
		normalizationRulesHeader.setStyleName("rule-order-noneditable-header");
		msoRulesHeader.setStyleName("rule-order-noneditable-header");
		// Content Provider and Content Class dropdowns
		FlexTable table = new FlexTable();
		//table.setCellPadding(10);
		table.setCellSpacing(10);
		
		// Row 1: Rules
		lbRules = new ListBox();
		
		table.setWidget(0, 0, new Label("Site Normalization Rules:"));
		table.setWidget(0, 1, lbRules);

		Button btnRulePreview = new Button("Preview", new ClickHandler() 
		{
		    public void onClick(ClickEvent event) 
		    {
		    	if(controller == null) return;
		    	
		    	String displayName = lbRules.getItemText(lbRules.getSelectedIndex());
		    	String strRuleId = lbRules.getValue(lbRules.getSelectedIndex());
		    	Integer ruleSetId = Integer.valueOf(strRuleId);
		    	
		    	boolean enhance = (cbEnhance == null) ? false : cbEnhance.getValue();
		    	controller.previewSiteRule(siteId, ruleSetId, displayName, enhance);
		    }
		});
		btnRulePreview.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		
		table.setWidget(0, 2, btnRulePreview);
		
		// Enhance checkbox
		NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
		boolean hasMetadataEnhancementPermission =  security.isUserInRole(Permissions.ME_ENHANCE);
		
		
		if (hasMetadataEnhancementPermission) {
			cbEnhance = new CheckBox();
			cbEnhance.setValue(false);
		
			table.setWidget(2, 0, new Label("Enhance on Preview:"));
			table.setWidget(2, 1, cbEnhance);
		}
		
		normalizationRulesHeaderContainer.add(normalizationRulesHeader);
		msoRulesHeaderContainer.add(msoRulesHeader);
		normalizationPanel.add(normalizationRulesHeaderContainer);
		normalizationPanel.add(table);
	//	normalizationPanel.setStyleName(CRITERIA_PANEL_CONTAINER_STYLE);
		normalizationPanel.setStyleName(CRITERIA_PANEL_STYLE);
		msoPanel.add(msoRulesHeaderContainer);
		msoPanel.add(getMsoTable());
		msoPanel.setStyleName(CRITERIA_PANEL_STYLE);
		//setStyleName(CRITERIA_PANEL_STYLE);
		rulesPanel.add(normalizationPanel);
		rulesPanel.add(msoPanel);
		this.add(rulesPanel);
		
	}
	
	private Widget getMsoTable() {
		FlexTable table = new FlexTable();
		table.setCellSpacing(10);
		
		
		 msoRules = new ListBox();
				table.setWidget(0, 0, new Label("MSO Override Rules:"));
				table.setWidget(0, 1, msoRules);

				Button btnRulePreview = new Button("Preview", new ClickHandler() 
				{
				    public void onClick(ClickEvent event) 
				    {
				    	if(controller == null) return;

				    	String strRuleId = msoRules.getValue(msoRules.getSelectedIndex());
				    	Integer ruleSetId = Integer.valueOf(strRuleId);
				    	
				    	
				   	controller.previewMsoRules( ruleSetId);
				    }
				});
				btnRulePreview.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
				
				table.setWidget(0, 2, btnRulePreview);
		return table;
	}

	public void setController(IRulesPreviewController controller)
	{
		this.controller = controller;
	}
	
	public void refresh(RulePreviewInitData data)
	{
		this.siteId = data.siteId;
		
		// Rules dropdown
		lbRules.clear();
		lbRules.addItem("*** All Active Rules ***", "-1");
		
		for(NameValuePair nvp: data.rules)
		{
			lbRules.addItem(nvp.getName(), nvp.getValue());
		}
	}

	public void setMsoRulesData(List<UIMsoRuleSet> result, Boolean mpCheck) {
		if(!mpCheck) {
			this.msoPanel.setVisible(false);
		}
		else {
			msoRules.clear();
			msoRules.addItem("*** All Active Rules ***", "-1");
			
			for(UIMsoRuleSet ruleSet: result) {
				msoRules.addItem(ruleSet.getRuleSetDisplayName(), ruleSet.getRuleSetId().toString());
			}
		}
		
	}
	
}
