package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchSpecialColumns;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class EpisodeTableColumn  extends ColumnBase<String, TitleRecord> {
	private UiColumn uiColumn;
	private EpisodesPanel panel;
		

	public EpisodeTableColumn(UiColumn uiColumn, EpisodesPanel panel) {
		super(uiColumn.getInternalName(), uiColumn.getDisplayName());
		this.uiColumn = uiColumn;
		this.panel = panel;
	}

	public View<String> getView(TitleRecord record) {
		UISearchResultRec t = record.getTitle();

		for (UiField f : t.getFields()) {
			String colInternalName = TableColumnNameHelper
					.getColumnName(f.getName(), f.getParentAssetType());
			LabelStringView view = null;
			if (colInternalName.equals(getName())) {
				if (getName().equalsIgnoreCase(SearchSpecialColumns.STATUS)) {
					return new ImageView(f.getValue());
				} else {
					view = new LabelStringView(f.getValue());
				}
				return view;
			}
		}
		return new LabelStringView("ERROR: Value not available");
	}

	/*
	 * Determine the style to use based on the data type of the column data
	 */
	public String getColumnCellStyle() {
		String style = TableConstants.STYLE_DATACELL_GENERAL;
		if (uiColumn.getDataType() != null) {
			switch (uiColumn.getDataType()) {
				case BOOLEAN:
				case STRING:
					if(uiColumn.getName().equalsIgnoreCase(SearchSpecialColumns.STATUS))
						style = TableConstants.STYLE_DATACELL_ICON;
					else
						style = TableConstants.STYLE_DATACELL_TEXT;					
					break;
				case INTEGER:
				case FLOAT:
					style = TableConstants.STYLE_DATACELL_NUMERIC;
					break;
				case DATE:
				case TIME:
					style = TableConstants.STYLE_DATACELL_DATE;
					break;
			}
		}

		return style;
	}
	
	/**
	 * view for image columns e.g. status
	 *
	 */
	private class ImageView implements View<String> {

		String status;
		public ImageView(String status) {
			this.status = status;
		}

		@Override
		public Widget getWidget() {
			ImageWidget statusImage = new ImageWidget();
			TitleClientBundle bundle = new TitleClientBundle();
			bundle.updateTitleStatusIcon(statusImage, status);
			return statusImage;
		}	

		@Override
		public void release() {
		}
		
		@Override
		public String getStyleName() {
			return null;
		}		
	}
	
}
