package com.tandbergtv.cms.portal.content.client.title.view.series;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AnchorTokenizer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class EpisodeTitleTableDataProvider implements DataProvider<Long, TitleRecord> {

	private EpisodesPanel view;
	private List<Column<?, TitleRecord>> columns = new ArrayList<Column<?, TitleRecord>>();
	public static final String TITLE_ID_COLUMN_NAME = "titleId";

	private ISeriesTitleServiceAsync seriesTitleService = GWT.create(ISeriesTitleService.class);

	public EpisodeTitleTableDataProvider (EpisodesPanel view) {
		this.view = view;

	}

	public void init(final AsyncCallback<Void> callback) {
		//Call to get column info for the table
		view.showBusyIndicator();
		seriesTitleService.getEpisodeSearchColumns(new NeptuneAsyncCallback<List<UiColumn>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				view.hideBusyIndicator();
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(List<UiColumn> result) {
				view.hideBusyIndicator();
				initializeColumns(result);;
				// Also notify the view
				callback.onSuccess(null);
			}});
	}


	/* Initialize the columns */
	private void initializeColumns(List<UiColumn> searchResultsColumns) {
		columns.add(prepareTitleIdColumn());
		for (final UiColumn uiColumn : searchResultsColumns) {
			EpisodeTableColumn column = new EpisodeTableColumn(uiColumn, view);
			column.setCellStyle(column.getColumnCellStyle());
			columns.add(column);
		}
	}

	private Column<String, TitleRecord> prepareTitleIdColumn() {
		ColumnBase<String, TitleRecord> column = null;

		String displayName = view.getTitleViewMessages().episodesTableTitleIdColumn(); 
		column = new ColumnBase<String, TitleRecord>(TITLE_ID_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final TitleRecord record) {
				final String titleId = new Long(record.getTitle().getId()).toString();
				LabelStringView strView = new LabelStringView(titleId);
				strView.getWidget().addClickHandler(new ClickHandler()
				{
					@Override
					public void onClick(ClickEvent event)
					{						
						// Create history token
						Map<String, String> map = new HashMap<String, String>();
						map.put("Id", "" + titleId);
						// Add content anchor for this page to History object so that we can return to this page
						// when user do a "cancel" on the title details metadata tab.
						map.put("returnAnchor", History.getToken());

						AnchorTokenizer tkz = new AnchorTokenizer();

						String historyToken = "Content.Search." + tkz.buildAnchor(map);
						History.newItem(historyToken);
					}
				});

				strView.setStyleName(TableConstants.STYLE_DATA_LINK);

				return strView;
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);

		return column;
	}


	/**
	 * Sets the list of display columns which has the underlying data. View for
	 * these columns also has been built somewhere else.
	 *
	 * @param columns
	 */
	public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
		this.columns = columns;
	}

	@Override
	public void initialize(final AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public List<Column<?, TitleRecord>> getColumns() {
		return columns;
	}

	@Override
	public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {

		Long seriesDocumentId=null;
		Long seasonAssetId=null;

		AssetInfo input = view.getRootAssetInfo();
		UIAsset rootAsset = input.getAsset();
		UIAsset selectedAsset = view.getSelectedAssetInfo().getAsset();
		seriesDocumentId = rootAsset.getId();
		if ( selectedAsset.getAssetType().equalsIgnoreCase("SEASON")) {
			seasonAssetId = selectedAsset.getId();
			if (seasonAssetId == null)
				seriesDocumentId = null;
		}

		//If it is a new Series or Season asset, there is no need to do the backend call
		if (seriesDocumentId == null) {
			callback.onSuccess(new ArrayList<TitleRecord>());
			return;
		}

		view.showBusyIndicator();
		seriesTitleService.getEpisodeTitles(seriesDocumentId, seasonAssetId, new NeptuneAsyncCallback<UISearchResult>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				view.hideBusyIndicator();
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(UISearchResult result) {
				view.hideBusyIndicator();
				List<TitleRecord> records = new ArrayList<TitleRecord>();

				if(result.getTitles() == null ) {
					return;
				}

				for (UISearchResultRec t : result.getTitles()) {
					records.add(new TitleRecord(t));
				}
				callback.onSuccess(records);
			}});

	}

	@Override
	public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

}
