package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class EpisodesPanel  extends Composite {
	private TitleEpisodesTab parent;
	EpisodeTitleTableDataProvider dataProvider;
	private SimpleContainer rootContainer;
	private VerticalContainer mainContainer;

	private Table<Long, TitleRecord> episodeTable;
	private HeaderPanel header;
	private SucessPanel infoMessagePanel;
	private final BusyIndicator busyIndicator = new BusyIndicator();
	
	
	private static final String STYLE_NAME = "content-AssetContent";
	
	public EpisodesPanel(TitleEpisodesTab parent) {
		this.parent = parent;
	}

	protected TitleEpisodesTab getTab() {
		return parent;
	}
	
	private void initWidgets() {
		episodeTable = new Table<Long, TitleRecord>(dataProvider);
		rootContainer = new SimpleContainer();
		rootContainer.addStyleName(STYLE_NAME);
		
		mainContainer = new VerticalContainer();
		//mainContainer.setSpacing(SPACING);
		rootContainer.setWidget(mainContainer);
		initWidget(rootContainer);
	
		header = new HeaderPanel("");
		infoMessagePanel = new SucessPanel();
		String message = "..Please select a Series or Season asset" ; //this.getViewMessages().selectSeriesSeasonAsset();
		infoMessagePanel.addSuccessMessage(message);
		infoMessagePanel.setVisible(false);
		mainContainer.add(header);
		mainContainer.add(infoMessagePanel);
		mainContainer.add(episodeTable);
	}

	public void initDataProvider() {
		dataProvider = new EpisodeTitleTableDataProvider(this);	
		dataProvider.init(new NeptuneAsyncCallback<Void>() {
		    @Override
		    public void onNeptuneFailure(Throwable caught) {
		    }

		    @Override
		    public void onNeptuneSuccess(Void result) {
		    	initWidgets();
				parent.handleGetColumnRecordsSuccess();
		    }
		});
	}	
	
	
    public void showBusyIndicator() {
    	busyIndicator.center();
    }

    public void hideBusyIndicator() {
    	busyIndicator.hide();
    }
	    
	public void refresh(){
		if (episodeTable == null)
			return;
		
		UIAsset selectedAsset = getSelectedAssetInfo().getAsset();
		//Check if the selected asset type is either Series or Season
		if ( !selectedAsset.getAssetType().equalsIgnoreCase("SERIES") && !selectedAsset.getAssetType().equalsIgnoreCase("SEASON")) {
			infoMessagePanel.setVisible(true);
			episodeTable.setVisible(false);
			return;
		}
		
		infoMessagePanel.setVisible(false);
		episodeTable.setVisible(true);
		
		if (!episodeTable.isInitialized()) {
			episodeTable.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					episodeTable.refresh();
				}
			});
		} else {
			episodeTable.refresh();
		}
		
	}
    
	public AssetInfo getSelectedAssetInfo() {
		return parent.getSelectedAssetInfo();
	}

	public AssetInfo getRootAssetInfo() {
		return parent.getRootAssetInfo();
	}
	
	public TitleViewMessages getTitleViewMessages() {		
		return parent.getViewMessages();
	}
	
}
