package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTreeItemBuilder;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;

public class SeriesAssetTreeItemBuilder extends AssetTreeItemBuilder{
	static final String SEASON_ASSET_TYPE="SEASON"; 
	
	/**
	 * Constructor
	 */
	public SeriesAssetTreeItemBuilder() {
		super();
	}
	
	/*
	 * Build only season child tree items 
	 */
	@Override
	protected void buildChildTreeItems(TreeItem treeItem, AssetInfo assetInfo) {
		UIAssetDefinition definition = assetInfo.getDefinition();
		if (definition instanceof UIGroupAssetDefinition) {
			UIGroupAssetDefinition groupDefinition = (UIGroupAssetDefinition) definition;
			for (UIAssetDefinition childDefinition : groupDefinition.getChildren()) {
					if (childDefinition.getAssetType().equalsIgnoreCase(SEASON_ASSET_TYPE) == false)
						continue;
					this.parentAssetInfo = assetInfo;
					this.parentTreeItem = treeItem;
					childDefinition.accept(this);
					this.parentAssetInfo = null;
					this.parentTreeItem = null;
			}
		}
	}
}
