package com.tandbergtv.cms.portal.content.client.title.view.series;

import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeasonInfo;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class SeriesPanel  extends SimpleContainer  
{
	TitleSeriesTab parent;
	private VerticalContainer mainContainer;
	private HorizontalContainer selContainer;
	private HorizontalContainer butContainer;

	private ListBoxWidget<String> seriesListBox;
	private ListBoxWidget<String> seasonListBox;
	private ButtonWidget associateButton;
	private ButtonWidget disassociateButton;

	private UISeriesInfo curInfo;

	private static final String STYLE_NAME = "content-TitleListsPanel";
	private static final int SPACING = 4;

	
	public SeriesPanel(TitleSeriesTab parent) 
	{
		this.parent = parent;
		initWidgets();
	}
	
	
	private void initWidgets() 
	{
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(SPACING);
		mainContainer.setStylePrimaryName(STYLE_NAME);

		selContainer = new HorizontalContainer();
		selContainer.setSpacing(SPACING);
		
		LabelWidget seriesLabel = new LabelWidget(parent.getViewMessages().seriesLabelName());		
		selContainer.add(seriesLabel);
		
		seriesListBox = new ListBoxWidget<String>(false);
		seriesListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
				clearSeasons();
				populateSeasons();
			}
		});

		selContainer.add(seriesListBox);
		
		LabelWidget seasonLabel = new LabelWidget("  " + parent.getViewMessages().seasonLabelName());
		selContainer.add(seasonLabel);

		seasonListBox = new ListBoxWidget<String>(false);
		seasonListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
			}
		});
		
		selContainer.add(seasonListBox);		
		mainContainer.add(selContainer);
		
		String assocText = parent.getViewMessages().associateButtonText();
		associateButton = new ButtonWidget(assocText);
		associateButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		associateButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				asscociateClickedAction();
			}
		});
		associateButton.setVisible(true);
		associateButton.setEnabled(true);

		String disassocText = parent.getViewMessages().disassociateButtonText() ; 
		disassociateButton = new ButtonWidget(disassocText);
		disassociateButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		disassociateButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				disasscociateClickedAction();
			}
		});
		disassociateButton.setVisible(true);
		disassociateButton.setEnabled(true);
		
		butContainer = new HorizontalContainer();
		butContainer.setSpacing(SPACING);
		butContainer.add(associateButton);
		butContainer.add(disassociateButton);

		mainContainer.add(butContainer);
		setWidget(mainContainer);
	}
	
	
	public void refresh(UISeriesInfo curInfo) {
		this.curInfo = curInfo;
		populateSeries();
		if (curInfo.getSeriesAssetIdLookup().isEmpty())
			associateButton.setVisible(false); 
		else
			associateButton.setVisible(true); 
		if (curInfo.getAssociatedSeriesDocId() == null)
			disassociateButton.setVisible(false); 
		else {
			disassociateButton.setVisible(true); 
			associateButton.setVisible(false); 
		}
		
		this.parent.getTitleView().showMessage(null);
	}

	
	public void refreshAssociateMessage(boolean isError) 
	{
		if(isError) 
		{
			//errorMessagePanel.setVisible(true);
		}
		else 
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setInfoHeader(parent.getViewMessages().associateSuccessfulMessage() + curInfo.getSeriesTitleId());
			this.parent.getTitleView().showMessage(input);
		}
	}

	
	public void refreshDisassociateMessage(boolean isError, Long assocSeriesTitleId) 
	{
		if (isError) 
		{
			//errorMessagePanel.setVisible(true);
		}
		else 
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setInfoHeader(parent.getViewMessages().disassociateSuccessfulMessage() + assocSeriesTitleId);
			this.parent.getTitleView().showMessage(input);
		}
	}
	
	
	private void populateSeries() {
		String none = "";
		seriesListBox.clear();
		seriesListBox.setVisibleItemCount(1);

		clearSeasons();
		
		Long curSelection = curInfo.getAssociatedSeriesDocId();
		seriesListBox.addItem(none, none);
		Iterator<Entry<String, Long>> iter = curInfo.getSeriesAssetIdLookup().entrySet().iterator();
		while (iter.hasNext()) {
			Entry<String, Long> entry = iter.next();
			String seriesName = entry.getKey();
			Long seriesDocId = entry.getValue();
			seriesListBox.addItem(seriesName, seriesName);
			if (curSelection != null && seriesDocId!=null) {
				if (curSelection.longValue() == seriesDocId.longValue()) {
					seriesListBox.setItemSelected(seriesListBox.getIndex(seriesName), true);
					populateSeasons();
				}
			}
		}		
	}
	
	private void clearSeasons() {
		String none = "";
		seasonListBox.clear();
		seasonListBox.setVisibleItemCount(1);
		seasonListBox.addItem(none, none);		
	}
	
	private void populateSeasons() {
	
		String seriesName = seriesListBox.getSelectedItem();		
		Long curSelection = curInfo.getAssociatedSeasonAssetId();
		
		long seriesAssetId = curInfo.getSeriesAssetIdLookup().get(seriesName);
		List<UISeasonInfo> seasons = curInfo.getSeasonsLookUp().get(seriesAssetId);
		if (seasons == null)
			return;
		for (UISeasonInfo s:seasons) {
			String seasonName = s.getFieldValue();
			seasonListBox.addItem(seasonName, seasonName);
			Long seasonAssetId = s.getAssetId();
			if (curSelection != null && seasonAssetId != null) {
				if (curSelection.longValue() == seasonAssetId.longValue()) {
					seasonListBox.setItemSelected(seasonListBox.getIndex(seasonName), true);
				}				
			}
		}
		
	}
	
	
	private void asscociateClickedAction() 
	{
		String seriesName = seriesListBox.getSelectedItem();
		String seasonName = seasonListBox.getSelectedItem();
		
		if(seriesName.trim().isEmpty()) 
		{
			TitleValidationViewInput input = new TitleValidationViewInput();
			input.setErrorHeader(parent.getViewMessages().selectSeriesNameMessage());
			this.parent.getTitleView().showMessage(input);
			return;
		}
		
		Long seriesAssetId = curInfo.getSeriesAssetIdLookup().get(seriesName);
		Long seasonAssetId =null;
		List<UISeasonInfo> seasons = curInfo.getSeasonsLookUp().get(seriesAssetId);
		if(seasons != null) 
		{
			for(UISeasonInfo s:seasons) 
			{
				if(s.getFieldValue().equals(seasonName)) 
				{
					seasonAssetId = s.getAssetId();
				}
			}
		}
		
		parent.asscociateEpisodeToSeries(seriesAssetId, seasonAssetId);	
	}
	
	
	private void disasscociateClickedAction() 
	{
		Long assocSeriesTitleId = curInfo.getSeriesTitleId();
		parent.disasscociateEpisodeFromSeries(assocSeriesTitleId);	
	}
	
}
