package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.GridContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


public class SeriesTitleMetadataTab extends TitleMetadataTab {

	public SeriesTitleMetadataTab(TitleView parent) {
		super(parent);
	}

	/**
	 * Initialize the widgets displayed
	 * 
	 * @see com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab#initialize()
	 */
	@Override
	protected void initialize() {
		this.getContainer().addStyleDependentName("metadata");

		/* Build the 'content' section */
		contentPanel = new GridContainer(2, 1);
		contentPanel.addStyleName(STYLE_SCROLL_CONTENTS);
		contentPanel.getCellFormatter().addStyleName(0, 0, STYLE_VALIDATION_CELL);
		contentPanel.setWidget(1, 0, new LabelWidget(""));
		contentPanel.getCellFormatter().addStyleName(1, 0, STYLE_ASSETPANEL_CELL);

		/* The buttons: Select */
		String selectText = this.getViewMessages().selectButton();
		selectButton = new ButtonWidget(selectText);
		selectButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		selectButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				mapClickedAction();
			}
		});
		selectButton.setVisible(false);
		selectButton.setEnabled(false);

		/* The buttons: Save */
		String saveAllText = this.getViewMessages().saveAllButton();
		saveAllButton = new ButtonWidget(saveAllText);
		saveAllButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAllButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAllClickedAction();
			}
		});
		saveAllButton.setVisible(false);
		saveAllButton.setEnabled(false);

		/* The buttons: Save Current */
		String saveCurrentText = this.getViewMessages().saveAsCurrentStatusButton();
		saveCurrentButton = new ButtonWidget(saveCurrentText);
		saveCurrentButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveCurrentButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveCurrentClickedAction();
			}
		});
		saveCurrentButton.setVisible(false);
		saveCurrentButton.setEnabled(false);

		/* The buttons: Save as Draft */
		String saveAllAsDraftText = this.getViewMessages().saveAllAsDraftButton();
		saveAllAsDraftButton = new ButtonWidget(saveAllAsDraftText);
		saveAllAsDraftButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAllAsDraftButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAllAsDraftClickedAction();
			}
		});
		saveAllAsDraftButton.setVisible(false);
		saveAllAsDraftButton.setEnabled(false);

		/* The buttons: Save */
		String saveText = this.getViewMessages().saveButton();
		saveButton = new ButtonWidget(saveText);
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveClickedAction();
			}
		});
		saveButton.setVisible(false);
		saveButton.setEnabled(false);

		/* The buttons: Save as Draft */
		String saveAsDraftText = this.getViewMessages().saveAsDraftButton();
		saveAsDraftButton = new ButtonWidget(saveAsDraftText);
		saveAsDraftButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		saveAsDraftButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				saveAsDraftClickedAction();
			}
		});
		saveAsDraftButton.setVisible(false);
		saveAsDraftButton.setEnabled(false);

		/* The buttons: Cancel */
		String cancelText = this.getViewMessages().cancelButton();
		ButtonWidget cancelButton = new ButtonWidget(cancelText);
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				cancelClickedAction();
			}
		});
		
		// actionlist box
		actionsListBox = new ListBoxWidget<String>(false);

		// listbox for additional params used by the service
		parameterListBox = new ListBoxWidget<String>(false);
		parameterListBox.setVisible(false);
		multiSelectParameterListBox = new ListBoxWidget<String>(true);
		multiSelectParameterListBox.setVisible(false);
			
		// go button
		goButton = new ButtonWidget("Go");
		actionButtonHandler = new ButtonClickListener(actionsListBox, parameterListBox, this, getServiceMap());
		goButton.addClickHandler(actionButtonHandler);
		goButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);

		/* The Button Panel */
		controlsContainer = new VerticalContainer();
		controlsContainer.addStyleName(STYLE_BUTTON_CONTAINER);
		buttonContainer = new HorizontalContainer();
		buttonContainer.add(selectButton);
		buttonContainer.add(saveAllButton);
		buttonContainer.add(saveAllAsDraftButton);
		buttonContainer.add(saveCurrentButton);
		buttonContainer.add(saveButton);
		buttonContainer.add(saveAsDraftButton);
		buttonContainer.add(actionsListBox);
		buttonContainer.add(parameterListBox);
		buttonContainer.add(multiSelectParameterListBox);
		buttonContainer.add(goButton);
		buttonContainer.add(cancelButton);
		controlsContainer.add(buttonContainer);

		/* Build the main container */
		mainContainer = new VerticalContainer();
		mainContainer.add(contentPanel);
		mainContainer.add(controlsContainer);
		mainContainer.setCellHorizontalAlignment(controlsContainer, VerticalPanel.ALIGN_LEFT);
		mainContainer.setCellVerticalAlignment(controlsContainer, VerticalPanel.ALIGN_BOTTOM);

		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget();
		this.getContainer().setWidget(blankLabel);
	}

	/*
	 * Disable / hide all the buttons for the tab
	 */
	@Override
	protected void disableTabButtons() {
		/* Try and display select button */
		selectButton.setVisible(false);
		selectButton.setEnabled(false);

		/* Try and display save button */
		saveButton.setVisible(false);
		saveButton.setEnabled(false);

		/* Try and display save as draft button */
		saveAsDraftButton.setVisible(false);
		saveAsDraftButton.setEnabled(false);

		/* Try and display save button */
		saveAllButton.setVisible(false);
		saveAllButton.setEnabled(false);

		/* Try and display save as draft button */
		saveAllAsDraftButton.setVisible(false);
		saveAllAsDraftButton.setEnabled(false);

		/* Try and display save as draft button */
		saveCurrentButton.setVisible(false);
		saveCurrentButton.setEnabled(false);

	}

	/*
	 * Update the visibility of the buttons based on permissions and functionality
	 */
	@Override
	protected void updateTabButtons(UITitleMetadata metadata) {
		boolean readOnly = isReadOnly(metadata);
		boolean selectMode = this.getViewInput().isSelectButtonVisible();

		/* Try and display select button */
		selectButton.setVisible(selectMode && !readOnly);
		selectButton.setEnabled(selectMode && !readOnly);

		if (titleView.getInput().isBulkEdit()) {

			/* Try and display save button */
			saveAllButton.setVisible(!selectMode && !readOnly);
			saveAllButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveAllAsDraftButton.setVisible(!selectMode && !readOnly);
			saveAllAsDraftButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveCurrentButton.setVisible(!selectMode && !readOnly);
			saveCurrentButton.setEnabled(!selectMode && !readOnly);

		} else {

			/* Try and display save button */
			saveButton.setVisible(!selectMode && !readOnly);
			saveButton.setEnabled(!selectMode && !readOnly);

			/* Try and display save as draft button */
			saveAsDraftButton.setVisible(!selectMode && !readOnly);
			saveAsDraftButton.setEnabled(!selectMode && !readOnly);
		}
	
	}
}
