package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.tandbergtv.cms.portal.content.client.title.model.UIViewInfo;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.history.TitleHistoryTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleMetadataTab;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;

public class SeriesTitleView extends TitleView {

	private SeriesTitleMetadataTab smTab;

	public SeriesTitleView() {
		super();
	}

	public SeriesTitleView(TitleViewInput input) {
		super(input);
	}

	@Override
	protected void addTabs(TabContainer tabContainer) {
		TitleViewTab tab = null;

		/* Metadata Tab */
		smTab = new SeriesTitleMetadataTab(this);
		tabContainer.add(smTab, smTab.getTabDisplayName());

		/* History Tab */
		tab = new TitleHistoryTab(this);
		tabContainer.add(tab, tab.getTabDisplayName());

		/* Episodes Tab */
		tab = new TitleEpisodesTab(this, smTab);
		tabContainer.add(tab, tab.getTabDisplayName());
	}
	
	@Override
	public TitleMetadataTab getMetadataTab() {
		return smTab;
	}
	
	@Override
	protected void renderActionsListWidgets(UIViewInfo viewInfo) {
		if (getInput() != null && getInput().getTitleId() != null) {
			smTab.buildActionsListWidgets(false, true);
		}
		else {
			smTab.setWidgetsVisibility(false);
		}
	}

}
