package com.tandbergtv.cms.portal.content.client.title.view.series;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.UITitleMetadata;
import com.tandbergtv.cms.portal.content.client.title.model.metadata.asset.UIAsset;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.service.asset.UIAssetFactory;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree;
import com.tandbergtv.cms.portal.content.client.title.view.asset.AssetTree.AssetInfo;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.UITitleInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class TitleEpisodesTab extends TitleViewTab {

	private ScheduledCommand resizeCommand;
	private HandlerRegistration windowRegistration = null;
	private AssetInfo rootAssetInfo;
	private SeriesTitleMetadataTab metadataTab; // to get current AssetInfo

	private SimpleContainer container;
	private Grid splitContainer;
	private AssetTree assetTree;
	private ScrollPanel scrollPanel;
	private EpisodesPanel epPanel;

	private static final String STYLE_NAME = "content-AssetPanel";
	private static final String STYLE_SCROLL_CONTAINER = "content-TitleMetadataTab-scrollContainer";
	private static final String STYLE_SPLIT_CONTAINER = "content-AssetPanel-splitContainer";
	private static final String STYLE_TREE_CELL = "content-AssetPanel-splitContainer-treeCell";
	private static final String STYLE_CONTENT_CELL = "content-AssetPanel-splitContainer-contentCell";

	protected static final String STYLE_LOADING_LABEL = "content-TitleMetadataTab-loadingMessage";

	/** Tab Name */
	public static final String TAB_NAME = "Episodes";

	public TitleEpisodesTab(TitleView parent, SeriesTitleMetadataTab metadataTab) {
		super(parent);
		this.metadataTab = metadataTab;
	}

	void initWidgets() {
		epPanel = new EpisodesPanel(this);
		epPanel.initDataProvider(); // Getting column info for table
									// asynchronously
	}

	/*
	 * If Get column info for table is successful (from initDataProvider() of
	 * EpisodesPanel)
	 */
	public void handleGetColumnRecordsSuccess() {
		resizeCommand = new ScheduledCommand() {
			@Override
			public void execute() {
				resizeScrollContainer();
			}
		};

		container = new SimpleContainer();
		container.setStyleName(STYLE_NAME);

		scrollPanel = new ScrollContainer();
		scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
		scrollPanel.setPixelSize(0, 0);

		scrollPanel.setWidget(epPanel);

		// The container that contains the asset tree and asset content
		splitContainer = new Grid(1, 2);
		splitContainer.setStyleName(STYLE_SPLIT_CONTAINER);

		// Initialize the asset tree with the asset info
		assetTree = new SeriesAssetTree(rootAssetInfo); // create an asset tree
														// with only series and
														// season assets
		// Add the listener to the tree events to update the episodes panel
		assetTree.addSelectionHandler(new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				refreshEpisodeTitles();
			}
		});

		splitContainer.setWidget(0, 0, assetTree);
		splitContainer.getCellFormatter().setStyleName(0, 0, STYLE_TREE_CELL);
		splitContainer.setWidget(0, 1, scrollPanel);
		splitContainer.getCellFormatter()
				.setStyleName(0, 1, STYLE_CONTENT_CELL);

		container.setWidget(splitContainer);
		this.getContainer().setWidget(container);
		updateScrollContainerSize();

		if (getSelectedAssetInfo() == null) {
			// check for the source of AssetInfo
			if (metadataTab.getAssetInfo() != null) {
				String metadataTabSelectedAssetType = metadataTab
						.getSelectedAssetInfo().getAsset().getAssetType();
				// get selected node from metadata tab
				if (metadataTabSelectedAssetType.equalsIgnoreCase("SERIES")
						|| metadataTabSelectedAssetType
								.equalsIgnoreCase("SEASON"))
					assetTree.setSelectedAssetInfo(metadataTab
							.getSelectedAssetInfo());
				else
					assetTree.setSelectedAssetInfo(rootAssetInfo);
			} else
				setSelectedNode(); // get selected node from anchor
		}
	}

	// ==============================================================
	// ===================== WIDGET OVERRIDES
	// ==============================================================

	@Override
	protected void onLoad() {
		super.onLoad();

		windowRegistration = Window.addResizeHandler(new ResizeHandler() {
			public void onResize(ResizeEvent event) {
				updateScrollContainerSize();
			}
		});
	};

	@Override
	protected void onUnload() {
		windowRegistration.removeHandler();
		windowRegistration = null;

		super.onUnload();
	}

	// Update the size of the asset container widget
	private void updateScrollContainerSize() {
		Scheduler.get().scheduleDeferred(resizeCommand);
	}

	// Resize the scroll container
	// similar to TitleMetadataTab
	//
	private void resizeScrollContainer() {
		// Calculate the size to use
		int width = getTabWidth();
		int height = getTabHeight();

		height -= 70;
		width -= 167;
		
		// Set the dimensions
		scrollPanel.setPixelSize(width, height);
	}


	@Override
	public void refreshTab() {
		if (metadataTab.getAssetInfo() == null) {
			refreshWithNewTitleMetadata();
		} else {
			// Use asset info from the metadata tab
			rootAssetInfo = metadataTab.getAssetInfo();
			initWidgets();
		}
	}

	@Override
	protected String getTabName() {
		return TAB_NAME;
	}

	@Override
	protected void onTabSelected() {
		super.onTabSelected();

		updateScrollContainerSize();
	}

	@Override
	protected void onTabUnselected() {
		super.onTabUnselected();

		container.remove(splitContainer);
		this.getContainer().remove(container);
	}

	public AssetInfo getSelectedAssetInfo() {
		if (assetTree == null)
			return null;
		return assetTree.getSelectedAssetInfo();
	}

	public AssetInfo getRootAssetInfo() {
		return rootAssetInfo;
	}

	private void refreshEpisodeTitles() {
		if (getSelectedAssetInfo() == null) {
			return;
		}

		// update anchor. Need to know the selected node when returning to the
		// episodes tab
		// after viewing title details for the episode
		AssetInfo selectedNode = getSelectedAssetInfo();
		if (selectedNode.getAsset().getAssetType().equalsIgnoreCase("SEASON"))
			getViewInput().setSelectedAssetId(selectedNode.getAsset().getId());
		else
			getViewInput().setSelectedAssetId(null);
		titleView.fireViewAnchorChange();

		// Go to the backend and get list of episode titles for the selected
		// season or series
		epPanel.refresh();
	}

	@Override
	protected void initialize() {

	}

	/* Update the input asset and update the view */
	private void handleGetTitleMetadataSuccess(UITitleInfo info) {
		UIAssetSpecification currentSpecification = info.getSpecification();
		UITitleMetadata metadata = info.getTitle().getMetadata();
		UIAssetDefinition definition = currentSpecification
				.getAssetDefinition(metadata.getRootAsset().getAssetType());

		boolean isBulkEdit = titleView.getInput().isBulkEdit();

		if (isBulkEdit) {
			UIAsset asset = (new UIAssetFactory()).createAsset(
					info.getSpecification(), true);
			rootAssetInfo = new AssetInfo(titleView.getInput(), asset,
					definition, isBulkEdit);
		} else {
			UIAsset asset = metadata.getRootAsset();
			rootAssetInfo = new AssetInfo(titleView.getInput(), asset,
					definition, isBulkEdit);
		}

		/* Update the title heading */
		updateTitleHeader(info.getTitle().getOverview());

	}

	/* Failure getting the title metadata from the server */
	private void handleGetTitleMetadataFailure(Throwable caught) {
		if (caught instanceof ReadDeletedTitleException) {
			showSevereError(caught.getMessage());

		} else {
			String error = caught.getLocalizedMessage();
			String message = this.getViewMessages().metadataFetchError(error);

			/* Show the error panel */
			showErrorPanel(message);
		}
	}

	/*
	 * Fetch the specification and title metadata from the input and render the
	 * title
	 */
	private void refreshWithNewTitleMetadata() {
		// Make backend call to get the metadata

		showBusyIndicator();
		this.getViewInput().getMetadata(
				new NeptuneAsyncCallback<UITitleInfo>() {
					@Override
					public void onNeptuneSuccess(UITitleInfo result) {
						/* Hide the busy indicator */
						hideBusyIndicator();
						handleGetTitleMetadataSuccess(result);
						initWidgets();
					}

					@Override
					public void onNeptuneFailure(Throwable caught) {
						hideBusyIndicator();
						handleGetTitleMetadataFailure(caught);
					}
				});

	}

	/*
	 * Select the node in the asset tree from TitleViewInput (asset id set from
	 * anchor)
	 */
	private void setSelectedNode() {
		TitleViewInput input = getViewInput();
		Long seasonAssetId = input.getSelectedAssetId();
		// Get seasonAssetId from TitleViewInput(set from anchor)

		AssetInfo selectedNodeAssetInfo = getRootAssetInfo();
		if (seasonAssetId != null) {
			TreeItem parentTreeItem = assetTree.getItem(0);
			for (int index = 0; index < parentTreeItem.getChildCount(); index++) {
				TreeItem childTreeItem = parentTreeItem.getChild(index);
				AssetInfo nodeAssetInfo = assetTree.getAssetInfo(childTreeItem);
				Long assetId = nodeAssetInfo.getAsset().getId();
				if (assetId == null)
					continue;
				if (assetId.longValue() == seasonAssetId.longValue()) {
					selectedNodeAssetInfo = nodeAssetInfo;
				}
			}
		}

		assetTree.setSelectedAssetInfo(selectedNodeAssetInfo);
		return;

	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().episodesTabName();
	}
}
