package com.tandbergtv.cms.portal.content.client.title.view.series;


import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.title.model.series.UISeriesInfo;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleService;
import com.tandbergtv.cms.portal.content.client.title.service.ISeriesTitleServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.ReadDeletedTitleException;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewTab;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class TitleSeriesTab extends TitleViewTab  {

	/** Tab Name */
	public static final String TAB_NAME = "Series";
	private SeriesPanel mainPanel;
	private ISeriesTitleServiceAsync seriesTitleService = GWT.create(ISeriesTitleService.class);	

	public TitleSeriesTab(TitleView parent) {
		super(parent);
	}

	@Override
	protected void initialize() {		
		mainPanel = new SeriesPanel(this);
		this.getContainer().setWidget(mainPanel);
	}

	@Override
	public void refreshTab() {
		showBusyIndicator();
		
		// Get title id
		Long titleId = getViewInput().getTitleId();
		// Call RPC service to get data
		seriesTitleService.getSeriesTitleInfos(titleId, new NeptuneAsyncCallback<UISeriesInfo>() {
			public void onNeptuneSuccess(UISeriesInfo result) {
				mainPanel.refresh(result);
				getContainer().setWidget(mainPanel);
				/* Update the title heading */
				updateTitleHeader(result.getTitleOverView());
				hideBusyIndicator();
			};

			public void onNeptuneFailure(Throwable caught) {
				if (caught instanceof ReadDeletedTitleException) {
					showSevereError(caught.getMessage());
				} else {
					String error = caught.getLocalizedMessage();
					String message = getViewMessages().propertiesFetchError(error);

					/* Show the error panel */
					showErrorPanel(message);
				}

				/* hide busy indicator */
				hideBusyIndicator();		
			};
		});
		
	}

	@Override
	protected String getTabName() {
	    return TAB_NAME;
	}

	public void asscociateEpisodeToSeries(final Long seriesDocumentId, final Long seasonAssetId) 
	{
		showBusyIndicator();
		
		// Get title id
		Long episodeTitleId = getViewInput().getTitleId();
		// Call RPC service
		seriesTitleService.associateTitleToSeries(episodeTitleId, seriesDocumentId, seasonAssetId, new NeptuneAsyncCallback<UISeriesInfo>() 
		{
			public void onNeptuneSuccess(UISeriesInfo result) 
			{
				boolean isError=true;
				if(result.getSeriesTitleId() != null) 
				{
					Long AssociatedSeriesDocId = result.getAssociatedSeriesDocId();
					Long AssociatedSeasonAssetId = result.getAssociatedSeasonAssetId();
					if (AssociatedSeriesDocId != null && AssociatedSeriesDocId.equals(seriesDocumentId)) 
					{
						if(seasonAssetId==null && AssociatedSeasonAssetId==null) 
						{
							isError=false;
						}
						else if (seasonAssetId!=null) 
						{
							if(seasonAssetId.equals(AssociatedSeasonAssetId)) isError=false;
						}
					}
				}
				
				mainPanel.refresh(result);
				mainPanel.refreshAssociateMessage(isError);
				getContainer().setWidget(mainPanel);
				hideBusyIndicator();
			};

			public void onNeptuneFailure(Throwable caught) 
			{
				if (caught instanceof ReadDeletedTitleException) 
				{
					showSevereError(caught.getMessage());
				} 
				else 
				{
					String error = caught.getLocalizedMessage();
					String message = getViewMessages().propertiesFetchError(error);

					/* Show the error panel */
					showErrorPanel(message);
				}

				/* hide busy indicator */
				hideBusyIndicator();		
			};
		});
		
	}

	
	public void disasscociateEpisodeFromSeries(final Long assocSeriesTitleId) {
		
		showBusyIndicator();
		
		// Get title id
		Long episodeTitleId = getViewInput().getTitleId();
		// Call RPC service
		seriesTitleService.disassociateTitleFromSeries(episodeTitleId, new NeptuneAsyncCallback<UISeriesInfo>() 
		{
			public void onNeptuneSuccess(UISeriesInfo result) 
			{
				boolean isError=true;
				if(result.getSeriesTitleId() == null) 
				{
					Long AssociatedSeriesDocId = result.getAssociatedSeriesDocId();
					Long AssociatedSeasonAssetId = result.getAssociatedSeasonAssetId();
					if(AssociatedSeriesDocId==null && AssociatedSeasonAssetId==null) 
					{
						isError=false;
					}
				}
				mainPanel.refresh(result);
				mainPanel.refreshDisassociateMessage(isError, assocSeriesTitleId);
				getContainer().setWidget(mainPanel);
				hideBusyIndicator();
			};

			
			public void onNeptuneFailure(Throwable caught) 
			{
				if (caught instanceof ReadDeletedTitleException) 
				{
					showSevereError(caught.getMessage());
				} 
				else 
				{
					String error = caught.getLocalizedMessage();
					String message = getViewMessages().propertiesFetchError(error);

					/* Show the error panel */
					showErrorPanel(message);
				}

				/* hide busy indicator */
				hideBusyIndicator();		
			};
		});
		
	}

	@Override
	public String getTabDisplayName() {
		return getViewMessages().seriesTabName();
	}
}
