package com.tandbergtv.cms.portal.content.client.title.view.sites;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;


class DistributionSiteItemDataProvider implements DataProvider<UIDistributionSiteItem, DistributionSiteItemRecord> {

	private TitleViewMessages messages;
	private List<Column<?, DistributionSiteItemRecord>> columns;
	private SitesPanel parent;	
	private TitleClientBundle bundle = new TitleClientBundle();
	
	/* Constants */
	public static final String DISTRIBUTION_SITE_COLUMN_NAME = "distributionSiteName";
	public static final String TITLE_ID_COLUMN_NAME = "titleId";
	public static final String STATUS_COLUMN_NAME = "status";
	public static final String DIFF_MASTER_COLUMN_NAME = "differentFromMaster";	
	public static final String DIFF_DISTRIBUTED_COLUMN_NAME = "differentFromDistributed";	
	private static String HREF_TITLE_ID = "Content.Search.Id=";
	private static String HREF_SITE_ID = "Sites.View?id=";
	
	private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
	private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
	private static final String STYLE_ORIGINAL_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-orginalCompareIcon-different";
	private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
	private static final String STYLE_SITE_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-siteCompareIcon-different";
	private static final String STYLE_STATUS_TABLE = "content-DistributionSiteItem-statusTable";

	/**
	 * Constructor
	 * @param parent
	 */
	public DistributionSiteItemDataProvider(SitesPanel parent) {
		this.parent = parent;

		/* Initialize the internationalized messages */
		messages = GWT.create(TitleViewMessages.class);

		/* Initialize the columns */
		initializeColumns();
	}	
	
	/* Initialize the columns */
	private void initializeColumns() {
		columns = new ArrayList<Column<?, DistributionSiteItemRecord>>();
		/* Status Column */
		columns.add(prepareDistributionStatusColumn());
		
		/* Distribution Site Column */
		columns.add(prepareDistributionSiteColumn());
		
		/* Title Id Column */
		columns.add(prepareTitleIdColumn());
				
	}

	
	private Column<String, DistributionSiteItemRecord> prepareDistributionStatusColumn() {
		ColumnBase<String, DistributionSiteItemRecord> column = null;

		String displayName = messages.distributionSitesTableStatusColumn();
		column = new ColumnBase<String, DistributionSiteItemRecord>(DIFF_DISTRIBUTED_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final DistributionSiteItemRecord record) {
				final String status = getStatusValue(record.getDistSiteItem());

				return new View<String>() {
					@Override
					public String getStyleName() {
						return STYLE_STATUS_TABLE;
					}

					@Override
					public Widget getWidget() {
						// Create a container to store images
						HorizontalContainer container = new HorizontalContainer();
						
						// 1. Status image
						ImageWidget statusImage = getDistributionStatusImage(status);

						// 2. Master is different image
						boolean isDifferentFromMaster = record.getDistSiteItem().getIsDifferentFromMaster();
						ImageWidget imagMasterDifferent = getIsMasterDifferentImage(isDifferentFromMaster);
						if (isDifferentFromMaster) {
							imagMasterDifferent.addClickHandler(new ClickHandler() {
								public void onClick(ClickEvent event) {
									Long id = record.getDistSiteItem().getMasterTitleId();
									String version = record.getDistSiteItem()
									        .getMasterTargetedVersion();
									parent.getTab().showMasterTitleComparison(id, version);
								}
							});
						}

						// 3. Distributes is different image
						boolean isDifferentFromDistributed = record.getDistSiteItem().getIsDifferentFromDistributed();
						ImageWidget imagDistributedDifferent = getIsDistributedDifferentImage(isDifferentFromDistributed);
						if (isDifferentFromDistributed) {
							imagDistributedDifferent.addClickHandler(new ClickHandler() {
								public void onClick(ClickEvent event) {
									Long id = record.getDistSiteItem().getTitleId();
									String version = record.getDistSiteItem()
									        .getDistributedVersion();
									parent.getTab().showDistributedTitleComparison(id, version);
								}
							});
						}

						// Add 3 images to the container
						container.add(statusImage);
						container.add(imagMasterDifferent);
						container.add(imagDistributedDifferent);
						return container;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_ICON);
		
		return column;	
	}	
	
	
	private Column<String, DistributionSiteItemRecord> prepareDistributionSiteColumn() {
		ColumnBase<String, DistributionSiteItemRecord> column = null;

		String displayName = messages.distributionSitesTableNameColumn();
		column = new ColumnBase<String, DistributionSiteItemRecord>(DISTRIBUTION_SITE_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final DistributionSiteItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						String distributionSiteName = getDistributionSiteValue(record.getDistSiteItem());
						String siteId = getSiteIdValue(record.getDistSiteItem());
						HyperlinkWidget anchor = new HyperlinkWidget(distributionSiteName,HREF_SITE_ID+siteId);
						
						return anchor;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		
		return column;	
	}

	
	private Column<String, DistributionSiteItemRecord> prepareTitleIdColumn() {
		ColumnBase<String, DistributionSiteItemRecord> column = null;

		String displayName = messages.distributionSitesTableTitleIdColumn();
		column = new ColumnBase<String, DistributionSiteItemRecord>(TITLE_ID_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final DistributionSiteItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						String titleId = getTitleIdValue(record.getDistSiteItem());
						HyperlinkWidget anchor = new HyperlinkWidget(titleId,HREF_TITLE_ID+titleId);
						anchor.setStyleName(TableConstants.STYLE_DATA_LINK);
						return anchor;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		
		return column;	
	}
	
	
	
	@Override
	public List<Column<?, DistributionSiteItemRecord>> getColumns() {		
		return this.columns;
	}
	
	@Override
	public void getRecord(UIDistributionSiteItem key, AsyncCallback<DistributionSiteItemRecord> callback) {
		/* should never be used */
		callback.onSuccess(new DistributionSiteItemRecord(key));		
	}

	/**
	 * Get all the records from the server
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecords(com.google
	 *      .gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecords(final AsyncCallback<List<DistributionSiteItemRecord>> callback) {
		UITitleSites result =  parent.getUITitleSites();				
		List<DistributionSiteItemRecord> records = new ArrayList<DistributionSiteItemRecord>();
		for (UIDistributionSiteItem distSiteItem : result.getDistributionSiteItems()) {
					records.add(new DistributionSiteItemRecord(distSiteItem));
		}
		callback.onSuccess(records);
	
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		/* do nothing */
		callback.onSuccess(null);
	}

	/**
	 * No check box required for this table
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isCheckboxEnabled()
	 */	
	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	/**
	 * The total record count is displayed for the table
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isRecordCountEnabled()
	 */	
	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
	
	private ImageWidget getIsMasterDifferentImage(boolean isDifferent) {
		ImageWidget masterDifferenceImage = new ImageWidget();
		masterDifferenceImage.addStyleName(STYLE_ICON);
	
		if (isDifferent == true)
			masterDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON_DIFFERENT);
		else
			masterDifferenceImage.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
		String iconName = (isDifferent) ? "originalTitleDifferent" : "originalTitleNotDifferent";
		bundle.updateIcon(masterDifferenceImage, iconName);
		
		return masterDifferenceImage;
	}	

	private ImageWidget getIsDistributedDifferentImage(boolean isDifferent) {
		ImageWidget distributedDifferenceImage = new ImageWidget();
		distributedDifferenceImage.addStyleName(STYLE_ICON);
		if (isDifferent == true)
			distributedDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON_DIFFERENT);
		else
			distributedDifferenceImage.addStyleName(STYLE_SITE_DIFF_ICON);
		String iconName = (isDifferent) ? "distributedTitleDifferent" : "distributedTitleNotDifferent";
		bundle.updateIcon(distributedDifferenceImage, iconName);
		
		return distributedDifferenceImage;
	}	

	private ImageWidget getDistributionStatusImage(String status) {
		ImageWidget distStatusImage = new ImageWidget();
		distStatusImage.addStyleName(STYLE_ICON);
		bundle.updateDistributionStatusIcon(distStatusImage, status);
		
		return distStatusImage;
	}	
	
	/* Get the distribution site column value */
	private String getDistributionSiteValue(UIDistributionSiteItem distSiteItem) {
		return distSiteItem.getName();
	}	

	/* Get the site id value */
	private String getSiteIdValue(UIDistributionSiteItem distSiteItem) {
		return distSiteItem.getSiteId().toString();
	}		
	
	/* Get the title id column value */
	private String getTitleIdValue(UIDistributionSiteItem distSiteItem) {
		return distSiteItem.getTitleId().toString();
	}	
	
	/* Get the status column value */
	private String getStatusValue(UIDistributionSiteItem distSiteItem) {
		return distSiteItem.getStatus().toString();
	}	
}
