package com.tandbergtv.cms.portal.content.client.title.view.sites;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

class LocalTitleSitesPanel extends SimpleContainer {

	private TitleSitesTab parent;	
	private VerticalContainer mainContainer;
	private HorizontalContainer masterTitleIdContainer;
	private HorizontalContainer siteIdContainer;
	private VerticalContainer distSiteContainer;
	private HorizontalContainer diffFromMasterContainer;
	private HorizontalContainer diffFromLocalContainer;

	private LocalTrackingSiteItemDataProvider dataProviderTrackingSites;
	private Table<UITrackingSiteItem, TrackingSiteItemRecord> tableTrackingSites;
	private PageFeature pageFeature;
	private LabelWidget masterTitleIdLabel;
	private HyperlinkWidget masterTitleIdAnchor;	
	private LabelWidget distributionSiteLabel;
	private HyperlinkWidget siteIdAnchor;	
	private LabelWidget distributionStatusLabel;
	private LabelWidget diffFromMasterLabel;
	private LabelWidget diffFromLocalLabel;
	ImageWidget masterDifferenceImage;
	ImageWidget distributedDifferenceImage;
	
	private TitleClientBundle bundle = new TitleClientBundle();
	private UILocalTitleSites sites = null;
	
	private static final int DISTRIBUTION_TRACKING_SPACING = 10;
	private static String HREF_TITLE_ID = "Content.Search.Id=";
	private static String HREF_SITE_ID = "Sites.View?id=";

	private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
	private static final String STYLE_ORIGINAL_DIFF_ICON = "content-TitleViewHeaderWidget-orginalCompareIcon";
	private static final String STYLE_ORIGINAL_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-orginalCompareIcon-different";
	private static final String STYLE_SITE_DIFF_ICON = "content-TitleViewHeaderWidget-siteCompareIcon";
	private static final String STYLE_SITE_DIFF_ICON_DIFFERENT = "content-TitleViewHeaderWidget-siteCompareIcon-different";
	
	
	public LocalTitleSitesPanel(TitleSitesTab parent) {
		this.parent = parent;
		this.dataProviderTrackingSites = new LocalTrackingSiteItemDataProvider(this);
		
		init();
	}
	
	
	private void init() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(DISTRIBUTION_TRACKING_SPACING);

		masterTitleIdContainer = new HorizontalContainer();
		distSiteContainer = new VerticalContainer();
		siteIdContainer = new HorizontalContainer();
		diffFromMasterContainer = new HorizontalContainer();
		diffFromLocalContainer = new HorizontalContainer();
		
		masterTitleIdLabel = new LabelWidget();
		masterTitleIdAnchor = new HyperlinkWidget();
		distributionSiteLabel = new LabelWidget(parent.getViewMessages().distributionSiteLabel());
		siteIdAnchor = new HyperlinkWidget();
		distributionStatusLabel = new LabelWidget();

		masterDifferenceImage = new ImageWidget();
		diffFromMasterLabel = new LabelWidget(parent.getViewMessages().differentFromMasterLabel());
		diffFromMasterContainer.add(diffFromMasterLabel);
		diffFromMasterContainer.add(masterDifferenceImage);
		
		diffFromLocalLabel = new LabelWidget(parent.getViewMessages().differentFromLocalLabel());
		distributedDifferenceImage = new ImageWidget();
		diffFromLocalContainer.add(diffFromLocalLabel);
		diffFromLocalContainer.add(distributedDifferenceImage);
		
		masterTitleIdContainer.add(masterTitleIdLabel);
		masterTitleIdContainer.add(masterTitleIdAnchor);
		distSiteContainer.add(masterTitleIdContainer);

		siteIdContainer.add(distributionSiteLabel);
		siteIdContainer.add(siteIdAnchor);

		distSiteContainer.add(siteIdContainer);
		distSiteContainer.add(distributionStatusLabel);
		distSiteContainer.add(diffFromMasterContainer);
		distSiteContainer.add(diffFromLocalContainer);
		
		tableTrackingSites = new Table<UITrackingSiteItem, TrackingSiteItemRecord>(dataProviderTrackingSites);
		// page feature
		pageFeature = new PageFeatureImpl();
		dataProviderTrackingSites.setParentPageFeature(pageFeature);						 
		tableTrackingSites.addPageFeature(pageFeature);	
		
		mainContainer.add(distSiteContainer);
		mainContainer.add(tableTrackingSites);	

		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget("");
		this.setWidget(blankLabel);		
	}	
	
	/**
	 * Get the parent title sites tab
	 * 
	 * @return The title sites tab
	 */
	protected TitleSitesTab getTab() {
		return parent;
	}
		
	
	void handleGetTitleSiteRecordsSuccess(UILocalTitleSites sites) {
		this.sites = sites; 
		/* If there is no tracking sites for this title, hide the table */
		refreshDistributionSitesLabels();
		boolean hasTrackingSiteItems = (sites.getTrackingSiteItems().size() > 0);
		tableTrackingSites.setVisible(hasTrackingSiteItems);
		refreshTrackingSitesTable();

		this.getTab().hideBusyIndicator();
		this.getTab().markUpdated();
		
		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

/*	
	void handleGetTitleSiteRecordsFailure(Throwable caught) {
		tableTrackingSites.setVisible(false);
		TitleSitesTab tab = this.getTab();
		String message = tab.getViewMessages().distributionSiteFetchFailure(caught.getMessage());
		tab.showErrorPanel(message);

		this.getTab().hideBusyIndicator();
	}
*/	
	
	UILocalTitleSites getUILocalTitleSite(){
		return sites;
	}
	
	private void refreshDistributionSitesLabels(){		
		masterTitleIdLabel.setText(parent.getViewMessages().masterTitleIdLabel());
		masterTitleIdAnchor.setText(sites.getMasterTitleId().toString());
		masterTitleIdAnchor.setTargetHistoryToken(HREF_TITLE_ID + sites.getMasterTitleId());
		
		siteIdAnchor.setText(sites.getDistributionSiteItem().getName());
		siteIdAnchor.setTargetHistoryToken(HREF_SITE_ID + sites.getDistributionSiteItem().getSiteId());

		distributionStatusLabel.setText(parent.getViewMessages().distributionStatusLabel() + 
				                       sites.getDistributionSiteItem().getStatus());
		
		Widget w = diffFromMasterContainer.getWidget(1);
		if (w != null) {
			diffFromMasterContainer.remove(1);
		}
		diffFromMasterContainer.add(getIsMasterDifferentImage(sites.getDistributionSiteItem().getIsDifferentFromMaster()));

		w = diffFromLocalContainer.getWidget(1);
		if (w != null) {
			diffFromLocalContainer.remove(1);
		}
		diffFromLocalContainer.add(getIsDistributedDifferentImage(sites.getDistributionSiteItem().getIsDifferentFromDistributed()));
		
	}
	
	private void refreshTrackingSitesTable(){		
		if (!tableTrackingSites.isInitialized()) {
			tableTrackingSites.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableTrackingSites.refresh();
				}
			});
		} else {
			tableTrackingSites.refresh();
		}
	}

	private ImageWidget getIsMasterDifferentImage(boolean isDifferent) {
		ImageWidget image = new ImageWidget();
		image.addStyleName(STYLE_ICON);
	
		if (isDifferent == true)
			image.addStyleName(STYLE_ORIGINAL_DIFF_ICON_DIFFERENT);
		else
			image.addStyleName(STYLE_ORIGINAL_DIFF_ICON);
		String iconName = (isDifferent) ? "originalTitleDifferent" : "originalTitleNotDifferent";
		bundle.updateIcon(image, iconName);
	
		if (isDifferent) {
			image.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					handleMasterDifferenceLabelClick();
				}
			});
		}
		
		return image;
	}	

	private ImageWidget getIsDistributedDifferentImage(boolean isDifferent) {
		ImageWidget image = new ImageWidget();
		image.addStyleName(STYLE_ICON);
		if (isDifferent == true)
			image.addStyleName(STYLE_SITE_DIFF_ICON_DIFFERENT);
		else
			image.addStyleName(STYLE_SITE_DIFF_ICON);
		String iconName = (isDifferent) ? "distributedTitleDifferent" : "distributedTitleNotDifferent";
		bundle.updateIcon(image, iconName);
		if (isDifferent) {
			image.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					handleLocalDifferenceLabelClick();
				}
			});
		}
		
		return image;
	}	
	
	private void handleMasterDifferenceLabelClick() {
		UIDistributionSiteItem siteItem = (sites != null) ? sites.getDistributionSiteItem() : null;
		if (siteItem == null || !siteItem.getIsDifferentFromMaster()) {
			return;
		}

		Long titleId = siteItem.getMasterTitleId();
		String version = siteItem.getMasterTargetedVersion();
		getTab().showMasterTitleComparison(titleId, version);
	}
	
	private void handleLocalDifferenceLabelClick() {
		UIDistributionSiteItem siteItem = (sites != null) ? sites.getDistributionSiteItem() : null;
		if (siteItem == null || !siteItem.getIsDifferentFromDistributed()) {
			return;
		}

		Long titleId = siteItem.getTitleId();
		String version = siteItem.getDistributedVersion();
		getTab().showDistributedTitleComparison(titleId, version);
	}
}
