package com.tandbergtv.cms.portal.content.client.title.view.sites;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UILocalTitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

public class LocalTrackingSiteItemDataProvider implements DataProvider<UITrackingSiteItem, TrackingSiteItemRecord>  {
	private TitleViewMessages messages;
	private List<Column<?, TrackingSiteItemRecord>> columns;
	private LocalTitleSitesPanel parent;	
	private PageFeature parentPageFeature;
	private TitleClientBundle bundle = new TitleClientBundle();
	
	/* Constants */
	public static final String TRACKING_SITE_COLUMN_NAME = "trackingSiteName";
	public static final String TITLE_ID_COLUMN_NAME = "titleId";
	public static final String STATUS_COLUMN_NAME = "status";
	public static final String DISTRIBUTION_SITE_COLUMN_NAME = "distributionSiteName";	
	private static final String STYLE_ICON = "content-TitleOverviewWidget-icon";
	private static String HREF_SITE_ID = "Sites.View?id=";
	
	
	public LocalTrackingSiteItemDataProvider(LocalTitleSitesPanel parent) {
		this.parent = parent;

		/* Initialize the internationalized messages */
		messages = GWT.create(TitleViewMessages.class);

		/* Initialize the columns */
		initializeColumns();
	}	
	
	/* Initialize the columns */
	private void initializeColumns() {
		columns = new ArrayList<Column<?, TrackingSiteItemRecord>>();

		/* Status Column */
		columns.add(prepareTrackingStatusColumn());
		
		/* Tracking Site Column */
		columns.add(prepareTrackingSiteColumn());
	}

	private Column<String, TrackingSiteItemRecord> prepareTrackingStatusColumn() {
		ColumnBase<String, TrackingSiteItemRecord> column = null;

		String displayName = messages.statusColumnForLocalTable();
		column = new ColumnBase<String, TrackingSiteItemRecord>(STATUS_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final TrackingSiteItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return "";
					}

					@Override
					public Widget getWidget() {
						String status = getStatusValue(record.getTrackingSiteItem());
						ImageWidget statusImage = getTrackingStatusImage(status);
						return statusImage;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_ICON);
		
		return column;	
	}
	
	private Column<String, TrackingSiteItemRecord> prepareTrackingSiteColumn() {
		ColumnBase<String, TrackingSiteItemRecord> column = null;

		String displayName = messages.trackingSitesColumnForLocalTable();
		column = new ColumnBase<String, TrackingSiteItemRecord>(TRACKING_SITE_COLUMN_NAME, displayName) {
			@Override
			public View<String> getView(final TrackingSiteItemRecord record) {

				return new View<String>() {
					@Override
					public String getStyleName() {
						return TableConstants.STYLE_DATA_LINK;
					}

					@Override
					public Widget getWidget() {
						String trackingSite = getTrackingSiteValue(record.getTrackingSiteItem());
						String trackingSiteId = getTrackingSiteIdValue(record.getTrackingSiteItem());
						HyperlinkWidget anchor = new HyperlinkWidget(trackingSite,HREF_SITE_ID+trackingSiteId);
						
						return anchor;
					}

					@Override
					public void release() {
					}
				};
			}

		};
		column.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
		
		return column;	
	}
	
	
	@Override
	public List<Column<?, TrackingSiteItemRecord>> getColumns() {
		
		return this.columns;
	}

	@Override
	public void getRecord(UITrackingSiteItem key, AsyncCallback<TrackingSiteItemRecord> callback) {
		/* should never be used */
		callback.onSuccess(new TrackingSiteItemRecord(key));
	}

	/**
	 * Get all the tracking site records from the cached data
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#getRecords(com.google
	 *      .gwt.user.client.rpc.AsyncCallback)
	 */
	@Override
	public void getRecords(final AsyncCallback<List<TrackingSiteItemRecord>> callback) {
		// get all tracking sites for this local(copy) title in the system and prepare ui objects
		int length = getParentPageFeature().getPageSize();
		int start = (getParentPageFeature().getPageNumber() - 1) * length;

		UILocalTitleSites sites = parent.getUILocalTitleSite();
		
		getParentPageFeature().setRecordCount(sites.getTotalTrackingSites());
		
		List<UITrackingSiteItem> trackingSiteItemList = sites.getPagedTrackingSiteItems(start, length);
		List<TrackingSiteItemRecord> records = new ArrayList<TrackingSiteItemRecord>();
		for (UITrackingSiteItem trackingSiteItem : trackingSiteItemList) {
			records.add(new TrackingSiteItemRecord(trackingSiteItem));
		}
        
		callback.onSuccess(records);
	}	

	private ImageWidget getTrackingStatusImage(String status) {
		ImageWidget trackStatusImage = new ImageWidget();
		trackStatusImage.addStyleName(STYLE_ICON);
		bundle.updateTrackingStatusIcon(trackStatusImage, status);

		return trackStatusImage;
	}	
	
	
	/**
	 * @return the parentPageFeature
	 */
	public PageFeature getParentPageFeature() {
		return parentPageFeature;
	}

	/**
	 * @param parentPageFeature the parentPageFeature to set
	 */
	public void setParentPageFeature(PageFeature parentPageFeature) {
		this.parentPageFeature = parentPageFeature;
	}
	

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		/* do nothing */
		callback.onSuccess(null);
	}

	/**
	 * No check box required for this table
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isCheckboxEnabled()
	 */	
	@Override
	public boolean isCheckboxEnabled() {
		return false;
	}

	/**
	 * The total record count is displayed for the table
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider#isRecordCountEnabled()
	 */	
	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
		
	/* Get the tracking site column value */
	private String getTrackingSiteValue(UITrackingSiteItem trackingSiteItem) {
		return trackingSiteItem.getName();
	}	

	/* Get the tracking site id value */
	private String getTrackingSiteIdValue(UITrackingSiteItem trackingSiteItem) {
		return trackingSiteItem.getSiteId().toString();
	}	
	
	/* Get the status column value */
	private String getStatusValue(UITrackingSiteItem trackingSiteItem) {
		return trackingSiteItem.getStatus().toString();
	}	
		
}
