package com.tandbergtv.cms.portal.content.client.title.view.sites;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIActiveDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UIDistributionSiteItem;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITitleSites;
import com.tandbergtv.cms.portal.content.client.title.model.sites.UITrackingSiteItem;
import com.tandbergtv.cms.portal.content.client.title.view.activity.TitleActivityTab;
import com.tandbergtv.cms.portal.content.client.title.view.metadata.TitleValidationViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.InlineLabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



class SitesPanel extends SimpleContainer {

	private TitleSitesTab parent;
	private VerticalContainer mainContainer;
	private DisclosureContainer statusDisclosureContainer; 
	private SimpleContainer targetingFeaturePanel;
	private DisclosureContainer targetingDisclosureContainer; 
	private VerticalContainer statusDisclosureContents;
	private VerticalContainer targetingDisclosureContents;

	//widgets for the status disclosure panel contents
	private ListBoxWidget<String> filterListBox;
	private HorizontalContainer filterListContainer;
	private DistributionSiteItemDataProvider dataProviderDistributionSites;
	private Table<UIDistributionSiteItem, DistributionSiteItemRecord> tableDistributionSites;
	private TrackingSiteItemDataProvider dataProviderTrackingSites;
	private Table<UITrackingSiteItem, TrackingSiteItemRecord> tableTrackingSites;
	private PageFeature pageFeature;
	private HeaderPanel header;
	private SucessPanel getSitesSuccessMessagePanel;
	
	//widgets for the manual targeting disclosure panel contents
	private ErrorPanel targetingErrorMessagePanel;
	private FlowPanel targetingSuccessMessagePanel;
	private ListBoxWidget<String> activeDistributionSiteListBox;
	private LabelWidget sitesSelectionLabel;
	private RadioButtonWidget useRulesRadioButton;
	private RadioButtonWidget selectSitesRadioButton;
	private ButtonWidget targetButton;
	private HorizontalContainer targetOptionsContainer;
	private HorizontalContainer activeDistributionSiteListContainer;
	//need this map as current listbox wrapper does not allow getting text from key.
	private Map<String,Integer> siteIdLookup = new HashMap<String,Integer>();
	//previous user selections:
	private String siteFilter;
	private Set<String> selectedSites = new TreeSet<String>();
	boolean targetSelectSitesOption = true;
	
	private UITitleSites sites = null;
	
	// spacing between the table and message panel 
	private static final int SPACING = 2;
	private static final int VISIBLE_ITEMS = 5;
	private static final String STYLE_NAME = "content-TitleListsPanel";
	private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
	private String SUCCESS_MESSAGE_STYLE1 = "content-TitleView-feedbackPopup" ; //"titleViewFeedbackPopup";
	private String SUCCESS_MESSAGE_STYLE2 = "content-TitleView-feedbackLabel"; //"titleViewFeedbackLabel";

	
	public SitesPanel(TitleSitesTab parent) {
		this.parent = parent;
		this.dataProviderDistributionSites = new DistributionSiteItemDataProvider(this);
		
		this.dataProviderTrackingSites = new TrackingSiteItemDataProvider(this);
		init();
	}

	/**
	 * Get the parent title sites tab
	 * 
	 * @return The title sites tab
	 */
	protected TitleSitesTab getTab() {
		return parent;
	}
	
	private void init() {
		initWidgets();
		setContainers();
	}
	
	private void setContainers() {
		statusDisclosureContents.add(getSitesSuccessMessagePanel);
		//tableTrackingSites.registerWidgetOnActionContainer(filterListContainer);
		statusDisclosureContents.add(tableDistributionSites);
        statusDisclosureContents.add(header);
        statusDisclosureContents.add(filterListContainer);
		statusDisclosureContents.add(tableTrackingSites);		
		statusDisclosureContainer.setContent(statusDisclosureContents);

		targetingDisclosureContents.add(targetingErrorMessagePanel);
		targetingDisclosureContents.add(targetingSuccessMessagePanel);
		targetingDisclosureContents.add(targetOptionsContainer);
		targetingDisclosureContents.add(activeDistributionSiteListContainer);
		targetingDisclosureContainer.setContent(targetingDisclosureContents);
				
		mainContainer.add(statusDisclosureContainer);
		mainContainer.add(targetingFeaturePanel);
	
		/* Show a blank label in the container */
		LabelWidget blankLabel = new LabelWidget("");
		this.setWidget(blankLabel);		
	}

	private void initWidgets() {
		mainContainer = new VerticalContainer();
		mainContainer.setSpacing(SPACING);
		mainContainer.setStylePrimaryName(STYLE_NAME);

		
		statusDisclosureContainer = new RoundedDisclosureContainer(this.getTab().getViewMessages().sitesStatusDisclosurePanelName(),true);
		statusDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
		statusDisclosureContents = new VerticalContainer();
		
		targetingFeaturePanel = new SimpleContainer();
		targetingDisclosureContainer = new RoundedDisclosureContainer(this.getTab().getViewMessages().sitesManualTargetingDisclosurePanelName(),true);
		targetingDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
		targetingDisclosureContents = new VerticalContainer();
		targetingDisclosureContents.setSpacing(SPACING);
		
		header = new HeaderPanel("");
		getSitesSuccessMessagePanel = new SucessPanel();
		getSitesSuccessMessagePanel.setVisible(false);
		
		
		tableDistributionSites = new Table<UIDistributionSiteItem, DistributionSiteItemRecord>(dataProviderDistributionSites);
		
		buildFilterListWidget();		
		
		tableTrackingSites = new Table<UITrackingSiteItem, TrackingSiteItemRecord>(dataProviderTrackingSites);
		// page feature
		pageFeature = new PageFeatureImpl();
		dataProviderTrackingSites.setParentPageFeature(pageFeature);						 
		tableTrackingSites.addPageFeature(pageFeature);	
		

		//Build widgets in the Manual Targeting panel
		// error message panel
		targetingErrorMessagePanel = new ErrorPanel();
		targetingErrorMessagePanel.setVisible(false);
		// or else right border doesn't show up
		targetingErrorMessagePanel.setWidth("99%");

		// sucessMessagePanel
		//targetingSuccessMessagePanel = new SucessPanel();
		targetingSuccessMessagePanel = new FlowPanel(); 
		InlineLabelWidget activityViewLabel = new InlineLabelWidget(this.getTab().getViewMessages().activityTabName());
		activityViewLabel.addStyleName(TableConstants.STYLE_DATA_LINK);
		activityViewLabel.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				handleActivityViewLabelClick();
			}
		});
		InlineLabelWidget targetingInitiatedLabel1 = new InlineLabelWidget(this.getTab().getViewMessages().targetInitiatedMessage());
		addSuccessStyleForLabel(targetingInitiatedLabel1);
		addSuccessStyleForLabel(activityViewLabel);
		targetingSuccessMessagePanel.add(targetingInitiatedLabel1);	
		targetingSuccessMessagePanel.add(activityViewLabel);
		targetingSuccessMessagePanel.setVisible(false);
				
		buildTargetingOptionRadioButtonWidget();
		buildActiveDistributionSiteListWidget();
		//default
		sitesSelectionLabel.setVisible(true);
		activeDistributionSiteListBox.setVisible(true);		
	}

	private void addSuccessStyleForLabel(InlineLabelWidget labelWidget) {
		labelWidget.addStyleName(SUCCESS_MESSAGE_STYLE1);
		labelWidget.addStyleName(SUCCESS_MESSAGE_STYLE2);
	}
	
	private void handleActivityViewLabelClick() {
	   parent.getTitleView().showTab(TitleActivityTab.TAB_NAME);
	}
	
	private void buildFilterListWidget() {
		filterListContainer = new HorizontalContainer();
		filterListContainer.setSpacing(SPACING);
		
		String message = this.getTab().getViewMessages().distributionSiteFilterLabel();
		LabelWidget filterLabel = new LabelWidget(message);		
		
		// Create filter listbox. When the user selects one of the distribution site, refresh the table to shown only 
		// the tracking sites for the selected distribution site. Default is all
		filterListBox = new ListBoxWidget<String>(false);
		filterListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
				refreshTrackingSitesTable();
			}
		});

		//add filter label & listbox to container
		filterListContainer.add(filterLabel);
		filterListContainer.add(filterListBox);		
	}

	private void buildTargetingOptionRadioButtonWidget() {
		targetOptionsContainer = new HorizontalContainer();
		targetOptionsContainer.setSpacing(SPACING);
		
		String message = this.getTab().getViewMessages().targetingOptionLabel();
		LabelWidget optionsLabel = new LabelWidget(message);		
		
		// Create target options radiobutton. When the user click on "Using Rules", the sites listbox should be 
		// disabled
		String rulesOption = this.getTab().getViewMessages().usingRulesOption();
		String selectSitesOption = this.getTab().getViewMessages().selectSitesOption();
		useRulesRadioButton = new RadioButtonWidget("TargetOptions", rulesOption);
		selectSitesRadioButton = new RadioButtonWidget("TargetOptions", selectSitesOption);
		useRulesRadioButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				if (sitesSelectionLabel.isVisible() == true)
					sitesSelectionLabel.setVisible(false);
				if ( activeDistributionSiteListBox.isVisible() == true)
					activeDistributionSiteListBox.setVisible(false);
			}

		});
		selectSitesRadioButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				if (sitesSelectionLabel.isVisible() == false)
					sitesSelectionLabel.setVisible(true);
				if ( activeDistributionSiteListBox.isVisible() == false)
					activeDistributionSiteListBox.setVisible(true);
			}

		});			
		if (targetSelectSitesOption == true)
			selectSitesRadioButton.setValue(true);
		else
			selectSitesRadioButton.setValue(false);
				
		//add options label & radiobutton to container
		targetOptionsContainer.add(optionsLabel);
		targetOptionsContainer.add(useRulesRadioButton);		
		targetOptionsContainer.add(selectSitesRadioButton);		
	}
	
	private void buildActiveDistributionSiteListWidget() {
		activeDistributionSiteListContainer = new HorizontalContainer();
		activeDistributionSiteListContainer.setSpacing(SPACING);
		
		String message = this.getTab().getViewMessages().sitesSelectionLabel();
		sitesSelectionLabel = new LabelWidget(message);		
		
		// Create listbox for selecting one or more active distribution sites to target to
		activeDistributionSiteListBox = new ListBoxWidget<String>(true);
		activeDistributionSiteListBox.setVisibleItemCount(VISIBLE_ITEMS);
		
		
		targetButton = new ButtonWidget(this.getTab().getViewMessages().manualTargetingButton());
		targetButton.addClickHandler(new TargetClickListener(this));
		targetButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		
		//add sites label & listbox to container
		activeDistributionSiteListContainer.add(sitesSelectionLabel);
		activeDistributionSiteListContainer.add(activeDistributionSiteListBox);		
		activeDistributionSiteListContainer.add(targetButton);		
		
	}

	/*
	 * Populate the listbox with the distribution site names which user can use to filter the tracking sites
	 */	
	private void populateFilterListBox(List<UIDistributionSiteItem> distSiteItems ) {
		filterListBox.clear();
		filterListBox.setVisibleItemCount(1);
		String allItems = this.getTab().getViewMessages().distributionSiteFilterForAll();
		filterListBox.addItem(allItems, allItems);
		if (siteFilter == null || siteFilter.isEmpty())
			siteFilter = allItems;
		for (UIDistributionSiteItem item : distSiteItems) {
			filterListBox.addItem(item.getName(), item.getName());
			if (siteFilter.equals(item.getName())) {
				filterListBox.setItemSelected(filterListBox.getIndex(item.getName()), true);
			}
		}

		for (int i = 0, l = filterListBox.getItemCount(); i < l; i++) {
			String siteName = filterListBox.getItemText(i);
			if (siteName.equals(siteFilter) == true)
				filterListBox.setItemSelected(i, true);
		}
	}

	/*
	 * Called by the data provider for tracking sites to display the tracking sites
	 */	
	String getSelectedDistributionSiteInFilter() 
	{
		String selectedItem = filterListBox.getSelectedItem();
		if(selectedItem == null) return null;
		
		String allItems = this.getTab().getViewMessages().distributionSiteFilterForAll();
		if (selectedItem.equals(allItems) == true)
			return null;
		else
			return selectedItem;
	}
	
	/*
	 * Populate the listbox with active distribution sites which user can select to do manual targeting
	 */
	private void populateActiveDistributionSiteList(List<UIActiveDistributionSiteItem> activeDistSiteItems){
		activeDistributionSiteListBox.clear();
		siteIdLookup.clear();
		for (UIActiveDistributionSiteItem item : activeDistSiteItems) {
			activeDistributionSiteListBox.addItem(item.getName(), item.getSiteId().toString());
			siteIdLookup.put(item.getName(), new Integer(item.getSiteId().intValue()));
		}
		
		//set to previous selection of site(s)
		for (int i = 0, l = activeDistributionSiteListBox.getItemCount(); i < l; i++) {
			String activeSiteName = activeDistributionSiteListBox.getItemText(i);
			if (selectedSites.contains(activeSiteName) == true )
				activeDistributionSiteListBox.setItemSelected(i,true);
		}
		
	}	

	boolean isSelectSites() {
		if (selectSitesRadioButton.getValue() == true)
			return true;
		else
			return false;
	}
	
	/*
	 * Return the list of site ids that are selected by user to do manual targeting
	 */	
	List<Integer> getSelectedSiteIds() {
		List<Integer>  siteIds = new ArrayList<Integer>();
		for (int i = 0, l = activeDistributionSiteListBox.getItemCount(); i < l; i++) {
			if (activeDistributionSiteListBox.isItemSelected(i)) {
				String siteName = activeDistributionSiteListBox.getItemText(i);
				siteIds.add(siteIdLookup.get(siteName));
			}
		}
		return siteIds;
	}
	
	/*
	 * Preserve user selections so that they can be restored
	 */		
	void setPreviousSelections() {
		String selectedItem = filterListBox.getSelectedItem();
		siteFilter = selectedItem;

		if (selectSitesRadioButton.getValue() == true)
			targetSelectSitesOption = true;
		else
			targetSelectSitesOption = false;
		
		selectedSites.clear();
		for (int i = 0, l = activeDistributionSiteListBox.getItemCount(); i < l; i++) {
			if (activeDistributionSiteListBox.isItemSelected(i)) {
				String siteName = activeDistributionSiteListBox.getItemText(i);
				selectedSites.add(siteName);
			}
		}
	}
		
	private void refreshDistributionSitesTable(){
		if (!tableDistributionSites.isInitialized()) {
			tableDistributionSites.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableDistributionSites.refresh();
				}
			});
		} else {
			tableDistributionSites.refresh();
		}
	}
	
	
	private void refreshTrackingSitesTable() {
		if (!tableTrackingSites.isInitialized()) {
			tableTrackingSites.initialize(new NeptuneAsyncCallback<Void>() {
				@Override
				public void onNeptuneFailure(Throwable caught) {
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					tableTrackingSites.refresh();
				}
			});
		} else {
			tableTrackingSites.refresh();
		}
	}
			
	UITitleSites getUITitleSites() {
		return sites;
	}
	
	void handleGetTitleSiteRecordsSuccess(UITitleSites sites) {
		this.sites = sites;
		/* If there is no distribution sites for this title, hide the table */
		if (sites.getDistributionSiteItems().size() == 0) {
			// Hide the table
			String message = getTab().getViewMessages().distributionSitesNotPresent();
			tableDistributionSites.setVisible(false);
			filterListContainer.setVisible(false);
			tableTrackingSites.setVisible(false);
			getSitesSuccessMessagePanel.setVisible(true);
			getSitesSuccessMessagePanel.showSuccessMessage(message);
		} else {
			getSitesSuccessMessagePanel.reset();
			getSitesSuccessMessagePanel.setVisible(false);

			/* Ensure that the table widget is showing */
			tableDistributionSites.setVisible(true);
			filterListContainer.setVisible(true);
			tableTrackingSites.setVisible(true);

			/* Update the drop down of distribution site items */
			populateFilterListBox(sites.getDistributionSiteItems());
		}

		refreshDistributionSitesTable();
		refreshTrackingSitesTable();

		/* Determine if the targeting feature should be shown */
		if (ClientAuthorizationManager.isAuthorized(Permissions.SITE_TARGET)) {
			targetingFeaturePanel.setWidget(targetingDisclosureContainer);
		} else {
			targetingFeaturePanel.clear();
		}

		populateActiveDistributionSiteList(sites.getActiveDistributionSiteItems());
		activeDistributionSiteListBox.setVisible(isSelectSites());

		//Hide the message panels in the targeting section
		targetingSuccessMessagePanel.setVisible(false);
		targetingErrorMessagePanel.setVisible(false);

		/* Show the main container if not already visible */
		if (getWidget() != mainContainer)
			setWidget(mainContainer);
	}

	void showTargetingInitiatedMessage() {
		targetingSuccessMessagePanel.setVisible(true);
		targetingErrorMessagePanel.setVisible(false);
	}
	
	void reportNoSitesTargeted() {
		targetingErrorMessagePanel.setWidth("99%");
		targetingErrorMessagePanel.showErrorMessage(this.getTab().getViewMessages().targetRulesNoSiteTargetedMessage());
		targetingErrorMessagePanel.setVisible(true);
		targetingSuccessMessagePanel.setVisible(false);
	}	
	
	void reportFailure(String errMsg) 
	{
		TitleValidationViewInput input = new TitleValidationViewInput();
		input.setErrorHeader(errMsg);
		this.getTab().getTitleView().showMessage(input);
	}	
}
